% --------------------------------------------------------------------
%{ 
  	make_frcst_comp.m:    
  	Compute forecasts and forecast error statistics for the
  	empirical section.
   
    Replication files for the paper
 
    "Simple Identification and Specification of Cointegrated VARMA
    Models"
  
    by Christian Kascha and Carsten Trenkler. 
    (final version: January, 2014)
%}
% --------------------------------------------------------------------


clear; 

% Set paths:
addpath('mfiles'); 
addpath('mfiles/KronIdx'); 
inputdir='data\';
outputdir='output_rev\';
graphicsdir='graphs\';


% Set basic parameters:
h_max=12;
dataset='full'; 
T_s=200; 

% Load data set specifics & data set
switch dataset
	case{'full'}
		[system_mat,ci_v,yield_data,dates]=get_US_config_new(inputdir); 
	otherwise
		error('invalid data set');
end

% Loop over systems in dataset 
for s=1:8;    
	
	indx=cell2mat(system_mat(s));
	y=yield_data(:,indx);	
	ci_r=ci_v(s); 
	
%     %rw model
%  	foptions.dVAR=0; 
%  	results=backtest(@rwmodel,'RWmodel',dates,y,foptions,T_s,h_max); 
%  	filename=[outputdir 'results_RWmodel_dataset_' dataset '_system_' num2str(s)];   
%     save(filename,'results');  
% 	
% 	%var model  
%  	foptions.dVAR=0;
%  	foptions.LagOrder='sc';			% BIC 
%  	foptions.minp=1; foptions.maxp=[];
%  	foptions.InterceptDummy=1; 
%  
%  	results=backtest(@estimate_var,'VAR',dates,y,foptions,T_s,h_max); 
%  	filename=[outputdir 'results_VAR_dataset_' dataset '_system_' num2str(s)];   
%     save(filename,'results'); 
% 
% 
% 	%vecm model  
%  	foptions.dVAR=0;
%  	foptions.CointOrder=size(y,2)-1;
%  	foptions.LagOrder='sc';			% BIC 
%  	foptions.minp=1; foptions.maxp=[];
%  	foptions.InterceptDummy=2; 
%  
%  	results=backtest(@estimate_vecm,'VECM',dates,y,foptions,T_s,h_max); 
%  	filename=[outputdir 'results_VECM_dataset_' dataset '_system_' num2str(s)];   
%     save(filename,'results');  
% 	

  	% coint. varma - poskitt method - fma form: 
	foptions.dVAR=0; 
	foptions.CointOrder=size(y,2)-1;
	foptions.LagOrder='dp';
    foptions.Identification='fma'; 
	foptions.minp=1; foptions.maxp=[];
	foptions.minq=0; foptions.maxq=[];
    

%   	results=backtest(@estimate_civarma_poskitt,'ciVARMA_pos',dates,y,foptions,T_s,h_max); 
%   	filename=[outputdir 'results_VARMA_pos_dataset_ecm_' dataset '_system_' num2str(s)];   
%     save(filename,'results');  

	% coint varma - yap & reinsel 
  	results=backtest(@estimate_civarma_yapreinsel,'ciVARMA_yr',dates,y,foptions,T_s,h_max); 
  	filename=[outputdir 'results_VARMA_yr_dataset_ecm_' dataset '_system_' num2str(s)];   
    save(filename,'results');  

    
    % varma - Dufour & Pelletier 
    foptions.CointOrder=size(y,2);
 	results=backtest(@estimate_civarma_yapreinsel,'ciVARMA_yr',dates,y,foptions,T_s,h_max); 
 	filename=[outputdir 'results_VARMA_dp_dataset_' dataset '_system_' num2str(s)];   
    save(filename,'results'); 
     
    % coint. varma - poskitt method - echelon form:  
    foptions.LagOrder='PL2';
    foptions.Identification='rec';
    foptions.CointOrder=size(y,2)-1;
    foptions.minKronIdx=[1;1;1;1;1]; %can also be used for smaller systems
      
%   	results=backtest(@estimate_civarma_poskitt,'ciVARMA_pos',dates,y,foptions,T_s,h_max); 
%   	filename=[outputdir 'results_VARMA_pos_ech_dataset_' dataset '_system_' num2str(s)];   
%     save(filename,'results');  
     
 	% coint varma - yap & reinsel - echelon form: 
  	results=backtest(@estimate_civarma_yapreinsel,'ciVARMA_yr',dates,y,foptions,T_s,h_max); 
  	filename=[outputdir 'results_VARMA_yr_ech_dataset_' dataset '_system_' num2str(s)];   
    save(filename,'results');  

		
end	











