% --------------------------------------------------------------------
%{ 
    make_com2RW_graph.m: 
    Make graphs showing cumulative sums of (differences of) 
    squared prediction errors to compare relative forecast 
    performance over time.
   
    Replication files for the paper
 
    "Simple Identification and Specification of Cointegrated VARMA
    Models"
  
    by Christian Kascha and Carsten Trenkler. 
    (final version: January, 2014)
%}
% --------------------------------------------------------------------

close all; 
clear all; 

% Set paths:
addpath('mfiles'); 
inputdir='output_rev/';
graphicsdir='../text/graphs/';
datadir='data/';


% Set basic parameters:
dataset='full';
eval_horizons=[1 6 12]; 

% evaluated system: 3-months & 1-year maturities: 
s=2; 
legend_str={'3M', '1Y'}; 
legend_loc='NorthWest'; 

[system_mat,ci_v,yield_data,dates]=get_US_config_new(datadir); 


% --------------------------------------------------------------------

% load data
    filename=[inputdir 'results_RWmodel_dataset_' dataset '_system_' num2str(s)];   
    load(filename)
    rw_results=results;

    filename=[inputdir 'results_VECM_dataset_' dataset '_system_' num2str(s)];   
    load(filename)
    vecm_results=results;

    filename=[inputdir 'results_VARMA_yr_dataset_ecm_' dataset '_system_' num2str(s)];   
    load(filename)
    varma_yr_results=results;


for h_idx = 1:length(eval_horizons)

    h = eval_horizons(h_idx);
    
    % make comparison 
    plot_cumse(rw_results,vecm_results,h); 
    legend(legend_str,'Location',legend_loc,'FontSize', 12) 
    title('RW vs. VECM', 'FontSize', 12) 
    set(gca,'FontSize',12)
    save2pdf([graphicsdir 'vecm_h' num2str(h)], gcf) 
    
    plot_cumse(rw_results,varma_yr_results,h);  
    legend(legend_str,'Location',legend_loc,'FontSize',12) 
    title('RW vs. Coint. VARMA', 'FontSize', 12) 
    set(gca,'FontSize',12); 
    save2pdf([graphicsdir 'varma_h' num2str(h)], gcf) 
       
end
    


    
    
    
    
    

    
    
    
    
    
    
    
    
    
    
    