% --------------------------------------------------------------------
%{ 
    make_all_tables.m: 
    Create two tables, one table with MSPE numbers, one table
    with numbers for det(MSPE_mat) 
   
    Replication files for the paper
 
    "Simple Identification and Specification of Cointegrated VARMA
    Models"
  
    by Christian Kascha and Carsten Trenkler. 
    (final version: January, 2014)
%}
% --------------------------------------------------------------------

clear; 

% --------------------------------------------------------------------
% BASIC SETTINGS:


  % Set paths:
addpath('mfiles'); 
inputdir='output_rev\';
datadir='data\';
outputdir='..\text\';

  % Set basic parameters:
dataset='full'; 
eval_horizons=[1 3 6 12]; 


% Load data set specifics & data set
switch dataset
	case{'full'}
		[system_mat,ci_v,yield_data,dates]=get_US_config_new(datadir); 
	otherwise
		error('invalid data set');
end


% --------------------------------------------------------------------

table_1=[]; 
table_2=[]; 

for s=1:8;%size(system_mat,1);

    
	filename=[inputdir 'results_RWmodel_dataset_' dataset '_system_' num2str(s)];   
    load(filename)
	rw_results=results;

	filename=[inputdir 'results_VAR_dataset_' dataset '_system_' num2str(s)];   
	load(filename)
	var_results=results;
	
	filename=[inputdir 'results_VECM_dataset_' dataset '_system_' num2str(s)];   
	load(filename)
	vecm_results=results;    	
   
    filename=[inputdir 'results_VARMA_yr_dataset_ecm_' dataset '_system_' num2str(s)];   
	load(filename)
	varma_yr_results=results;
  
    filename=[inputdir 'results_VARMA_dp_dataset_' dataset '_system_' num2str(s)];   
	load(filename)
	varma_dp_results=results;
    
    filename=[inputdir 'results_VARMA_yr_ech_dataset_' dataset '_system_' num2str(s)];   
    load(filename)
	varma_yr_ech_results=results; 
	
	[T,K]=size(rw_results.data); 
	
	% Obtaining results for individual series
    % Saved in Table 1
    
	for series_idx=1:K;
        
        table_row=zeros(1,24);
        col_idx=1;
        
        for model_i=1:6;
    
            switch model_i
                case 1
                    results=rw_results;
                case 2
                    results=varma_yr_results;
                case 3
                    results=vecm_results;
                case 4    
                    results=varma_yr_ech_results; 
                case 5
                    results=varma_dp_results;
                case 6; 
                    results=var_results; 
            end;

			actuals=results.data(:,series_idx); 
				
            for h_i=1:numel(eval_horizons); 
				
					h=eval_horizons(h_i); 
                    
					frcsts=results.frcsts_L(series_idx,h,:); 
					frcsts=squeeze(frcsts); 
					
					frcst_errors=[nan(h,1);frcsts(1:(end-h),:)]-actuals;               
					mse=nanmean(frcst_errors.^2); 
					
					if (model_i>1)
						mse=mse/table_row(:,h_i);
					end
										
                    table_row(:,col_idx)=mse;     
                    col_idx=col_idx+1;
                
			end; 
           
        end;
			
            table_1=[table_1;
						table_row];
    end
	
    
    
    
    
    % Obtaining results for whole system
    % Saved in Table 2 
    
    frcst_error_matrix = nan(T,K);
    table_row=zeros(1,24);
    col_idx=1;  
            
	for model_i=1:6;
       switch model_i
                case 1
                    results=rw_results;
                case 2
                    results=varma_yr_results;
                case 3
                    results=vecm_results;
                case 4    
                    results=varma_yr_ech_results; 
                case 5
                    results=varma_dp_results;
                case 6; 
                    results=var_results; 
        end;
    
   
        for h_i=1:numel(eval_horizons);
            
            h=eval_horizons(h_i); 
            
            for series_idx=1:K; 
				    
                actuals=results.data(:,series_idx);
					
			    frcsts=results.frcsts_L(series_idx,h,:); 
				frcsts=squeeze(frcsts); 
					
				frcst_error_matrix(:,series_idx)=[nan(h,1);frcsts(1:(end-h),:)]-actuals;               		   
			end; 
            
            condition=isnan(frcst_error_matrix(:,1)); 
            frcst_error_matrix(condition,:)=[];
            [T_f, K_f] = size(frcst_error_matrix);
            mse = det(frcst_error_matrix'*frcst_error_matrix/T_f);
            
            if (model_i>1)
                mse=mse/table_row(:,h_i);
            end
            
            table_row(:,col_idx)=mse;     
            col_idx=col_idx+1;
            frcst_error_matrix = nan(T,K);
        end;
    end    
    
    table_2=[table_2;table_row];
      
end	


mat=table_1(:,1:12);

str_tablehead='  & \multicolumn{ 4}{c}{RW} &  & \multicolumn{ 4}{c}{EC-VARMA-YR-FMA} &  & \multicolumn{ 4}{c}{VECM}\\';
str_tablehead=[str_tablehead ' \cline{2-5} \cline{7-10} \cline{12-15} & 1 &  3 &   6 &  12 &   &   1 &  3 &  6 & 12 &     &   1 &    3 &    6 &  12 \\  \hline '];

cellstr_column_names={'3M';'6M';'3M';'1Y';'3M';'5Y';'3M';'10Y';'3M';'6M';'1Y';'1Y';'5Y';'10Y';'3M';'1Y';'10Y';'3M';'6M';'1Y';'5Y';'10Y'}; 
str_tablenote='the table reports mean squared prediction errors (mspes) for systems with different maturities and different models.'; 
str_tablenote=[ str_tablenote ' ec-varma-yr-fma refers to the cointegrated varma model identified via the fma-form and estimated via the method of yap \& reinsel (1995).' ];
str_tablenote=[ str_tablenote ' the entries for ec-varma-yr-fma and the vecm are relative to the random walk.' ];
str_filename='../text/table_1.tex'; 
str_caption='comparison of mean squared prediction errors';
str_label='msperesults';
int_hlines=[2 4 6 8 11 14 17];
idx_bold=zeros(size(mat,1),size(mat,2)); 
int_vspaces=[4 8]; 
sideways=1;
table=mat2table(mat,...
    cellstr_column_names,str_tablenote,str_filename,str_caption,str_label,str_tablehead,idx_bold,int_hlines,int_vspaces,sideways);


str_tablehead='  & \multicolumn{ 4}{c}{EC-VARMA-YR-ECH} &  & \multicolumn{ 4}{c}{VARMA-FMA} &  & \multicolumn{ 4}{c}{VAR}\\';
str_tablehead=[str_tablehead ' \cline{2-5} \cline{7-10} \cline{12-15} & 1 &  3 &   6 &  12 &   &   1 &  3 &  6 & 12 &     &   1 &    3 &    6 &  12 \\  \hline '];
str_filename='../text/table_2.tex'; 

table=mat2table(table_1(:,13:end),...
    cellstr_column_names,str_tablenote,str_filename,str_caption,str_label,str_tablehead,idx_bold,int_hlines,int_vspaces,sideways);



% ----------------------------------------------

mat=table_2(:,1:12); 

str_tablehead='  & \multicolumn{ 4}{c}{RW} &  & \multicolumn{ 4}{c}{EC-VARMA-YR-FMA} &  & \multicolumn{ 4}{c}{VECM}\\';
str_tablehead=[str_tablehead ' \cline{2-5} \cline{7-10} \cline{12-15} & 1 &  3 &   6 &  12 &   &   1 &  3 &  6 & 12 &     &   1 &    3 &    6 &  12 \\  \hline '];

cellstr_column_names={'3M, 6M';'3M, 1Y';'3M, 5Y';'3M, 10Y';'3M, 6M, 1Y';'3M, 1Y, 10Y';'1Y, 5Y, 10Y';'3M-10Y'}; 
str_tablenote='The table reports the determinants of the mean squared prediction error matrices for systems with different maturities and different models.'; 
str_tablenote=[ str_tablenote ' EC-VARMA-YR-FMA refers to the cointegrated VARMA model identified via the FMA-form and estimated via the method of Yap \& Reinsel (1995).' ];
str_tablenote=[ str_tablenote ' The entries for EC-VARMA-YR-FMA and the VECM are relative to the random walk.' ];
str_filename='../text/table_1_sys.tex'; 
str_caption='Comparison of determinants of mean squared prediction error matrices';
str_label='det:MSPEresults';
int_hlines=[1 2 3 4 5 6 7 8 9 10];
Idx_bold=zeros(size(mat,1),size(mat,2)); 
int_vspaces=[4 8]; 
sideways=1;
table=mat2table(mat,cellstr_column_names,str_tablenote,str_filename,str_caption,str_label,str_tablehead,Idx_bold,int_hlines,int_vspaces,sideways);



mat=table_2(:,13:end); 

str_tablehead='  & \multicolumn{ 4}{c}{EC-VARMA-YR-ECH} &  & \multicolumn{ 4}{c}{VARMA-FMA} &  & \multicolumn{ 4}{c}{VAR}\\';
str_tablehead=[str_tablehead ' \cline{2-5} \cline{7-10} \cline{12-15} & 1 &  3 &   6 &  12 &   &   1 &  3 &  6 & 12 &     &   1 &    3 &    6 &  12 \\  \hline '];

str_filename='../text/table_2_sys.tex'; 

table=mat2table(mat,cellstr_column_names,str_tablenote,str_filename,str_caption,str_label,str_tablehead,Idx_bold,int_hlines,int_vspaces,sideways);






