% --------------------------------------------------------------------
%{ 
    MCcomp_hT_nu_choices.m:
    Produce Monte Carlo study to compare the effects of the choices 
    for the h_T, nu - parameters for order estimation. 

    Replication files for the paper
 
    "Simple Identification and Specification of Cointegrated VARMA
    Models"
  
    by Christian Kascha and Carsten Trenkler. 
    (final version: January, 2014)
%}
% --------------------------------------------------------------------

clear all; 
dbstop if error

% -------------------------------------------------------------------------
% Set paths:
addpath('mfiles'); 
addpath('mfiles/KronIdx'); 
outputdir='output_rev\';
graphicsdir='graphs\';


% -------------------------------------------------------------------------
%% set parameters of MC study 

%SampleSizeSet=[50, 100, 200];  
SampleSizeSet=[50];  

%R=1000; 
R=10; 


h_max=8;
%rng('default'); 
randn('state',0); 

dgpset=[1 2 3 6]; 

designset=[ 1.25 0.2 1.00;
			1.25 0.5 1.00;
			1.25 0.8 1.00;
			1.25 0.5 0.75;
			1.25 0.5 1.00;
			1.25 0.5 2.00]; 

numb_designs=size(designset,1); 
        
marker_str=['b--';
               'g<-';
               'rx-';
               'c+-';
               'm*-';
               'ks-']; 
            
foptions.minp=1;
foptions.minq=0;
foptions.Identification = 'fma'; 


% -------------------------------------------------------------------------
%% MC Study 

fig_number=1; 

for T = SampleSizeSet; 

	for dgp=dgpset; 

		VARMAmodel_true=setVARMAparameters(dgp); 
		IR_true=varma_irfun(VARMAmodel_true,h_max); 

		% set general estimation options
		foptions.CointOrder = rank(VARMAmodel_true.alfa); 
		K=size(VARMAmodel_true.A_0,1); 
        
        %% start loop over replications: 
        ir_error=nan(R,h_max+1,numb_designs);
		frcst_error=nan(R,h_max,numb_designs);
        chosenOrders=nan(R,2,numb_designs);
		CountEstFail=zeros(1,numb_designs); 

        for r=1:R; 
			T
            dgp
            r
            %current_state=rng; 
            % rng(s) reproduces results
                
                % Former syntax: 
                current_state=randn('state');  
                %  % randn('state',current_state) reproduces results

            
			% simulate DGP 
				[ts_data,ts_errors]=simulateVARMAmodel(VARMAmodel_true,T+h_max); 
				ts_fdata=ts_data(T+1:T+h_max,:); 
				ts_data=ts_data(1:T,:);

		 
            for d = 1:numb_designs; 
                   
                % specify accroding to design

                    h_T=floor(designset(d,3)*log(T)^(designset(d,1)));
                    nu=designset(d,2); 
                    
                    foptions.maxp=h_T;
                    foptions.maxq=h_T; 

                    y=ts_data';   
                    mean_y=mean(y')';
                    yma=y-kron(ones(1,T),mean_y);

                    [crit_mat,crit_p,crit_q]=ord_varma_fma(yma,foptions.minp,foptions.maxp,foptions.minq,foptions.maxq,h_T,nu);
                    
                    pq=[crit_p;
                        crit_q]; 	
                    foptions.LagOrder=pq;
                    chosenOrders(r,:,d)=pq';   

                % estimate  
                    VARMAmodel_est=estimate_civarma_poskitt(ts_data,foptions);

                    if(max(abs(calcEigAR(VARMAmodel_est))) > 1.1)
                        VARMAmodel_est=rwmodel(ts_data); 
                        CountEstFail(d)=CountEstFail(d)+1;
                    end

                    IR_est=varma_irfun(VARMAmodel_est,h_max);
                    ir_error(r,:,d)=dist_IR(IR_est,IR_true); 

                    frcst=varma_frc(VARMAmodel_est,h_max); 
                    frcst_error(r,:,d)=dist_IR(frcst,ts_fdata'); 

            end; % end of loop over desgins 
		end; % end for-loop over replications r=1...R
        
			
        %% save stuff for this combination of DGP and SampleSize
        CountEstFail=CountEstFail/R; 
        save([outputdir 'CountEstFail_MC2_DGP' num2str(dgp) 'T' num2str(T)],'CountEstFail'); 
       
        
        % ----------------------------------------------
        figure(fig_number);

        numMat=chosenOrders(:,:,1:3); 
        count_mat=countFreqCategories(numMat); 
        
        bar(count_mat.RelFreq);
        labels=num2str(count_mat.Categories);
        set(gca,'XTickLabel',labels);
        ylabel('Rel Freq.');
        xlabel('Est. Lag Orders (p,q)'); 
        ylim([0 1]);

        a_str={'1';'2';'3'}; 
        legend(a_str,'FontSize', 12) 
        set(gca,'FontSize',12)

        save2pdf(['graphs/MC4_ORDERS_DGP' num2str(dgp) 'T' num2str(T) '.pdf'])
        fig_number=fig_number+1;

        
        % ----------------------------------------------
        figure(fig_number);

        numMat=chosenOrders(:,:,4:6); 
        count_mat=countFreqCategories(numMat); 
        
        bar(count_mat.RelFreq);
        labels=num2str(count_mat.Categories);
        set(gca,'XTickLabel',labels);
        ylabel('Rel Freq.');
        xlabel('Est. Lag Orders (p,q)'); 
        ylim([0 1]);

        a_str={'4';'5';'6'}; 
        legend(a_str,'FontSize', 12);
        set(gca,'FontSize',12)

        save2pdf(['graphs/MC4_ORDERS2_DGP' num2str(dgp) 'T' num2str(T) '.pdf'])
        
        fig_number=fig_number+1;

	
        % ----------------------------------------------
        figure(fig_number);

        x_axis=(1:(h_max))';
        
        mseIR=nan(h_max,numb_designs);
        mseFRCST=nan(h_max,numb_designs);
        for d=1:numb_designs;
           mseIR(:,d)=mean(ir_error(:,2:end,d))'; 
           mseFRCST(:,d)=mean(frcst_error(:,:,d))'; 
        end
        
        
        for d=1:3; 
            plot(x_axis,mseIR(:,d),marker_str(d,:),'Color',[0 0 0]);
            hold on; 
        end; 
        hold off; 
        
        a_str={'1';'2';'3'}; 
        legend(a_str,'FontSize', 12);
        set(gca,'FontSize',12)

        xlabel('Horizon')
        ylabel('MSE')
        title('Impulse Responses');
        save2pdf(['graphs/MC2_IR_DGP' num2str(dgp) 'T' num2str(T) '.pdf']) 

        fig_number=fig_number+1;
        
        % ----------------------------------------------
        figure(fig_number);
        
        for d=4:numb_designs; 
            plot(x_axis,mseIR(:,d),marker_str(d,:),'Color',[0 0 0]);
            hold on; 
        end; 
        hold off;
        
        
        a_str={'4';'5';'6'}
        legend(a_str,'FontSize', 12);
        set(gca,'FontSize',12)
       
        xlabel('Horizon')
        ylabel('MSE')
        title('Impulse Responses');
        save2pdf(['graphs/MC2_IR2_DGP' num2str(dgp) 'T' num2str(T) '.pdf']) 
        
        fig_number=fig_number+1;

        
	end % end of loops over DGPs 
end % end of loops over T

























