% --------------------------------------------------------------------
%{ 
    MCcomp_FMA_ECH.m: 
    Produce Monte Carlo study to compare final moving-average and 
    Echelon identification procedures. 

    Replication files for the paper
 
    "Simple Identification and Specification of Cointegrated VARMA
    Models"
  
    by Christian Kascha and Carsten Trenkler. 
    (final version: January, 2014)
%}
% --------------------------------------------------------------------

clear all; 
dbstop if error

% -------------------------------------------------------------------------
%% Set paths:
addpath('mfiles'); 
addpath('mfiles/KronIdx'); 
inputdir='data\';
outputdir='output_rev\';
graphicsdir='graphs\';


% -------------------------------------------------------------------------
%% set parameters of MC study 

%SampleSizeSet=[50, 100, 200]; 
SampleSizeSet=[50]; 

%dgpset=[1 2 3]; 
dgpset=[1]; 

%R=1000; 
R=10;
h_max=8;
randn('state',0); 



% -------------------------------------------------------------------------
%% MC Study

for T = SampleSizeSet; 


    for dgp=dgpset; 

        VARMAmodel_true=setVARMAparameters(dgp); 
        IR_true=varma_irfun(VARMAmodel_true,h_max); 


        % set general estimation options
        foptions.CointOrder = rank(VARMAmodel_true.alfa); 

        foptions.minp=1;
        foptions.minq=0;

        K=size(VARMAmodel_true.A_0,1); 
        foptions.minKronIdx=ones(K,1); 

        % start loop 

        ir_error1=nan(R,h_max+1);
        ir_error2=nan(R,h_max+1);
        ir_error3=nan(R,h_max+1);

        frcst_error1=nan(R,h_max);
        frcst_error2=nan(R,h_max);
        frcst_error3=nan(R,h_max);

        CountEstFail=zeros(1,3); 


        for r=1:R; 

            % simulate DGP 
                [ts_data,ts_errors]=simulateVARMAmodel(VARMAmodel_true,T+h_max); 
                ts_fdata=ts_data(T+1:T+h_max,:); 
                ts_data=ts_data(1:T,:);


            % estimate IR via FMA identification 

                D=1; 
                h_T=floor(log(T)^1.25); 

                foptions.maxp=h_T;
                foptions.maxq=h_T; 

                foptions.Identification = 'fma'; 
                foptions.LagOrder='dp';

                VARMAmodel_est=estimate_civarma_poskitt(ts_data,foptions);

                if(max(abs(calcEigAR(VARMAmodel_est))) > 1.1)
                    VARMAmodel_est=rwmodel(ts_data); 
                    CountEstFail(1)=CountEstFail(1)+1;
                end


                IR_est1=varma_irfun(VARMAmodel_est,h_max);
                v_error1(r,:)=dist_IR(IR_est1,IR_true); 

                frcst1=varma_frc(VARMAmodel_est,h_max); 
                frcst_error1(r,:)=dist_IR(frcst1,ts_fdata'); 


            % estimate IR via Echelon identification 

                foptions.Identification = 'rec'; 
                foptions.LagOrder = 'PL1';

                VARMAmodel_est=estimate_civarma_poskitt(ts_data,foptions);

                if(max(abs(calcEigAR(VARMAmodel_est))) > 1.1)
                    VARMAmodel_est=rwmodel(ts_data);
                    CountEstFail(2)=CountEstFail(2)+1;
                end

                IR_est2=varma_irfun(VARMAmodel_est,h_max);
                v_error2(r,:)=dist_IR(IR_est2,IR_true); 

                frcst2=varma_frc(VARMAmodel_est,h_max); 
                frcst_error2(r,:)=dist_IR(frcst2,ts_fdata'); 

            % estimate IR via Echelon identification 
                foptions.LagOrder = 'PL2';

                VARMAmodel_est=estimate_civarma_poskitt(ts_data,foptions);

                if(max(abs(calcEigAR(VARMAmodel_est))) > 1.1)
                    VARMAmodel_est=rwmodel(ts_data);
                    CountEstFail(3)=CountEstFail(3)+1;
                end

                IR_est3=varma_irfun(VARMAmodel_est,h_max);
                v_error3(r,:)=dist_IR(IR_est3,IR_true); 

                frcst3=varma_frc(VARMAmodel_est,h_max); 
                frcst_error3(r,:)=dist_IR(frcst3,ts_fdata'); 


        end; % end for-loop over replications r=1...R

        % compute statistics and make plots 


            %subplot(1,2,1); 

            % Impulse Response MSE
                me_FMA=mean(v_error1)';
                me_PL1=mean(v_error2)'; 
                me_PL2=mean(v_error3)'; 

                me_FMA=me_FMA(2:end); 
                me_PL1=me_PL1(2:end); 
                me_PL2=me_PL2(2:end);

                x_axis=(1:(h_max))';


                plot(x_axis,me_FMA,x_axis,me_PL1,'-o',x_axis,me_PL2,'-.','Color',[0 0 0]);
                legend('FMA','PL1','PL2','FontSize', 12);
                set(gca,'FontSize',12)
                xlabel('Horizon')
                ylabel('MSE')
                title('Impulse Responses'); 
                
                

                save2pdf(['graphs/MC_DGP' num2str(dgp) '1_T' num2str(T) '.pdf']) 
                saveas(gcf,['graphs/MC_DGP' num2str(dgp) '1_T' num2str(T)],'eps'); 


            % Forecast MSE
            %subplot(1,2,2); 

                me_FMA=mean(frcst_error1)';
                me_PL1=mean(frcst_error2)'; 
                me_PL2=mean(frcst_error3)'; 

                x_axis=(1:(h_max))';

                plot(x_axis,me_FMA,x_axis,me_PL1,'-o',x_axis,me_PL2,'-.','Color',[0 0 0]);
                legend('FMA','PL1','PL2','FontSize', 12);
                xlabel('Horizon')
                ylabel('MSE')
                title('Forecasts');
                set(gca,'FontSize',12)

                save2pdf(['graphs/MC_DGP' num2str(dgp) '2_T' num2str(T) '.pdf']) 
                saveas(gcf,['graphs/MC_DGP' num2str(dgp) '2_T' num2str(T)],'eps'); 


            % Save stat on estimation stat
            CountEstFail=CountEstFail/R;

            filename=[outputdir 'EstFailStatDGP' num2str(dgp) '_T' num2str(T)]; 

            save(filename,'CountEstFail');

    end % end of loops over DGPs 

end









































