%**************************************************************************
%
% Code to transform monthly time series to quarterly frequency
%
% Dennis Wesselbaum
%
% Written: Feb / 25 / 2012
%
% The author takes no responsibility for errors or damage resulting from
% running any of the provided files (and/or associated files).
% Files can be freely redistributed and modified conditional on proper
% copyright notice including a citation to the corresponding paper authored
% by Dennis Wesselbaum in the references of any published work.
% Copyright (c) 2012, Dennis Wesselbaum. All rights reserved.
%**************************************************************************
function [series] = mtoq(input)

%% Import Data

[data]           = input; 
Y                = data(:,1:end);
clc;


%% Check Time Series

[i,j] = size(Y);

if rem(i,3) == 1;
    disp('***Unbalanced time series***')
end

%% Loop over months

for m = 1:j;
    for n = 1:3:i;
        x(m,n) = ( Y(n,m) + Y(n+1,m) + Y(n+2,m) ) / 3;
    end
end

% Correct for 0's in x vector
[k, l] = size(x);

for m = 1:j;
    series(m,:) = x(m,[1:3:l]);
end