clear all
tic
%*confidence set estimation of output equation via inverting AR*/
bands=zeros(1,2);
for maxormin=1:1:2;   % 1=max, 2=min
fsample=1; % 0 = full sample (1962Q1 to 2005Q3); 1= subsample (1962Q1 to 1984 Q4) 2= subsample (1985Q1 to 2005 Q3)
CONST2SS=0;   % 0=same search space as CONST1, 1=wider search space
CONST=0; % 0 = no constraint on b2; 1= impose a constraint that b1+b2=1(without transformation); 
npar=2;% 1= beta_f, 2=beta_r
IVSET=6; %0= 'intra-model' instruments, 1='extra-model' instruments, 2= intra+extra instruments, 3=intra+extra+important factors instruments, 4=intra+extra other factors instruments, 5=all instruments, 6=first 6 factors, 7=3 factors
gapd=1; % 0 use full-sample gap; 1 use real-time outputgap; 2 use Marginal cost*/
ENDOG=3; % no. of right-hand-side endogenous
%/* gk updated dataset, US quarterly data 
%See usdata2006.inp and usdata_2006.txt for details
%usdata_2006.dat: (59:2-05:3)
%col1: Real GDP level 
%col2: deflator inflation [ 100*(log(deflator[T]) - log(deflator[T-1])) ]
%col3: labor share of income (non-farm business labor) 
%col4: labor share of income (total compensation labor)
%col5: wage inflation
%col6: Int. rate spread 
%col7: commodity price inflation
%col8: change in M1
%col9: change in M2

%usinterestrates.dat: (59:2-05:3)
%col1: LR interest rate
%col2: SR interest rate (3-mth t-bill)
% loading data %
usdat=load('usd_2006.dat');
iusdat=load('usi.dat');
%load usdat(186,9)  = usd_2006.dat;	%% 59:2-05:3 % 
%load iusdat(186,2) = usi.dat; 		%% 59:2-05:3 %
usfactor=load('usfactor.txt');     %15 factors, monthly 
factor= mtoq(usfactor)';  %15 quarterly factors  59:2-05:3
yfull	= usdat(:,1);
dpfull	= usdat(:,2);
mc1full	= usdat(:,3);
mc2full	= usdat(:,4);
dwfull	= usdat(:,5);
spdfull	= usdat(:,6);
dcfull	= usdat(:,7);
dm1full	= usdat(:,8);
dm2full	= usdat(:,9);

ilrfull = iusdat(:,1);
isrfull = iusdat(:,2);

y=log(yfull);		% log(GDP) %
mcfull = mc2full;

%print "Using mc2 definition for real marg. cost";
% construct output gap measures for log(GDP) %
tty=size(y,1);
t=ones(tty,1);

tcount=1;
while tcount <= tty
	t(tcount,:)=tcount;
	tcount=tcount+1;
end;

konst=ones(tty,1);
tsq=t.^2;
tcube=t.^3;

% trend and gap over all the sample %

gsqhat=ones(tty,1);
	xregfull=[konst t tsq];
	[bmcfull,eefull]= mco(xregfull,y); 
	gsqhat=xregfull*bmcfull;
gsqtot = y - gsqhat;


% recursive output gap measures %

ycount=5;
ysqhat=ones(tty,1);
ycubehat=ones(tty,1);

while ycount <= tty
	xreg1=[konst(1:ycount,:) t(1:ycount,:) tsq(1:ycount,:)];
	[bmcxreg1,eexreg1]=mco(xreg1,y(1:ycount,:)); 
	ysqhat(ycount,1)=xreg1(ycount,:)*bmcxreg1;

	xreg2=[konst(1:ycount,:) t(1:ycount,:) tsq(1:ycount,:) tcube(1:ycount,:)];
	[bmcxreg2,eexreg2]=mco(xreg2,y(1:ycount,:)); 
	ycubehat(ycount,1)=xreg2(ycount,:)*bmcxreg2;

ycount=ycount+1;
end

ysqtot = y - ysqhat;
ycubetot = y - ycubehat;


	% define the subsample %
if fsample==0
istart=12;		% obs 12 is 62:1 %
iend=186;		% obs 186 is 05:3 %
elseif fsample==1
istart=12;		% obs 12 is 62:1 %
iend=103;		% obs 83 is 84q4 %
elseif fsample==2
istart=104;		% obs 84 is 85q1 %
iend=186;		% obs 186 is 05:3 %
end

	%print "istart=" istart;
	%print "iend=" iend;
	tt = iend-istart+1;
	%print "tt=" tt; print;
	
 	dpfull = dpfull./100;		% gross inflation %
 	dwfull = dwfull./100;		% gross wage inflation %
	dcfull = dcfull./100;		% gross commodity inflation %
	dm1full = dm1full./100;		% gross m1 growth %
	dm2full = dm2full./100;		% gross m2 growth %

	ilrfull = ilrfull./400;
	isrfull = isrfull./400;
    
    %Reshape
    factor= factor(istart:iend,:);

	dp  = dpfull(istart:iend,:);
	dp1 = dpfull(istart-1:iend-1,:);
	dp2 = dpfull(istart-2:iend-2,:);
	dp3 = dpfull(istart-3:iend-3,:);
	dp4 = dpfull(istart-4:iend-4,:);
	dp5 = dpfull(istart-5:iend-5,:);

	st  = mcfull(istart:iend,:);
	st1 = mcfull(istart-1:iend-1,:);
	st2 = mcfull(istart-2:iend-2,:);
	st3 = mcfull(istart-3:iend-3,:);
	st4 = mcfull(istart-4:iend-4,:);
	st5 = mcfull(istart-5:iend-5,:);

	dw  = dwfull(istart:iend,:);
	dw1 = dwfull(istart-1:iend-1,:);
	dw2 = dwfull(istart-2:iend-2,:);
	dw3 = dwfull(istart-3:iend-3,:);
	dw4 = dwfull(istart-4:iend-4,:);
	dw5 = dwfull(istart-5:iend-5,:);

	spd  = spdfull(istart:iend,:);
	spd1 = spdfull(istart-1:iend-1,:);
	spd2 = spdfull(istart-2:iend-2,:);
	spd3 = spdfull(istart-3:iend-3,:);
	spd4 = spdfull(istart-4:iend-4,:);
	spd5 = spdfull(istart-5:iend-5,:);

	dc  = dcfull(istart:iend,:);
	dc1 = dcfull(istart-1:iend-1,:);
	dc2 = dcfull(istart-2:iend-2,:);
	dc3 = dcfull(istart-3:iend-3,:);
	dc4 = dcfull(istart-4:iend-4,:);
	dc5 = dcfull(istart-5:iend-5,:);

	dm1  = dm1full(istart:iend,:);
	dm11 = dm1full(istart-1:iend-1,:);
	dm12 = dm1full(istart-2:iend-2,:);
	dm13 = dm1full(istart-3:iend-3,:);
	dm14 = dm1full(istart-4:iend-4,:);
	dm15 = dm1full(istart-5:iend-5,:);

	dm2  = dm2full(istart:iend,:);
	dm21 = dm2full(istart-1:iend-1,:);
	dm22 = dm2full(istart-2:iend-2,:);
	dm23 = dm2full(istart-3:iend-3,:);
	dm24 = dm2full(istart-4:iend-4,:);
	dm25 = dm2full(istart-5:iend-5,:);

	gsq = gsqtot(istart:iend,:);
	gsq1= gsqtot(istart-1:iend-1,:);
	gsq2= gsqtot(istart-2:iend-2,:);
	gsq3= gsqtot(istart-3:iend-3,:);
	gsq4= gsqtot(istart-4:iend-4,:);
	gsq5= gsqtot(istart-5:iend-5,:);

	isr  = isrfull(istart:iend,:);
	isr1 = isrfull(istart-1:iend-1,:);
	isr2 = isrfull(istart-2:iend-2,:);
	isr3 = isrfull(istart-3:iend-3,:);
	isr4 = isrfull(istart-4:iend-4,:);
	isr5 = isrfull(istart-5:iend-5,:);

	ysq = ysqtot(istart:iend,:);
	ysq1= ysqtot(istart-1:iend-1,:);
	ysq2= ysqtot(istart-2:iend-2,:);
	ysq3= ysqtot(istart-3:iend-3,:);
	ysq4= ysqtot(istart-4:iend-4,:);
	ysq5= ysqtot(istart-5:iend-5,:);


	% De-mean all variables %

	infl  = dp  - mean(dp);	% pi_(t+1) %
	infl1 = dp1 - mean(dp1);	% pi_(t)   %
	infl2 = dp2 - mean(dp2);	% pi_(t-1) %
	infl3 = dp3 - mean(dp3);	% pi_(t-2) %
	infl4 = dp4 - mean(dp4);	% pi_(t-3) %
	infl5 = dp5 - mean(dp5);	% pi_(t-4) %

	dwhat  = dw  - mean(dw);
	dwhat1 = dw1 - mean(dw1);
	dwhat2 = dw2 - mean(dw2);
	dwhat3 = dw3 - mean(dw3);
	dwhat4 = dw4 - mean(dw4);
	dwhat5 = dw5 - mean(dw5);

	dchat   = dc   - mean(dc);
	dchat1  = dc1  - mean(dc1);
	dchat2  = dc2  - mean(dc2);
	dchat3  = dc3  - mean(dc3);
	dchat4  = dc4  - mean(dc4);
	dchat5  = dc5  - mean(dc5);

	g  = gsq  - mean(gsq);		% g_(t+1) %	
	g1 = gsq1 - mean(gsq1);	% g_t     %
	g2 = gsq2 - mean(gsq2);	% g_(t-1) %
	g3 = gsq3 - mean(gsq3);	% g_(t-2) %
	g4 = gsq4 - mean(gsq4);	% g_(t-3) %
	g5 = gsq5 - mean(gsq5);	% g_(t-4) %

	y  = ysq  - mean(ysq);		% y_(t+1) %	
	y1 = ysq1 - mean(ysq1);	% y_t     %
	y2 = ysq2 - mean(ysq2);	% y_(t-1) %
	y3 = ysq3 - mean(ysq3);	% y_(t-2) %
	y4 = ysq4 - mean(ysq4);	% y_(t-3) %
	y5 = ysq5 - mean(ysq5);	% y_(t-4) %

	r  = isr  - mean(isr);		% r_(t+1) %
	r1 = isr1 - mean(isr1);	% r_t     %
	r2 = isr2 - mean(isr2);	% r_(t-1) %
	r3 = isr3 - mean(isr3);	% r_(t-2) %
	r4 = isr4 - mean(isr4);	% r_(t-3) %
	
	spdhat  = spd  - mean(spd);
	spdhat1 = spd1 - mean(spd1);
	spdhat2 = spd2 - mean(spd2);
	spdhat3 = spd3 - mean(spd3);
	spdhat4 = spd4 - mean(spd4);

	dm1hat  = dm1  - mean(dm1);
	dm1hat1 = dm11 - mean(dm11);
	dm1hat2 = dm12 - mean(dm12);
	dm1hat3 = dm13 - mean(dm13);
	dm1hat4 = dm14 - mean(dm14);

	dm2hat  = dm2  - mean(dm2);
	dm2hat1 = dm21 - mean(dm21);
	dm2hat2 = dm22 - mean(dm22);
	dm2hat3 = dm23 - mean(dm23);
	dm2hat4 = dm24 - mean(dm24);


	% define real marginal costs %

	st  = log(st);
	st1 = log(st1);
	st2 = log(st2);
	st3 = log(st3);
	st4 = log(st4);
	st5 = log(st5);

	sthat  = st  - mean(st);
	sthat1 = st1 - mean(st1);
	sthat2 = st2 - mean(st2);
	sthat3 = st3 - mean(st3);
	sthat4 = st4 - mean(st4);
	sthat5 = st5 - mean(st5);
    
    %factor= factor - mean(factor,1)*ones(1,size(factor,2))';
    factor = bsxfun(@minus, factor, mean(factor, 1));

	% define change in inflation variables %
    if CONST==0 || CONST==1
    dpi     = infl; %already demeaned
    deldp1   = infl1; %already demeaned
    else
	deldp	= (dp -dp1) - mean(dp-dp1);
	deldp1	= (dp1-dp2) - mean(dp1-dp2);
	deldp2	= (dp2-dp3) - mean(dp2-dp3);
	deldp3	= (dp3-dp4) - mean(dp3-dp4);

	dpi    =  dp - dp2;
	dpi    =  dpi - mean(dpi);
    end
	% define real interest rate %

	rpi  = r1 - infl;
	rpi1 = r2 - infl1;

	rpi  = rpi  - mean(rpi);
	rpi1 = rpi1 - mean(rpi1);


	clear candat dpfull dwfull mcfull spdfull ...
		dcfull dm1full dm2full yfull ysqtot ...
		ycubetot mc1full mc2full ilrfull   ...
		isrfull gsqtot;

	% instrument set %
	%tau = 1;
	%print "tau =" tau;
	
	%print "The instrument set is: zinst	= dwhat3~dwhat4~dchat3~dchat4;
	zinst	= [dwhat3 dwhat4 dchat3 dchat4];
if gapd==0
disp('Using standard gap');
elseif gapd==1
disp('Using real-time output');
	g  = y;	
	g1 = y1;
	g2 = y2;
	g3 = y3;
	g4 = y4;
	g5 = y5;
else
disp('Using marginal cost measure');
	g  = sthat;	
	g1 = sthat1;
	g2 = sthat2;
	g3 = sthat3;
	g4 = sthat4;
	g5 = sthat5;
end
% ------------------------------------------------------------------------------ %


% 	/* inflation eqn (1)*/

% print "OUTPUT EQUATION";

% infl, g1 %
y_right=[g r1 dpi];	 		%/* right-hand side endogenous */
gg=size(y_right,2);		%/* number of left-hand side endogenous variables */
y_left=g1;			%/* left-hand side endogenous */
x1=[g2 g3 g4 g5]; 			%/* right-hand side included exogenous */
if CONST==0 || CONST==1
k1=size(x1,2);				%/* note: enter k1=0 if no rhs included exogenous */
else
k1=0
end
% /*
% x2=r2~r3~r4~g2~g3~g4~g5;		/* instruments (excluded exogenous) */
% x2=r2~r3~r4~g2~g3~g4~g5~zinst;		/* instruments (excluded exogenous) */
% */
if IVSET==0
disp('the "intra-model" instruments');
x2=[infl2 r2 r3 r4];
elseif IVSET==1
disp('the "extra-model" instruments');
x2=zinst;		%/* instruments (excluded exogenous) */
elseif IVSET==2
disp('the "intra+extra" instruments');
x2=[infl2 r2 r3 r4 zinst];		%/* instruments (excluded exogenous) */
elseif IVSET==3
disp('the "intra+extra+important factors" instruments');
FAC=[infl2 r2 r3 r4 zinst factor(:,1:6)];		%/* instruments (excluded exogenous) */
[F,Lam,eval] = extract(FAC,ENDOG); % extract: [factors, loadings, eigenvalues] 
x2=lagn(F,1);
%reshape
y_right=y_right(2:end,:);
y_left=y_left(2:end,:);
x1=x1(2:end,:);
x2=x2(2:end,:);
x2=bsxfun(@minus, x2, mean(x2, 1));
elseif IVSET==4
disp('the "intra+extra+other factors" instruments');
FAC=[infl2 r2 r3 r4 factor(:,7:end)];		%/* instruments (excluded exogenous) */
[F,Lam,eval] = extract(FAC,ENDOG); % extract: [factors, loadings, eigenvalues] 
x2=lagn(F,1);
%reshape
y_right=y_right(2:end,:);
y_left=y_left(2:end,:);
x1=x1(2:end,:);
x2=x2(2:end,:);
x2=bsxfun(@minus, x2, mean(x2, 1));
elseif IVSET==5
disp('the "intra+extra+all factors" instruments');
FAC=[infl2 r2 r3 r4 zinst factor];		%/* instruments (excluded exogenous) */
[F,Lam,eval] = extract(FAC,ENDOG); % extract: [factors, loadings, eigenvalues] 
x2=lagn(F,1);
%reshape
y_right=y_right(2:end,:);
y_left=y_left(2:end,:);
x1=x1(2:end,:);
x2=x2(2:end,:);
x2=bsxfun(@minus, x2, mean(x2, 1)); %demean
elseif IVSET==6
disp('the first 6 factors');
x2=lagn(factor(:,1:6),1);
%reshape
y_right=y_right(2:end,:);
y_left=y_left(2:end,:);
x1=x1(2:end,:);
x2=x2(2:end,:);
elseif IVSET==7
disp('the first 3 factors');
x2=lagn(factor(:,1:3),1); %already demeaned
%reshape
y_right=y_right(2:end,:);
y_left=y_left(2:end,:);
x1=x1(2:end,:);
x2=x2(2:end,:);
end

k2=size(x2,2);			%/*number of instruments (excluded exogenous)*/
kk=k1+k2;
tt=size(x2,1);
	% main program %

if k1 >0
	xx=[x1 x2];	
	M_X1=eye(tt) - x1 * (inv(x1'*x1)) * x1';
else
	xx=x2;	
	M_X1=eye(tt) ;
end

M_XX=eye(tt) - xx * (inv(xx'*xx)) * xx';				 
F_alfa=finv(.95,k2,tt-kk); %*F(5%,kk,tt-kk)*/ 
%*******************************************************************
%               initialize the positions and speeds of particles      
%********************************************************************/
loop=100; %maximum number of iterations
M=80; % M is the total number of particles,m>=np+4
np=2; %number of parameters
dropmin=floor(M/6); % minimum number of bad particles being replaced during each iteration
dropmax=floor(M/2); % minimum number of bad particles being replaced during each iteration
thresh=10^9;
xrange=0.5; % control the range of new particles
%C1=1.494;   %weight parameter for individual information (1.494)
%C2=1.494;   %weight parameter for group information (1.494)
%C3=0.49;     %weight parameter for group mean information (0.1-1)
P_MinLR=zeros(loop,1);%for plot
P_bast=zeros(loop,np);
%initial position
Xmean=zeros(loop,np); %mean position for whole group
diver=zeros(loop,1); %diversity
diverlow=0.01;
shapeb=5; %shape parameter in mutation
Xindex=zeros(M,1);
Xii=zeros(M,np);
lb=[0    1];%bounds
ub=[1   40];
Xii(:,1)=lb(1)+(ub(1)-lb(1))*rand(M,1); %b2(infl(t+1))
Xii(:,2)=lb(2)+(ub(2)-lb(2))*rand(M,1); %b3(outputgap) [-1,1]
C1MIN=0.5; C2MIN=0.5; C3MIN=0; C1MAX=3; C2MAX=3; C3MAX=0.008;
Vdmax=0.25*(ub-lb); %maximum velocities allowed
Vd=1/200*randn(M,np); %*initial speed
%Vd=1/2*randn(M,1)*Vdmax; %*initial speed
pbest=10^9*ones(M,1);%*best fitness for each particle
nbest=10^9;%*best fitness for whole group
Xpbest=zeros(M,np);%*best position for each particle
Xnbest=zeros(1,np);%*best position for whole group
f=zeros(M,1);%fitness function
Q=zeros(M,1);%component in penalty function
cc=.5;  %relative weight on penalty  *********************************************************************   
alfaa=2;
aa=150;
bb=10;
%***************************************************
%                  PSO        
%***************************************************%
for v=1:1:loop  %v is the number of iteration
    nosum=0;
            for j=1:1:M % j is the number of particle

%IAR statistic
if CONST==0
IAR=(tt-kk)/k2*(y_left-y_right*[Xii(j,1) -1/Xii(j,2) 1/Xii(j,2)]')'*(M_X1-M_XX)*(y_left-y_right*[Xii(j,1) -1/Xii(j,2) 1/Xii(j,2)]')...
/((y_left-y_right*[Xii(j,1) -1/Xii(j,2) 1/Xii(j,2)]')'*M_XX*(y_left-y_right*[Xii(j,1) -1/Xii(j,2) 1/Xii(j,2)]'));
else
IAR=(tt-kk)/kk*(y_left-y_right*[(1-Xii(j,1)) Xii(j,1) Xii(j,2)]')'*(eye(tt)-M_XX)*(y_left-y_right*[(1-Xii(j,1)) Xii(j,1) Xii(j,2)]')/((y_left-y_right*[(1-Xii(j,1)) Xii(j,1) Xii(j,2)]')'*M_XX*(y_left-y_right*[(1-Xii(j,1)) Xii(j,1) Xii(j,2)]'));
end
G=IAR-F_alfa;
Q(j,1)=max([0 G]);
if Q(j,1)<=1 
gamma1 = 1;
else
gamma1 = 2;
end
lamda1= (aa*(1-exp(-Q(j,1)))+bb ) * Q(j,1)^gamma1;
f(j,1)=Xii(j,npar)*((-1)^(maxormin))+(cc*v)^alfaa*lamda1;
                  if f(j,1)>=thresh
                      nosum=nosum+1;
                  end
                  if f(j,1)<pbest(j,1)
                       pbest(j,1)=f(j,1);
                       Xpbest(j,:)=Xii(j,:);                   
                  end
			Xmean(v,:)=Xmean(v,:)+Xii(j,:);	 
            end %end j	
            %Xmean(v,:)=Xmean(v,:)/M;
               [nmf,d]=min(f);%
              if nmf<nbest
                   nbest=nmf;
                   Xnbest(1,:)=Xpbest(d,:);
              end 
              Xmean(v,:)=Xmean(v,:)-Xnbest(1,:);
              %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %-------------------replace bad particles with something around Xmean----------------------------
    if nosum<=dropmin
        nosum=dropmin;
    elseif nosum>=dropmax
         nosum=dropmax;    
        end
    
    for cj=1:1:nosum
    [a1,b1]=max(f);
    Xindex(cj)=b1;
    f(b1)=min(f);
    Xmean(v,:)=Xmean(v,:)-Xii(b1,:);
    end
    %-----------------new Xmean with remaining particles--------------------------------------------
    Xmean(v,:)=Xmean(v,:)/(M-nosum-1);
    for ck=1:1:nosum
    Xii(Xindex(ck),:)=Xmean(v,:)*(xrange+rand()); %replace bad particles so the particles may not stuck in local optimum
    Xpbest(Xindex(ck),:)=Xmean(v,:)*(xrange+rand()); %erase memory
    %Xpbest(Xindex(ck),:)=Xnbest(1,:)*(0.9+0.2*rand()); %erase memory
    end
    %weight parameters in motion of velocities
            C1=(C1MIN-C1MAX)*v/loop +C1MAX;
            C2=(C2MAX-C2MIN)*v/loop +C2MIN; %linear increasing 
            %C3=(C3MAX-C3MIN)*v/loop +C3MIN;
            C3=(C3MIN-C3MAX)*v/loop +C3MAX; %linear decreasing
            phi1=C1*rand();
            phi2=C2*rand();
            phi3=C3*rand();
          %change speed and position of each particle
            for c=1:1:M
                                  
                Vd(c,:)=(1+phi1+phi2+phi3-sqrt((phi1+phi2+phi3)*(2+phi1+phi2+phi3)))*Vd(c,:)+...
                    phi1*(Xpbest(c,:)-Xii(c,:))+phi2*(Xnbest(1,:)-Xii(c,:))+phi3*(Xmean(v,:)-Xii(c,:));
             for k=1:1:np
                 if Vd(c,k)>Vdmax(1,k)
                     Vd(c,k)=rand()*Vdmax(1,k);
                     %Vd(c,k)=Vd(c,k)-2*(Vd(c,k)-Vdmax(1,k));
                 elseif Vd(c,k)<-Vdmax(1,k)
                    Vd(c,k)=-rand()*Vdmax(1,k); 
                    %Vd(c,k)=Vd(c,k)+2*(-Vdmax(1,k)-Vd(c,k));
                  end
             end 
              Xii(c,:)=Xii(c,:)+Vd(c,:);
               for kx=1:1:np
                 if Xii(c,kx)>ub(1,kx)
                    Xii(c,kx)=lb(1,kx)+(ub(1,kx)-lb(1,kx))*rand();
                     %Xii(c,kx)=Xii(c,kx)-2*(Xii(c,kx)-ub(1,kx));
                    Vd(c,kx)=0; 
                 elseif Xii(c,kx)<lb(1,kx)
                     Xii(c,kx)=lb(1,kx)+(ub(1,kx)-lb(1,kx))*rand();
                   %Xii(c,kx)=Xii(c,kx)+2*(lb(1,kx)-Xii(c,kx));
                   Vd(c,kx)=0; 
                  end
               end 
             diver(v,:)=diver(v,:)+sqrt((Xii(c,:)-Xmean(v,:))*((Xii(c,:)-Xmean(v,:))'));	
             end 
             diver(v,:)=diver(v,:)/M;
             if diver(v,:)<diverlow
                     %Xii=Xii+(1/10)*rand(M,np);
                     flip=rand();
                     if flip<0.5
                         for cc=1:1:M
                         Xii(cc,:)=Xii(cc,:)+(ub-Xii(cc,:))*(1-rand()^(1-(v/loop))^shapeb);
                         end
                     elseif flip>=0.5
                         for cc=1:1:M
                         Xii(cc,:)=Xii(cc,:)+(Xii(cc,:)-lb)*(1-rand()^(1-(v/loop))^shapeb);
                         end 
                        end
             end
             
P_MinLR(v)=nbest;%for graph
P_bast(v,:)=Xpbest(d,:);
end
time=toc
%results
if maxormin==1
    bands(1,2)=-nbest;
if CONST==0
%fprintf('Max NO. of Particles= %4.1f ,Max NO. of iterations= %4.1f \n',M,loop);
%fprintf('opt: b1(infl(t-1))= %4.3f ,b2(infl(t+1))= %4.3f ,b3(outputgap)= %4.3f, bound = %4.3f \n',Xnbest(1,:),nbest);
% h(1) = figure;
% t = 1:loop;
% plot(t,P_MinLR,'-r');
% xlabel('iterations');
% ylabel('fitness');
% h(2) = figure;
% plot(t,P_bast(:,1),'-r',t,P_bast(:,2),'-b',t,P_bast(:,3),'-y');
% ylabel('Parameters');
% xlabel('iterations');
% legend('b1(infl(t-1)) red','b2(infl(t+1)) blue','b3(outputgap) yellow');
if Xnbest(1,npar)~=nbest
    %disp('the optimum achieved does not pass the LR test');
        disp('does not pass the test!!!'); 
end
if Q(d)~=0
    %disp('the optimum achieved does not pass the LR test');
        disp('non-zero penalty!!!'); 
end
if Xnbest(1,1)<lb(1) || Xnbest(1,1)>ub(1)
    disp('the optimal beta_f is in an unreasonable region');  
elseif Xnbest(1,2)<lb(2) || Xnbest(1,2)>ub(2)
    disp('the optimal beta_r is in an unreasonable region');  
end  
elseif CONST==1
if Xnbest(1,1)<lb(1) || Xnbest(1,1)>ub(1)
    disp('the optimal gamma_f is in an unreasonable region');  
elseif Xnbest(1,2)<lb(2) || Xnbest(1,2)>ub(2)
    disp('the optimal lambda is in an unreasonable region');  
end
% h(1) = figure;
% t = 1:loop;
% plot(t,P_MinLR,'-r');
% xlabel('iterations');
% ylabel('fitness');
% h(2) = figure;
% plot(t,P_bast(:,1),'-r',t,P_bast(:,2),'-b');
% ylabel('Parameters');
% xlabel('iterations');
% legend('b2(infl(t+1)) red','b3(outputgap) blue');
end
elseif maxormin==2
bands(1,1)=nbest;    
if CONST==0
%fprintf('Max NO. of Particles= %4.1f ,Max NO. of iterations= %4.1f \n',M,loop);
%fprintf('opt: b1(infl(t-1))= %4.3f ,b2(infl(t+1))= %4.3f ,b3(outputgap)= %4.3f, bound = %4.3f \n',Xnbest(1,:),nbest);
% h(3) = figure;
% t = 1:loop;
% plot(t,P_MinLR,'-r');
% xlabel('iterations');
% ylabel('fitness');
% h(4) = figure;
% plot(t,P_bast(:,1),'-r',t,P_bast(:,2),'-b',t,P_bast(:,3),'-y');
% ylabel('Parameters');
% xlabel('iterations');
% legend('b1(infl(t-1)) red','b2(infl(t+1)) blue','b3(outputgap) yellow');
if Xnbest(1,npar)~=nbest
    %disp('the optimum achieved does not pass the LR test');
        disp('does not pass the test!!!'); 
end
if Q(d)~=0
    %disp('the optimum achieved does not pass the LR test');
        disp('non-zero penalty!!!'); 
end
if Xnbest(1,1)<lb(1) || Xnbest(1,1)>ub(1)
    disp('the optimal beta_f is in an unreasonable region');  
elseif Xnbest(1,2)<lb(2) || Xnbest(1,2)>ub(2)
    disp('the optimal beta_r is in an unreasonable region');  
end    
elseif CONST==1
if Xnbest(1,1)<lb(1) || Xnbest(1,1)>ub(1)
    disp('the optimal gamma_f is in an unreasonable region');  
elseif Xnbest(1,2)<lb(2) || Xnbest(1,2)>ub(2)
    disp('the optimal lambda is in an unreasonable region');  
end
%fprintf('The best solution for coefficients: b2(infl(t+1))= %4.16f ,b3(outputgap)= %4.16f, bound = %4.16f \n',Xnbest(1,:),nbest);
% h(4) = figure;
% t = 1:loop;
% plot(t,P_MinLR,'-r');
% xlabel('iterations');
% ylabel('fitness');
% h(2) = figure;
% plot(t,P_bast(:,1),'-r',t,P_bast(:,2),'-b');
% ylabel('Parameters');
% xlabel('iterations');
% legend('b2(infl(t+1)) red','b3(outputgap) blue');
end
end
end
fprintf('Max NO. of Particles= %4.1f ,Max NO. of iterations= %4.1f , parameter %4.0f \n',M,loop,npar);
fprintf('bands= [%4.3f,%4.3f] \n',bands(1,:));
%save('FIV.mat');   %save all variables (the workspace) in mat file
diary('FIV.txt'); % record output in a txt file