% PCA factors

% DATA
load data;                                                % load the data 
% y = standardize(X_m_b(:,setdiff(1:size(X_m_b,2),107))); % monthly datatset from BGS2013 (variable 107 has some missing observations)
y = X_m_b_noNAN_std;                                      % monthly datatset from BGS2013 - 107 missing observations were fitted using a FAVAR model

% FACTORS
k = size(y,2);                                            % number of factors
[F,Lam,eval] = extract(y,k);                              % extract: [factors, loadings, eigenvalues] 

% EXPLAINED VARIANCE
explVar = cumsum(eval)./sum(eval)                       % COMMENT: you need to set k = size(y,2) to correctly calculate the share of explained variance