function f=inversionSIMPLE(bg,x1,s1)
global M J k T bgtrue ksitrue x strue1 bg0

% This is the fixed point algorithm employed in the BLP method. I tried a
% few starting values for it, including the ksi that corresponds to the q
% that was used as a starting value in fpMIX.

ss = size(x1);
ksiold=ones(ss(1),1);

difb = 10^2;
w = 0;
tol = 10^(-10);

while difb-tol>0  % the BLP fixed point
    
    ms = mktshINV(bg,ksiold,x1);  % Calculate the market shares
    
    ksi = (ksiold(2:end)).*((s1(2:end))./ms(2:end));
    
    difb = max(abs(ksi-ksiold(2:end)));
  
    ksiold = [1;ksi];
    
    w=w+1;
    
end

f=[0;log(ksi)];
