function [y,i,j] = fpMIXruns(bg,s1,x1)
global J k T bgtrue ksitrue x strue1 bg0  

% This is the code for the Dual "mixed" algorithm. This algorithm works
% with the original dual equations as long as the consumer unobservables
% satisfy the conditions stated in the paper. It applies the logit
% tranformation on the consumer unobservables if the conditions are not
% satisfied.

bg1 = reshape(bg(1:T*k),k,T)';
gam = [bg((T*k+1):end);1-sum(bg((T*k+1):end))];

i = 0;
j = 0;
dif = 100;

qold1 = (s1(1)/(T))*ones(T-1,1); 
qold = [s1(1)-sum(qold1);qold1];
qFP = qold;

mm = 0;
tol = 10^(-12);

while (dif-tol>0)% The dual fixed point
    
    pr1 = purINV(qold,bg,s1,x1);  % Calculates the probability of type t given purchase of j
    
    qFP = qold(2:end).*(gam(2:end)./pr1(2:end));
    
    if sum(qFP) > s1(1)  % Check that q in this step is in set C (see Section 3 of the paper)
        
        mm = 1;
        
        break   % If q not in C, stop and ove to the next fixed point which uses the logit transformation of q
    end
    
    dif = max(abs(qFP-qold(2:end)));
        
    qold = [s1(1)-sum(qFP);qFP];  
         
    i=i+1;
    
end

if mm == 1  % If q not in C, do the logit transformation on q
    
    eaold = [1 ; qold(2:end)./(s1(1)-sum(qold(2:end)))];  % Logit transformation

    while (dif-tol>0),  % The fixed point on the logit transformation of q
    
         pr1 = purINV(eaold,bg,s1,x1);
        
        eaFP = (eaold(2:end)).*(gam(2:end)./pr1(2:end));
    
        dif = max(abs(eaFP-eaold(2:end)));
    
        eaold = [1 ; eaFP];
    
        j = j+1;
    end
    
    yyy = [0 ;log(eaFP)];
    yy = qus(yyy,s1);
    y = yy;
    
else
    y = [s1(1)-sum(qFP);qFP];
    
end
    