function y = allksisDUALMIX(bg,x1,s1)
global M J k T bgtrue ksitrue x strue1 bg0  

% This function calculates the product unobservables  for all markets. It first calculates the consumer unobservables via the Dual mixed fixed
% point algorithm (which is called by the function "fpMIX") and then finds
% the corresponding product unobservables via the function "mukSIMPLE".

y = zeros(sum(J),1);

JJ = cumsum(J);

lq1 = fpMIX(bg,s1(1:JJ(1)),x1((1:JJ(1)),:));
y(1:JJ(1)) = mukSIMPLE(bg,lq1,s1(1:JJ(1)),x1((1:JJ(1)),:));

for i = 2 : M     % Loop over markets  
     lq2 = fpMIX(bg,s1(JJ(i-1)+1 : JJ(i)),x1(JJ(i-1)+1 : JJ(i),:));     % Calculate q via the dual fixed point
     y(JJ(i-1)+1 : JJ(i)) = mukSIMPLE(bg,lq2,s1(JJ(i-1)+1 : JJ(i)),x1(JJ(i-1)+1 : JJ(i),:)); % Calculate the ksi from q
          
end

