%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Central File: Generate Data and Perform GMM %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Program Used to Construct Tables 1 and 2, in "From Market Shares to %%%
%%% Consumer Types: Duality in Differentiated Product Demand Estimation", % 
%%% by Myrto Kalouptsidi, Department of Economics, Yale University, %%%%%%% 
%%% November 2009. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%  SINGLE INVERSIONS: TABLE 1  %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Repeat this for different (J,T) combinations.

L = 1000;
itbe = 999*ones(L,1);           % Number of BLP iterations in one inversion
iter = 999*ones(L,1);           % Number of DUAL iterations in one inversion
iterTRANS = 999*ones(L,1);      % Number of DUAL iterations in one inversion under the logit transformation
normaD = 999*ones(L,1);         % Norm of the difference between the true ksi and the retrieved ksi by BLP
normaB = 999*ones(L,1);         % Norm of the difference between the true ksi and the retrieved ksi by the Dual
timeB = 999*ones(L,1);          % Time required for the BLP inversion
timeD = 999*ones(L,1);          % Time required for the DUal inversion
s0 = 999*ones(L,1);             % Market share of the outside good

for i = 1:L   % Repeat the exercise
 
[itbe(i),iter(i),iterTRANS(i),normaD(i),normaB(i),timeB(i),timeD(i),s0(i)] = runsINVERSIONS;

end

itbeMEAN = mean(itbe);
iterMEAN = mean(iter);
iterTRANSMEAN = mean(iterTRANS);
s0MEAN = mean(s0);
itbeSTD = std(itbe);
iterSTD = std(iter);
iterTRANSSTD= std(iterTRANS);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%  GMM: TABLE 2  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


global M J k T bgtrue ksitrue xnonp x strue1 bg0  z bgestimBLP ksihat bg01

M = 50;                                                 % Number of markets                                        
J = 100*ones(M,1);                                      % Number of products in a market
k = 2;                                                  % Number of product characteristics including price
T = 2;                                                  % Number of consumer types                                            

gamatrue=0.65;                                          % True value for type 1's probability
btrue11=[2 -1; 3 -1/2];                                 % True values for taste parameters
gamall = [gamatrue;1-sum(gamatrue)];
             
ksitrue = 0.4*randn(sum(J),1);                          % True values for the product unobservables

ksitrue([1;cumsum(J(1:end-1))+1]) = 0;                  % Set the unobservable characteristic of the outside good equal to zero in each market                     

%xnonp = -1.5+rand(sum(J),k-1);                         % True values for the product characteristics (small outside share)
xnonp = -3.5+randn(sum(J),k-1);                         % True values for the product characteristics (big outside share)

xnonp([1;cumsum(J(1:end-1))+1]) = 0;                    % Set the observable characteristics of the outside good equal to zero in each market

epsilon = randn(sum(J),1);
price = abs(0.5*ksitrue + 1.1*xnonp + epsilon);         % Create the price
price([1;cumsum(J(1:end-1))+1]) = 0;                    % Set the price equal to zero in each market
zz = rand(sum(J),11) + repmat(0.25*(epsilon + 1.1*xnonp),1,11);     % Create the Instruments
z = [zz.^2 zz.^3 xnonp.^2 xnonp.^3 prod(zz,2) xnonp zz.*repmat(xnonp,1,11)];
z([1;cumsum(J(1:end-1))+1],:) = [];

x = [xnonp price];
btrue3 = btrue11';
bgtrue = [btrue3(:);gamatrue];                          

strue1 = s(bgtrue,ksitrue,x);                           % Calculate the true market shares

%bg0= bgtrue;                                           % Several starting values, try more.
bg0 = bgtrue + 0.1*ones(size(bgtrue));
%bg0 = bgtrue + 0.2*ones(size(bgtrue));

options.TolFun = 0.4*10^-7;

tic;    
[bgestimBLP,fvalBLP,exitflagBLP,outputBLP] = ktrlink(@(bg) GMMobjBLP(bg,x,strue1),bg0,[],[],[],[],[],[],[],options);
tElapsedBLP = toc;  

tic;    
[bgestimDUAL,fvalDUAL,exitflagDUAL,outputDUAL] = ktrlink(@(bg) GMMobjDUAL(bg,x,strue1),bg0,[],[],[],[],[],[],[],options);
tElapsedDUAL = toc;  


















