"""

Wrapper around the batch function which turns avro files
into dataframes. To be used as a standalone when not running with
batch.

"""
import pandas as pd
import uuid

import readavrofiles_function as rd

# call function to read the avro files an store them on a dataframe
(df, dateColName, idColName) = rd.readavro()

# Convert avro to csv articles per year"
df["date"] = pd.to_datetime(df[dateColName])
df["Year"] = df["date"].dt.year
df["Newspaper"] = [x[:4].upper() for x in df[idColName].values]

# save them into csvs with random ids
for name, group in df.groupby("Newspaper"):
    print(name)
    try:
        group.to_csv(
            "{}.csv".format(name, +"_" + str(uuid.uuid4().hex[:4])), index=False
        )
    except UnicodeEncodeError:
        print("FAILED")
        continue
