data (lipswe unemp s1 s2 s3 s4) swevar3a.dat f=1
* data from 64:1 to 90:4
var dep = (unemp lipswe) ex=(const s1 s2 s3) lag 4

seed 42

mat priorm = {0 0; 0 0; 0 0; 0 0; $
      	      0.5 0; 0 0; 0 0; 0 0; $
      	      0 1; 0 0; 0 0; 0 0}
prin priorm
mat mse = const(0,8,2)
mat mean = const(0,8,2)
mat meanabs = const(0,8,2)
mat mape = const(0,8,2)

/*
* get forecasts for plots of posterior distribution
prior min(p1=0.002 p2=0.9 p3=1.4d5) mean=priorm l=84 print=full 
for hor=8 err setup
mci func=for draw=5000 dump=func
* compare forecasts w posterior mean
for hor=8
*/


*forecasting exercise using posterior means of parameters
loop i = 71 to 100
  prior min(p1=0.002 p2 = 0.9 p3 = 1.4d5) mean=priorm l = %i print = no
  print i
* forecast using posterior means
  for hor = 8 err
  mat mse = mse + forerr#forerr
  mat mean = mean + forerr
  mat meanabs = meanabs + abs(forerr)
  mat mape = mape + abs(forerr/true)
endloop

mat mse = mse/30
mat rmse = mse**0.5
mat mean = mean/30
mat meanabs = meanabs/30
mat mape = mape*(100/30)
mat onevec = const(1.0,2,1)
mat summse = mse*onevec
mat sumrmse = rmse*onevec
mat summean = mean*onevec
mat sumabs = meanabs*onevec
mat summape = mape*onevec
mat onevec = const(1.0,1,8)
mat msesum = onevec*mse
mat rmsesum = onevec*rmse
mat meansum = onevec*mean
mat abssum = onevec*meanabs
mat mapesum = onevec*mape

prin mse rmse mean meanabs mape
prin summse sumrmse summean sumabs summape
prin msesum rmsesum meansum abssum mapesum
*/


*forecasting exercise using posterior means of forecasts

mat mse = const(0,8,2)
mat mean = const(0,8,2)
mat meanabs = const(0,8,2)
mat mape = const(0,8,2)

loop i = 71 to 100
  prior min(p1=0.002 p2 = 0.9 p3 = 1.4d5) mean=priorm l = %i print = no
  print i
* mean of posterior distribution of forecasts
  for hor=8 err setup
  mci func=for draw=5000
  mat mse = mse + forerr#forerr
  mat mean = mean + forerr
  mat meanabs = meanabs + abs(forerr)
  mat mape = mape + abs(forerr/true)
endloop

mat mse = mse/30
mat rmse = mse**0.5
mat mean = mean/30
mat meanabs = meanabs/30
mat mape = mape*(100/30)
mat onevec = const(1.0,2,1)
mat summse = mse*onevec
mat sumrmse = rmse*onevec
mat summean = mean*onevec
mat sumabs = meanabs*onevec
mat summape = mape*onevec
mat onevec = const(1.0,1,8)
mat msesum = onevec*mse
mat rmsesum = onevec*rmse
mat meansum = onevec*mean
mat abssum = onevec*meanabs
mat mapesum = onevec*mape

prin mse rmse mean meanabs mape
prin summse sumrmse summean sumabs summape
prin msesum rmsesum meansum abssum mapesum

*/
quit
