function [s]=sumi(data,y0,ivi,al,be,miu,ga,om)

%The basic quantity in the exponent

dimd=size(data); tt=dimd(1); nvar=dimd(2);
tim=sum(1-isnan(data)); nobs=sum(tim);
ncov=size(ivi,1);
dimb=size(be); runb=dimb(1); 
runm=size(miu,1);
runy=size(y0,1); cy0=y0(runy,:);

ca=al(length(al));  cg=ga(length(ga)); cb=be(runb,:); cm=miu(runm,:);

s=NaN(1,nvar);

if isequal(nvar*tt,nobs)
    cmb=ones(tt,1)*cb;
    dat0=[cy0;data(1:tt-1,:)];
    if ncov<2
        reg=cm*squeeze(ivi);
    else
        reg=zeros(tt,nvar);
        for p=1:ncov
            reg=reg + cm(p)*squeeze(ivi(p,:,:));
        end
    end
    ker=data - ca*dat0 - cmb*(1-ca) -(1-ca)*reg;
    scl=( ker<=0)*cg + (ker>0)/cg;
    s=sum(om.*(ker.*scl).^2);
else
    for i=1:nvar
        whos=find(~isnan(data(:,i)));
        dati=data(whos,i);
        dat0=[cy0(i);dati(1:tim(i)-1)];
        ccov=squeeze(ivi(:,whos,i));
        ker=dati-ca*dat0-cb(i)*(1-ca) - (1-ca)*(cm*ccov)';
        scl= (ker<=0)*cg + (ker>0)/cg;
        s(i)=sum(om(whos,i).*(ker.*scl).^2);
    end
end