function p = pdf_mvn(x,mu,c,id)

dim=length(x);
x=reshape(x,[],dim);
if length(mu)==1
    mu=mu*ones(1,dim);
end
mu=reshape(mu,[],dim);

if nargin<4
   id=1;
end
if id~=1 && id~=2
    error('specify either covs matrix (1) or precs matrix (2)')
end
if size(c,1)==1
    c=diag(c*ones(1,dim));
end


if id==1
    prec=eye(dim)/c;
else
    prec=c;
end

p = 0.5*log(det(prec)) - dim/2*log(2*pi) - (x-mu)*prec*(x-mu)'/2;