function [hb ht]=newhyp(y0,iv0,al,be,miu,la,hb,ht,hypas,par)

%Gibbs step for the beta hyperparams

chb=hb(length(hb)); cht=ht(length(ht)); ca=al(length(al)); cl=la(length(la));
runb=size(be,1); nvar=size(be,2); cb=be(runb,:);
runm=size(miu,1); cm=miu(runm,:);
hypm=hypas(1); hypp=hypas(2);
runy=size(y0,1); cy0=y0(runy,:);

sbb=(2*par + (cb-chb)*(cb-chb)')/2;
newt=gamrnd(nvar/2+2,1/sbb);

zbar=mean(cy0-cm*iv0);
bb=(hypp*hypm + nvar*newt*mean(cb) + nvar*cl*(1-ca^2)*zbar)/(hypp + nvar*(newt + cl*(1-ca^2)));

newb=normrnd(bb,1/sqrt(hypp + nvar*(newt + cl*(1-ca^2))));

ht=[cht;newt];
hb=[chb;newb];