function [om]=mix(data,y0,ivi,al,be,miu,ga,la,df)

%One draw of the mixing parameters

dimd=size(data); tt=dimd(1); nvar=dimd(2);
tim=sum(1-isnan(data)); nobs=sum(tim);
ncov=size(ivi,1);
runb=size(be,1); cb=be(runb,:); 
ca=al(length(al)); cl=la(length(al)); cg=ga(length(ga)); cn=df(length(df));
runm=size(miu,1); cm=miu(runm,:);
runy=size(y0,1); cy0=y0(runy,:);

om=NaN(dimd);
aa=(cn+1)/2;

if isequal(nobs,tt*nvar)
    dat0=[cy0;data(1:tt-1,:)];
    cmb=ones(tt,1)*cb;
    if ncov<2
        reg=cm*squeeze(ivi);
    else
        reg=zeros(tt,nvar);
        for p=1:ncov
            reg=reg+ cm(p)*squeeze(ivi(p,:,:));
        end
    end
    ker=data - ca*dat0 - (1-ca)*reg - cmb*(1-ca);
    scl=(ker<=0)*cg+(ker>0)/cg;
    bb=0.5*(cn+cl*(ker.*scl).^2);
    om=gamrnd(aa,1./bb);
else
    for i=1:nvar
        whos=find(~isnan(data(:,i)));
        loni=tim(i);
        dati=data(whos,i);
        dat0=[cy0(i);dati(1:loni-1)];
        ccov=squeeze(ivi(:,whos,i));
        ker=dati-ca*dat0-cb(i)*(1-ca) - (1-ca)*(cm*ccov)';
        scl=(ker<=0)*cg+(ker>0)/cg;
        bb=0.5*(cn+cl*(ker.*scl).^2);
        om(whos,i)=gamrnd(aa,1./bb);
    end
end