function [salida acc]=main(data,cova,burn,reps,thin)

nvar=size(data,2); 
ncov=size(cova,1);
[iv0 ivi]=inicov(cova);
ilevs=nanmean(data); 
sbet=std(ilevs,1)^2;
%______________________________________________________________________________________
%Init output
efsi=(reps-burn)/thin;
salida.al=NaN(efsi,1);          
salida.be=NaN(efsi,nvar);     
salida.mu=NaN(efsi,ncov);
salida.ga=NaN(efsi,1);         
salida.la=NaN(efsi,1);       
salida.df=NaN(efsi,1);          
salida.aal=NaN(efsi,1);          
salida.bal=NaN(efsi,1);          
salida.hb=NaN(efsi,1);
salida.ht=NaN(efsi,1);
salida.y0=NaN(efsi,nvar);
salida.hmu=NaN(efsi,ncov);
salida.hmp=NaN(efsi,1);
%______________________________________________________________________________________
%Init chains
al=0.0;                   aca=0;
be=ones(1,nvar);         acb=0;
miu=0.03*ones(1,ncov);   acm=0;
ga=1;                   acg=0;
la=1000;                   
df=30;                  acn=0;
aal=15;                  acaa=0;
bal=15;                  acba=0;
hbe=0.05;
hta=100;
hmu=zeros(1,ncov);
hmp=1e4;                  achmp=0;
y0=zeros(1,nvar);           acy0=0;
nin=0;
%______________________________________________________________________________________
%Proposal's parameters 
tb=1e2;
ppaa=170;
tm=6e3;
ppag=25;
ppan=20e-1;
ppaal=2.75;
ppbal=2.75;
ppy0=2e2;
% ______________________________________________________________________________________
% % Hyperparameters
hymp=2;
hypas=[0.03 1/0.05^2];
mure=0; cmu=1; 
arr=2; qaq=0.1;
%______________________________________________________________________________________
tic
%%Run MCMC
for i=1:reps
    [y0 acy0]=ny0(data,y0,ivi,iv0,al,be,miu,ga,la,df,ppy0,acy0);
    ome=mix(data,y0,ivi,al,be,miu,ga,la,df);
    la=nlam(data,y0,ivi,iv0,al,be,miu,ga,la,ome,hbe);
    [be acb]=nbe(data,y0,ivi,al,be,miu,ga,la,ome,hbe,hta,tb,acb);
    [al aca]=nal(data,y0,ivi,iv0,al,be,miu,ga,la,ome,aal,bal,hbe,ppaa,aca);
    [ga acg]=nga(data,y0,ivi,al,be,miu,ga,la,ome,ppag,acg);
%     ga=1;
    [df acn]=nnu(data,df,ome,ppan,acn);
    [aal acaa]=naal(al,aal,bal,arr,qaq,ppaal,acaa);
    [bal acba]=nbal(al,aal,bal,arr,qaq,ppbal,acba);
    [hbe hta]=newhyp(y0,iv0,al,be,miu,la,hbe,hta,hypas,sbet);
    [hmu hmp achmp]=nhmu(miu,hmu,hmp,cmu,mure,hymp,achmp);
    [miu acm]=nmu(data,y0,ivi,iv0,al,be,miu,ga,la,ome,hbe,hmu,cmu,tm,acm);
    
    if i<=burn && mod(i,burn/4)==0
        disp([num2str(i/burn*100) '% of burn-in'])
    end
%%Collection    
    if i>burn && mod((i-burn),thin)==0
        nin=nin+1;
        salida.al(nin)=al(length(al));
        salida.ga(nin)=ga(length(ga));
        salida.la(nin)=la(length(la));
        salida.df(nin)=df(length(df));
        salida.aal(nin)=aal(length(aal));
        salida.bal(nin)=bal(length(bal));
        unb=size(be,1);
        salida.be(nin,:)=be(unb,:);
        salida.hb(nin)=hbe(length(hbe));
        uhm=size(hmu,1);
        salida.hmu(nin,:)=hmu(uhm,:);
        salida.hmp(nin)=hmp(length(hmp));
        salida.ht(nin)=hta(length(hta));
        uy0=size(y0,1);
        salida.y0(nin,:)=y0(uy0,:);
        unm=size(miu,1);
        salida.mu(nin,:)=miu(unm,:);
    end
     
    if i==burn
        disp('Burn-in pahse completed')
    end   
  
    if i>burn && mod((i-burn),(reps-burn)/10)==0
        disp([num2str((i-burn)/(reps-burn)*100) '% done'])
    end
end
toc
salida.sbet=sbet;

acc.al=aca/reps;
acc.ga=acg/reps;
acc.df=acn/reps;
acc.aal=acaa/reps;
acc.bal=acba/reps;
acc.be=acb/reps;
acc.mu=acm/reps;
acc.hmp=achmp/reps;
acc.y0=acy0/reps;

disp('ACCEPTANCE RATES')
disp('    alpha      ga      nu')
disp([acc.al acc.ga acc.df])
disp('Hypers for alpha')
disp([acc.aal acc.bal])
disp('   Betas       coeffs  coef prec  ini vals' )
disp([acc.be acc.mu acc.hmp acc.y0])