function [p]= lskt(x,g,l,n)

%log-pdf of a Skt.  x can be vector valued. 

if g<=0 || l<=0 || n<=0
    error('All parameters must be positive')
end

scl=(x<=0)*g + (x>0)/g;

p= log(2/(g+g^(-1)))+ gammaln((n+1)/2)- gammaln(n/2) + 0.5*log(l/(pi*n))-(n+1)/2*log(1+l/n*(x.*scl).^2);