/******************************************************
Monte Carlo Experiments to Assess the Coverage of
Marginal vs. Scheffe Bands for path forecasts.

"Path Forecasting Evaluation" by Oscar Jorda and
Massimiliano Marcellino (2008)

Revision for Journal of Applied Econometrics

This part estimates the Stock and Watson (2001) VAR
and generates out-of-sample forecasts by estimating
a VAR of unknown length or by estimating direct forecasts

Author: Oscar Jorda
Initial Date: 6/18/2008
Last Updated: 7/16/2008
*******************************************************/
new;
cls;

/*******************************************
Initial Analysis Choices
********************************************/
hmax = 8;           // Forecast horizon 
hlim = 12;          // Max forecast horizon
alpha = 0.05;       // (1-alpha) confidence bands

vars = 3;		    // variables in the data set 

plg = 1;		    // if plg = 0, lag length is set to maxp. if 1, lag length is chosen automatically 
maxp = 8;           // Max Lag for Info Criteria (SW choose 4)
infoc = 1;      	// 1 for AICc, 2 for AIC, 3 for SIC 

psw = 4;            // lag length of VAR in SW(2001)
pres =   2;         //presample for graphs
/*************************************************
load the Data for the Stock and Watson (2001) VAR
*************************************************/
load z[] =  swqdata.csv; 
z = reshape(z,rows(z)/vars,vars);
TT = rows(z);
T = TT-hlim;        // reserve the last hlim obs for evaluation

sers = "P"$|"UN"$|"FF";        @Label your series here @

// Choose lag length with Info criterion
{aicc, aic, sic, p} = lagcrit(z[1:T,.], plg, maxp, infoc);

/******************************************************
Estimate the VAR
******************************************************/
{beta, sig_u_sw, sig_a_sw} = varols(z[1:T,.], psw, 1);
/***************************************************** 
Here I chose p = 4 as in Stock and Watson (2001). If
you wish you can use "p" instead of "psw" if you use
automatic information criteria instead

The last entry in the varols proc is zero if the vcv
of the coefficients is not wanted, 1 otherwise

Note that sig_sw is the vcv matrix of vec(beta'),
not of vec(beta)
*****************************************************/

/******************************************************
Estimate the local Projections
******************************************************/
{sig_lp_sw, sig_H_lp_sw, betlp_sw} = proj(z[1:T,.], hmax, psw); 
{sig_lp1_sw, sig_H_lp1_sw} = pirf(z[1:T,.], psw, hmax);
/*****************************************************
Same issue with the lag length. Change psw to p if you
like to use automatic information criteria selection

sig_H_lp is calculated directly from the 
residuals as sig_H_lp = (u'u/T)

sig_h_lp1 is calculated using the estimated MA
coefficients from the projections, that is,
sig_H_LP1 = Phi*(eye(h).*.sig_u)*Phi'
*******************************************************/
//{irf} = varirf(beta, psw, hmax); 
/*******************************************************
I left this line in in case you want to check the impulse
responses of the VAR but it is not used in the paper
*******************************************************/
// These entries are for VAR forecasts
// Forecast based on obs X_Tp
X_Tp = 1~reshape(z[T:T-psw,.],1,psw*vars);

// Forecast and forecast error variance (including estimation error)
{y_H_sw, Xi_H_sw, sig_H_sw} = varfcst(beta, psw, vars, sig_u_sw, hmax, sig_a_sw, X_Tp', T);

//These entries are for Local Projection Forecasts
//Forecast from the projections
y_H_LP_sw = (X_Tp*betlp_sw)';

// Forecast error variance from projections (sig_H_LP)
Xi_H_LP_sw = (X_Tp.*.eye(vars*hmax))*sig_lp_sw*(X_Tp'.*.eye(vars*hmax));
Xi_H_LP_sw = Xi_H_LP_sw + sig_H_lp_sw;

// Forecast error variance from projections (sig_H_LP1)
Xi_H_LP1_sw = (X_Tp.*.eye(vars*hmax))*sig_lp1_sw*(X_Tp'.*.eye(vars*hmax));
Xi_H_LP1_sw = Xi_H_LP1_sw + sig_H_lp1_sw;

// This section does graphs for the Stock-Watson VAR


y_H_sw = reshape(y_H_sw, hmax, vars);
y_H_LP_sw = reshape(y_H_LP_sw, hmax, vars);

zf = z[T-pres+1:T+hmax,.];
saux = eye(vars);
mbp_sw = zeros(hmax, vars);
mbn_sw = zeros(hmax, vars);
sbp_sw = zeros(hmax, vars);
sbn_sw = zeros(hmax, vars);
bbp_sw = zeros(hmax, vars);
bbn_sw = zeros(hmax, vars);

j = 1;
do while j le vars;

    s = eye(hmax).*.saux[j,.];
    xi_sw = s*xi_H_sw*s';
    {mbp_sw[.,j], mbn_sw[.,j]} = marband(y_H_sw[.,j], xi_sw, 0.05);
    {sbp_sw[.,j], sbn_sw[.,j]} = scheffe(y_H_sw[.,j], xi_sw, 0.05);
    {bbp_sw[.,j], bbn_sw[.,j]} = bonfband(y_H_sw[.,j], xi_sw, 0.05);
  
   j = j+1;
endo;
y_H_sw = z[T-pres+1:T,.]|y_H_sw;
y_H_LP_sw = z[T-pres+1:T,.]|y_H_LP_sw;

mbp_sw = z[T-pres+1:T,.]|mbp_sw;
mbn_sw = z[T-pres+1:T,.]|mbn_sw;
sbp_sw = z[T-pres+1:T,.]|sbp_sw;
sbn_sw = z[T-pres+1:T,.]|sbn_sw;
bbp_sw = z[T-pres+1:T,.]|bbp_sw;
bbn_sw = z[T-pres+1:T,.]|bbn_sw;


begwind;
window(1,3,0);

setwind(1);
//title("Probability: "$+ftocv(1-alpha[1],3,2));
title(sers[1]);
xlabel("Horizon");
_pltype = {1,2,2,4,4,3,3,6};
_pcolor = {10,7,7,3,3,12,12,1};
_plwidth = 8;
_pnumht = 0.18;
_ptitlht = 0.25;
xy(seqa(-1,1,hmax+pres), y_H_sw[.,1]~mbp_sw[.,1]~mbn_sw[.,1]~sbp_sw[.,1]~sbn_sw[.,1]~bbp_sw[.,1]~bbn_sw[.,1]~zf[.,1]);
s = 2;
do while s le vars;
    nextwind;
    //title("Probability: "$+ftocv(1-alpha[s],3,2));
    title(sers[s]);
    xlabel("Horizon");
    xy(seqa(-1,1,hmax+pres), y_H_sw[.,s]~mbp_sw[.,s]~mbn_sw[.,s]~sbp_sw[.,s]~sbn_sw[.,s]~bbp_sw[.,s]~bbn_sw[.,s]~zf[.,s]);
    s = s+1;
endo;

endwind;



/*******************************************************
Libraries
********************************************************/
#include jae_mc.src;
library pgraph;
graphset;

