/************************************************************
"Path Forecast Evaluation" by Marcellino and Jorda (2008)
This program does path forecasts with linear local projections
used in the empirical application of the paper

This program does figure 5

Author: Oscar Jorda
Initial Date: 1/29/07
Last Revised: 8/30/07
*************************************************************/
new;
cls;
/*******************************************************
Inital Analysis Choices
*******************************************************/
vars = 4;           // Variables in the data set
plg = 1;            // 0 if lag lenght set to maxp; 1 if chosen automatically
maxp = 8;          // Max Lag length for info criteria
infoc = 1;          // 1 for AICc, 2 for AIC, 3 for SIC
h = 8;              // Max horizon of the forecast path
dograph = 1;         // 1 to display graph, 0 otherwise
gtime = 16;         // Periods displayed before forecast
ci = 2;             // Counterfactual Variable
rr = seqa(-0.55,0,h); // Counterfactual experiment
/******************************************************
load the Data
******************************************************/
load z[] = massi207.csv;
z = reshape(z, rows(z)/(vars+3), (vars+3));
az = z[rows(z)-114:rows(z),.]; 
z = z[1@rows(z)-114@:rows(z)-10,.];
sers = "GDP Growth"$|"PCE Inflation"$|"Fed Funds Rate"$|"10 Year T-Bond";
T = rows(z);

d = z[.,cols(z)-2:cols(z)]~zeros(T,1);
z = z[.,1:vars];
dat = datestr(d[1,.]);
i = 2;
d = d|zeros(h,4);
hi = 1;
do while hi le h;
    if d[T+hi-1,2] < 10;
        d[T+hi,1] = d[T+hi-1,1];
        d[T+hi,2] = d[T+hi-1,2] + 3;
    else;
        d[T+hi,1] = d[T+hi-1,1] + 1;
        d[T+hi,2] = 1;
    endif;
    d[T+hi,3] = 1;
    hi = hi+1;
endo;
do while i le T+h;
    dat = dat|datestr(d[i,.]);
    i = i+1;
endo;

/*****************************************************
Determine the lag length
*****************************************************/
{aicc, aic, sic, p} = lagcrit(z, plg, maxp, infoc);
/*****************************************************
Compute parameter estimates and inv(x'x)
*****************************************************/
{invxx, bb} = proj(z, h, p);
/*****************************************************
Compute Sigma_h matrix
******************************************************/
{sigh} = pirf(z, p);
/******************************************************
Compute Forecasts and their covariance matrix
******************************************************/
x = z[T,.];
i = 1;
do while i le p-1;
    x = x~z[T-i,.];
    i = i+1;
endo;
x = x~1;
{yTh, phih} = fpath(x, bb, sigh, invxx, vars);
zTh = reshape(yth, h, vars);
zThse = diag(phih)^0.5;
zthse = reshape(zthse, h, vars);
/******************************************************
Compute Scheffe Bounds and conditional error bands
******************************************************/
R = eye(vars);
hith = zeros(h,vars);
loth = zeros(h,vars);
chith = zeros(h,vars);
cloth = zeros(h,vars);


hit = seqa(1,1,h);
k = (cdfchii(0.95,hit)./hit).^0.5;

i = 1;
do while i le vars;
    S = eye(h).*.R[i,.];
    ephi = S*phih*S';
    PP = chol(ephi);
    hith[.,i] = zth[.,i] + PP'k;
    loth[.,i] = zth[.,i] - PP'k;
    PP = diag(crout(ephi))^0.5;
    chith[.,i] = zth[.,i] + PP*cdfni(0.975);
    cloth[.,i] = zth[.,i] - PP*cdfni(0.975);
       
    i = i+1;
endo;
/******************************************************
Counterfactual Forecasts
******************************************************/
S1 = eye(h).*.R[1,.];
S2 = eye(h).*.R[2,.];
S3 = eye(h).*.R[3,.];
S4 = eye(h).*.R[4,.];
"-----------------------------------------------------------------";
"Counterfactual path for variable: ";; sers[ci];
"Counterfactual modifies predicted path by adding the following: ";
rr;
"-----------------------------------------------------------------";
if ci eq 1;
    Si = S1;
elseif ci eq 2;
    Si = s2;
elseif ci eq 3;
    Si = s3;
else;
    Si = s4;
endif;

lcw = (rr)'*inv(Si*phih*Si')*(rr);
"Distance between counterfactual and forecast, p-value ";; cdfchic(lcw,h);
"Distance from the forecast in prob units";; (1 - cdfchic(lcw,h));

// Counterfactual path of Output
f1i = zth[.,1] + S1*phih*Si'inv(Si*phih*Si')*rr;
//covariance matrix
phih1i = S1*phih*s1' - S1*phih*Si'inv(Si*phih*si')*si*phih*s1';
if abs(sumc(eigrs(phih1i))) le 0.0001;
"Conditional VCV for GDP negative";
f1ihi =  chith[.,1];
f1ilo =  cloth[.,1];
else;
pp = diag(chol(phih1i[2:h,2:h]));
pp = (phih1i[1,1]^0.5)|pp;
f1ihi = f1i + PP*cdfni(0.975);
f1ilo = f1i - PP*cdfni(0.975);
endif;

// Counterfactual path of Inflation
f2i = zth[.,2] + S2*phih*Si'inv(Si*phih*Si')*(rr);
//covariance matrix
phih2i = S2*phih*s2' - S2*phih*Si'inv(Si*phih*si')*si*phih*s2';
if abs(sumc(eigrs(phih2i))) le 0.0001;
"Conditional VCV for PCE negative";

f2ihi =  chith[.,2];
f2ilo =  cloth[.,2];
    
else;
pp = diag(chol(phih2i[2:h,2:h]));
pp = (abs(phih2i[1,1])^0.5)|pp;
f2ihi = f2i + PP*cdfni(0.975);
f2ilo = f2i - PP*cdfni(0.975);
endif;

// Counterfactual path of FF
f3i = zth[.,3] + S3*phih*Si'inv(Si*phih*Si')*(rr);
//covariance matrix
phih3i = S3*phih*s3' - S3*phih*Si'inv(Si*phih*si')*si*phih*s3';
if abs(sumc(eigrs(phih3i))) le 0.0001;
"Conditional VCV for FF negative";

f3ihi = chith[.,3];
f3ilo  = cloth[.,3];
else;
pp = diag(chol(phih3i[2:h,2:h]));
pp = (abs(phih3i[1,1])^0.5)|pp;
f3ihi = f3i + PP*cdfni(0.975);
f3ilo = f3i - PP*cdfni(0.975);
endif;

// Counterfactual path of 10 Year T-Bond
f4i = zth[.,4] + S4*phih*Si'inv(Si*phih*Si')*(rr);
//covariance matrix
phih4i = S4*phih*s4' - S4*phih*Si'inv(Si*phih*si')*si*phih*s4';
if abs(sumc(eigrs(phih4i))) le 0.001;
"Conditional VCV for TB10 negative";

f4ihi = chith[.,4];
f4ilo  = cloth[.,4];
else;
pp = diag(chol(phih4i[2:h,2:h]));
pp = (abs(phih4i[1,1])^0.5)|pp;
f4ihi = f4i + PP*cdfni(0.975);
f4ilo = f4i - PP*cdfni(0.975);
endif;

/******************************************************
Plot the Forecasts
******************************************************/


obs = seqa(1,1,gtime+h);
if dograph eq 1;
begwind;
window(2,2,0);

fecha = dat[T-gtime+1:rows(dat),.];
f = fecha[1,.];
i = 1;
do while i < rows(obs)/8;
    f = f|fecha[1+8*i,.];
    i = i+1;
endo;

z1 = z[T-gtime+1:T,.]|zth;
zhise = z[T-gtime+1:T,.]|(zth+1.96*zthse);
zlose = z[T-gtime+1:T,.]|(zth-1.96*zthse);
hhith = z[T-gtime+1:T,.]|hith;
lloth = z[T-gtime+1:T,.]|loth;
chhith = z[T-gtime+1:T,.]|chith;
clloth = z[T-gtime+1:T,.]|cloth;

f1i   = z[T-gtime+1:T,1]|f1i;
f1ihi = z[T-gtime+1:T,1]|f1ihi;
f1ilo = z[T-gtime+1:T,1]|f1ilo;
f2i   = z[T-gtime+1:T,2]|f2i;
f2ihi = z[T-gtime+1:T,2]|f2ihi;
f2ilo = z[T-gtime+1:T,2]|f2ilo;
f3i   = z[T-gtime+1:T,3]|f3i;
f3ihi = z[T-gtime+1:T,3]|f3ihi;
f3ilo = z[T-gtime+1:T,3]|f3ilo;
f4i   = z[T-gtime+1:T,4]|f4i;
f4ihi = z[T-gtime+1:T,4]|f4ihi;
f4ilo = z[T-gtime+1:T,4]|f4ilo;

fith = f1i~f2i~f3i~f4i;
fihi = f1ihi~f2ihi~f3ihi~f4ihi;
filo = f1ilo~f2ilo~f3ilo~f4ilo;

setwind(1);
title(sers[1]);
xlabel("Counterfactual");
_pltype = { 3, 3, 1, 1, 2, 2, 6, 6, 6};
_pcolor = { 12, 12, 7, 7, 4, 4, 6, 8, 11};
_plwidth = 8;
_pnumht = 0.18;
_ptitlht = 0.25;
xtics(1,rows(obs),8,0);
asclabel(f,0);

i = 1;
    xy(obs, fihi[.,i]~filo[.,i]~chhith[.,i]~clloth[.,i]~chhith[.,i]~clloth[.,i]~z1[.,i]~fith[.,i]~az[rows(az)-25:rows(az)-2,i]);
i = 2;
do while i le vars;
    nextwind;
    title(sers[i]);
    xlabel("Counterfactual");
    xy(obs, fihi[.,i]~filo[.,i]~chhith[.,i]~clloth[.,i]~chhith[.,i]~clloth[.,i]~z1[.,i]~fith[.,i]~az[rows(az)-25:rows(az)-2,i]);
    i = i+1;
endo;
endwind;
endif;


/******************************************************
Libraries
******************************************************/
#include jae_lp.src;
library pgraph;
graphset;

