/************************************************************
"Path Forecast Evaluation" by Marcellino and Jorda (2008)
This program does path forecasts with linear local projections
used in the empirical application of the paper

This program replicates figure 4

Author: Oscar Jorda
Initial Date: 1/29/07
Last Revised: 7/16/08
*************************************************************/
new;
cls;
/*******************************************************
Inital Analysis Choices
*******************************************************/
vars = 4;           // Variables in the data set
plg = 1;            // 0 if lag lenght set to maxp; 1 if chosen automatically
maxp = 8;          // Max Lag length for info criteria
infoc = 1;          // 1 for AICc, 2 for AIC, 3 for SIC
h = 8;              // Max horizon of the forecast path
dograph = 1;         // 1 to display graph, 0 otherwise
gtime = 16;         // Periods displayed before forecast
/******************************************************
load the Data
******************************************************/
load z[] = massi207.csv; // Load the data. Note it contains dates
z = reshape(z, rows(z)/(vars+3), (vars+3));
az = z[rows(z)-114:rows(z),.]; 
z = z[1:rows(z)-10,.];
sers = "GDP Growth"$|"PCE Inflation"$|"Fed Funds Rate"$|"10 Year T-Bond";
T = rows(z);

d = z[.,cols(z)-2:cols(z)]~zeros(T,1); // Select the columns with the dates
z = z[.,1:vars]; // Data with no dates
/*******************************************************
This part manages the dates for the data and is used
to construct the graphs later on only
********************************************************/
dat = datestr(d[1,.]);
i = 2;
d = d|zeros(h,4);
hi = 1;
do while hi le h;
    if d[T+hi-1,2] < 10;
        d[T+hi,1] = d[T+hi-1,1];
        d[T+hi,2] = d[T+hi-1,2] + 3;
    else;
        d[T+hi,1] = d[T+hi-1,1] + 1;
        d[T+hi,2] = 1;
    endif;
    d[T+hi,3] = 1;
    hi = hi+1;
endo;
do while i le T+h;
    dat = dat|datestr(d[i,.]);
    i = i+1;
endo;
/*****************************************************
Determine the lag length
*****************************************************/
{aicc, aic, sic, p} = lagcrit(z, plg, maxp, infoc);
/*****************************************************
Compute parameter estimates and inv(x'x)
*****************************************************/
{invxx, bb} = proj(z, h, p);
/*****************************************************
Compute Sigma_h matrix
******************************************************/
{sigh} = pirf(z, p);
/******************************************************
Compute Forecasts and their covariance matrix
******************************************************/
x = z[T,.];
i = 1;
do while i le p-1;
    x = x~z[T-i,.];
    i = i+1;
endo;
x = x~1;
{yTh, phih} = fpath(x, bb, sigh, invxx, vars);
zTh = reshape(yth, h, vars);
zThse = diag(phih)^0.5;
zthse = reshape(zthse, h, vars);

/******************************************************
Compute Scheffe Bounds and conditional error bands
******************************************************/
R = eye(vars);
hith = zeros(h,vars);
loth = zeros(h,vars);
chith = zeros(h,vars);
cloth = zeros(h,vars);


hit = seqa(1,1,h);
k = (cdfchii(0.95,hit)./hit).^0.5;

i = 1;
do while i le vars;
    
S = eye(h).*.R[i,.];
    ephi = S*phih*S';
    PP = chol(ephi);
    hith[.,i] = zth[.,i] + PP'k;
    loth[.,i] = zth[.,i] - PP'k;
    PP = diag(crout(ephi))^0.5;
    chith[.,i] = zth[.,i] + PP*cdfni(0.975);
    cloth[.,i] = zth[.,i] - PP*cdfni(0.975);
       
    i = i+1;
endo;
/******************************************************
Plot the Forecasts
******************************************************/
obs = seqa(1,1,gtime+h);
if dograph eq 1;
begwind;
window(2,2,0);

fecha = dat[T-gtime+1:rows(dat),.];
f = fecha[1,.];
i = 1;
do while i < rows(obs)/8;
    f = f|fecha[1+8*i,.];
    i = i+1;
endo;

z1 = z[T-gtime+1:T,.]|zth;
zhise = z[T-gtime+1:T,.]|(zth+1.96*zthse);
zlose = z[T-gtime+1:T,.]|(zth-1.96*zthse);
hhith = z[T-gtime+1:T,.]|hith;
lloth = z[T-gtime+1:T,.]|loth;
chhith = z[T-gtime+1:T,.]|chith;
clloth = z[T-gtime+1:T,.]|cloth;

setwind(1);
title(sers[1]);
xlabel("Observation");
//xlabel("Counterfactual");
_pltype = { 3, 3, 1, 1, 2, 2, 6, 6, 6};
_pcolor = { 12, 12, 7, 7, 4, 4, 6, 8, 11};
_plwidth = 8;
_pnumht = 0.18;
_ptitlht = 0.25;
xtics(1,rows(obs),8,0);
asclabel(f,0);
xy(obs, zhise[.,1]~zlose[.,1]~hhith[.,1]~lloth[.,1]~chhith[.,1]~clloth[.,1]~z1[.,1]~az[rows(az)-25:rows(az)-2,1]);
i = 2;
do while i le vars;
    nextwind;
    title(sers[i]);
    xlabel("Observation");
    xy(obs, zhise[.,i]~zlose[.,i]~hhith[.,i]~lloth[.,i]~chhith[.,i]~clloth[.,i]~z1[.,i]~az[rows(az)-25:rows(az)-2,i]);
    i = i+1;
endo;

endwind;
    
endif;

/******************************************************
Libraries
******************************************************/
#include jae_lp.src;
library pgraph;
graphset;



