function OUT = Num2NaN(DATA)
% =======================================================================
% Substitute 123456789 values with NaN 
% =======================================================================
% OUT = Num2NaN(DATA)
% -----------------------------------------------------------------------
% INPUT
%	- DATA: a (m x n) matrix with some 123456789
% -----------------------------------------------------------------------
% OUTPUT
%	- OUT: a (m x n) matrix with NaN in place of 123456789
% -----------------------------------------------------------------------
% EXAMPLE
%   x = [123456789 2; 123456789 4; 5 6; 7 8; 9 10];
%   OUT = Num2NaN(x)
% =======================================================================
% VAR Toolbox 3.0
% Ambrogio Cesa-Bianchi
% ambrogiocesabianchi@gmail.com
% March 2012. Updated November 2020
% -----------------------------------------------------------------------

OUT=DATA;
for i=1:size(DATA,1)
    for j=1:size(DATA,2)
        if DATA(i,j) == 123456789
            OUT(i,j) = NaN;
        end
    end
end

