*********************************************************************

* CONSTRUCTION OF A GENERAL DATA SET FROM THE SURVEY 
* "Mental Health of Children and Young People in Great Britain, 2004"

use "cpm9904.dta", clear

renvars, prefix(z)
rename zsampyear year
drop if year==1999
label define answ 1 yes 0 no

*********************************************************************

* HOUSEHOLD VARIABLES

rename zgormain region
rename zdvhsize hhsize
rename znumadult nadults
rename znumchild nchilds
rename znumch18 nchildslt18
rename zaccom housetyp
rename zten1 houseown
rename zllord llord

*********************************************************************

* GENERAL CHILD VARIABLES
rename zchildno childno
rename zchldage age
rename zchldsex sex
gen male = 2 - sex
label var male "Child is male"
gen white = zethgpc1==1
gen black = zethgpc1>=2 & zethgpc1<=3
gen asian = zethgpc1>=4 & zethgpc1<=6
gen ethother = zethgpc1>=7 & zethgpc1<=8
label var white "Child's ethnicity is white"
label var black "Child's ethnicity is black"
label var asian "Child's ethnicity is asian"
label var ethother "Child's ethnicity is other"
rename zgenhlth genhlth
* Work
rename zypdwk work 
replace work = . if work>=8
replace work = 2 - work
label values work answ
local jobs familybus newspaper shop labourer chores
foreach k of local jobs {
gen `k' = 0 if work!=.
}
forvalues i=1(1)6 {
replace familybus = 1 if zywhtwk`i'==1
replace newspaper = 1 if zywhtwk`i'==2
replace shop = 1 if zywhtwk`i'==3
replace labourer = 1 if zywhtwk`i'==4
replace chores= 1 if zywhtwk`i'==5
}
label var familybus "Type of child's monthly paid work"
label var newspaper "Type of child's monthly paid work"
label var shop "Type of child's monthly paid work"
label var labourer "Type of child's monthly paid work"
label var chores "Type of child's monthly paid work"

*********************************************************************

* CHILD ILLNESS
local healthprob hp_asthma hp_eczema hp_hayfever hp_gluear hp_bedwet hp_soilpant hp_stomach hp_heart hp_blood hp_epilepsy hp_foodall hp_othall  ///
hp_hyperact hp_behav hp_emot hp_learn hp_dyslexia hp_cerebpal hp_migraine hp_chronfat hp_eyesight hp_speech hp_hearing  ///
hp_diabetes hp_obesity hp_cystfib hp_spinabif hp_kidney hp_misslimb hp_stiff hp_muscle hp_coordinat hp_cancer
foreach k of local healthprob {
gen `k' = 0 if zb401>-1 & zb401<99
}
forvalues i=1(1)9 {
replace hp_asthma = 1 if zb40`i'==1
replace hp_eczema = 1 if zb40`i'==2
replace hp_hayfever = 1 if zb40`i'==3
replace hp_gluear = 1 if zb40`i'==4
replace hp_bedwet = 1 if zb40`i'==5
replace hp_soilpant = 1 if zb40`i'==6
replace hp_stomach = 1 if zb40`i'==7
replace hp_heart = 1 if zb40`i'==8
replace hp_blood = 1 if zb40`i'==9
replace hp_epilepsy = 1 if zb40`i'==10
replace hp_foodall = 1 if zb40`i'==11
replace hp_othall = 1 if zb40`i'==12
replace hp_hyperact = 1 if zb4a0`i'==1
replace hp_behav = 1 if zb4a0`i'==2
replace hp_emot = 1 if zb4a0`i'==3
replace hp_learn = 1 if zb4a0`i'==4
replace hp_dyslexia = 1 if zb4a0`i'==5
replace hp_cerebpal = 1 if zb4a0`i'==6
replace hp_migraine = 1 if zb4a0`i'==7
replace hp_chronfat = 1 if zb4a0`i'==8
replace hp_eyesight = 1 if zb4a0`i'==9
replace hp_speech = 1 if zb4a0`i'==10
replace hp_hearing = 1 if zb4a0`i'==11
replace hp_diabetes = 1 if zb50`i'==1
replace hp_obesity = 1 if zb50`i'==2
replace hp_cystfib = 1 if zb50`i'==3
replace hp_spinabif = 1 if zb50`i'==4
replace hp_kidney = 1 if zb50`i'==5
replace hp_misslimb = 1 if zb50`i'==6
replace hp_stiff = 1 if zb50`i'==7
replace hp_muscle = 1 if zb50`i'==8
replace hp_coordinat = 1 if zb50`i'==9
replace hp_cancer = 1 if zb50`i'==11
}
drop zb4* zb5*

*********************************************************************

* Child Mental Disorders

* ICD-10
gen icdany = zany_ic
gen icdemot = zemot_ic
gen icdcond = zanycd_ic
gen icdhyper = zhyper_ic
gen icdanxiety = zanyan_ic
renvars *_ic, predrop(1)
label var icdany "ICD-10 any mental disorder"
label var icdemot "ICD-10 any emotional"
label var icdcond "ICD-10 any conduct disorder"
label var icdhyper "ICD-10 any hyperactivity"
label var icdanxiety "ICD-10 any anxiety"

*********************************************************************

* CHILD SMOKING / ALCOHOL / DRUG
* smoke
rename zc3e1 smoke
replace smoke = . if smoke>=8
replace smoke = smoke - 1
label values smoke answ
gen neversmoke = 0 if smoke!=.
replace neversmoke = 1 if zc3e3==1
label var neversmoke "Never tried smoking"
* alcohol
rename zc3f1 everdrink
replace everdrink = . if everdrink>=8
replace everdrink = everdrink - 1
label values everdrink answ
gen drinkmth = 0 if everdrink!=.
replace drinkmth = 1 if zc3f2<=5
label variable drinkmth "Drink at least monthly"
* marijuana
rename zc3c2 everweed
replace everweed = . if everweed>=8
replace everweed = 1 if everweed==3
replace everweed = everweed - 1
label values everweed answ
rename zc3c4 ageweed

*********************************************************************

* CHILD MEDICATION
gen medicine = 2 - zb12  
label var medicine "Child takes listed medication"
rename zb12a01 medicine1 
rename zb12a02 medicine2
drop zb12* 

*********************************************************************

* PARENT VARIABLES
* General
rename zadultno parentno 
rename zadltsex psex 
rename zdvmardf mstatus  
forvalues i=2(1)5 {
replace mstatus = zdvmardf`i' if parentno==`i'
}
gen pwhite = zethgrp1==1
gen pblack = zethgrp1>=2 & zethgrp1<=3
gen pasian = zethgrp1>=4 & zethgrp1<=6
gen pethother = zethgrp1>=7 & zethgrp1<=8
label var pwhite "Parent's ethnicity is white"
label var pblack "Parent's ethnicity is black"
label var pasian "Parent's ethnicity is asian"
label var pethother "Parent's ethnicity is other"
* Education
rename zschleft agelefted
replace agelefted = . if agelefted>=99
gen degree = zhiquals==1
gen vocqual = zhiquals==2
gen alevels = zhiquals>=3 & zhiquals<=4
gen olevels = zhiquals==5
label var degree "Responding parent's highest educ qual"
label var vocqual "Responding parent's highest educ qual"
label var alevels "Responding parent's highest educ qual"
label var olevels "Responding parent's highest educ qual"
* Employment status
rename zwrking employed
replace employed = . if employed>=8
replace employed = 2 - employed
label values employed answ
rename zpwrking pemployed
replace pemployed = . if pemployed>=8
replace pemployed = 2 - pemployed
replace pemployed = 0 if employed!=. & pemployed==. 
label values pemployed answ
* Income
gen ownincmid = .
replace ownincmid = 1000*(zgrossinc-1)+500 if zgrossinc<=15
replace ownincmid = 16250 if zgrossinc==16
replace ownincmid = 18750 if zgrossinc==17
replace ownincmid = 22500 if zgrossinc==18
replace ownincmid = 27500 if zgrossinc==19
replace ownincmid = 35000 if zgrossinc==20
replace ownincmid = 45000 if zgrossinc==21
label var ownincmid "Responding parent's own personal gross income - midpoint"
gen hhincmid = .
replace hhincmid = 1000*(zhhldinc-1)+500 if zhhldinc<=15
replace hhincmid = 16250 if zhhldinc==16
replace hhincmid = 18750 if zhhldinc==17
replace hhincmid = 22500 if zhhldinc==18
replace hhincmid = 27500 if zhhldinc==19
replace hhincmid = 35000 if zhhldinc==20
replace hhincmid = 45000 if zhhldinc==21
*replace hhincmid = 500 if zhhldinc==22
label var hhincmid "Household's gross income - midpoint"
rename zhhldinc hhinc
gen inc0to10 = hhincmid<=10000
gen inc10to20 = hhincmid>10000 & hhincmid<=20000
gen inc20to30 = hhincmid>20000 & hhincmid<=30000
gen inc30to40 = hhincmid>30000 & hhincmid<=40000
gen inc40plus = hhincmid>40000 & hhincmid!=.
gen incmiss = hhincmid==.
label var inc0to10 "Household income 0 to 10,000"
label var inc10to20 "Household income 10,000 to 20,000"
label var inc20to30 "Household income 20,000 to 30,000"
label var inc30to40 "Household income 30,000 to 40,000"
label var inc40plus "Household income over 40,000"
label var incmiss "Household income missing"
gen incq1 = hhincmid<=13500
gen incq2 = hhincmid>13500 & hhincmid<=22500
gen incq3 = hhincmid>22500 & hhincmid<=35000
gen incq4 = hhincmid>35000 & hhincmid!=.
gen incqmiss = hhincmid==.
* Real Income
gen rownincmid = ownincmid/1.117
label var rownincmid "Real own personal gross income - 2001 prices"
gen rhhincmid = hhincmid/1.117
label var rhhincmid "Real household gross income - 2001 prices"
gen rinc0to10 = rhhincmid<=10000
gen rinc10to20 = rhhincmid>10000 & rhhincmid<=20000
gen rinc20to30 = rhhincmid>20000 & rhhincmid<=30000
gen rinc30to40 = rhhincmid>30000 & rhhincmid<=40000
gen rinc40plus = rhhincmid>40000 & rhhincmid!=.
gen rincmiss = rhhincmid==.
label var rinc0to10 "Real household income 0 to 10,000"
label var rinc10to20 "Real household income 10,000 to 20,000"
label var rinc20to30 "Real household income 20,000 to 30,000"
label var rinc30to40 "Real household income 30,000 to 40,000"
label var rinc40plus "Real household income over 40,000"
label var rincmiss "Real household income missing"
* GHQ12
renvars zgh1-zgh12, predrop(1)
local ghq12 gh1 gh2 gh3 gh4 gh5 gh6 gh7 gh8 gh9 gh10 gh11 gh12
foreach k of local ghq12 {
replace `k' = . if `k'>=8
replace `k' = `k'-1
}
egen ghqlikert = rowmean(gh1 gh2 gh3 gh4 gh5 gh6 gh7 gh8 gh9 gh10 gh11 gh12)
replace ghqlikert = round(12*ghqlikert)
label var ghqlikert "Sum of the 12 parent GHQ measures"

*********************************************************************

* TEACHER RESPONSE RATE
rename zteachc consent

*********************************************************************

* SCHOOL ABSENCE
* Parental measures
rename zschool schoolft
replace schoolft = . if schoolft>=9
replace schoolft = 2 - schoolft
label values schoolft answ
rename zexcever exclude
replace exclude = . if exclude>=9
replace exclude = 2 - exclude
label values exclude answ
rename zexcnum nexclude 
replace nexclude = . if nexclude>=99
rename zexcfix excludetyp
rename zlongmis pdaysmiss
replace pdaysmiss = . if pdaysmiss>=9999 
replace pdaysmiss = 0 if zmissch==2
local misreas illst illlt refused phobia
foreach k of local misreas {
gen `k' = 0 if pdaysmiss!=.
}
forvalues i=1(1)4 {
replace illst = 1 if zwhymis`i'==1
replace illlt = 1 if zwhymis`i'==2
replace refused = 1 if zwhymis`i'==3
replace phobia= 1 if zwhymis`i'==4
}
label var illst "Reason for child's school absence"
label var illlt "Reason for child's school absence"
label var refused "Reason for child's school absence"
label var phobia "Reason for child's school absence"
* Teacher measures
rename ztlongmis tdaysmiss
rename ztauthmis twagdays
rename ztneeds specneeds

*********************************************************************

* COGNITIVE DEVELOPMENT MEASURES
* Parental measures
rename zxr1 preaslevel
replace preaslevel = . if preaslevel>=8
rename zxr2 preasage 
replace preasage = . if preasage>=99
rename zxr3 planglevel
replace planglevel = . if planglevel>=8
rename zxr4 plangage 
replace plangage = . if plangage>=99
rename zlrndifa pread
rename zlrndifb pmath
rename zlrndifc pspell
replace pread = . if pread>=9
replace pmath = . if pmath>=9
replace pspell = . if pspell>=9
* Teacher measures
rename zda1a tread
rename zda1b tmath
rename zda1c tspell
rename zda2 tagelevel
replace tagelevel = . if tagelevel>=19

*********************************************************************

* SDQ MEASURES
* Parental measures
local sdqvars d4p d5p d6p d7p d8p d9p d10p d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 d28
foreach k of local sdqvars {
replace z`k' = . if z`k'<=3 | z`k'>=9
replace z`k' = z`k' - 5
}
rename zd4p zd4
rename zd5p zd5
rename zd6p zd6
rename zd7p zd7
rename zd8p zd8
rename zd9p zd9
rename zd10p zd10
gen zd10r = 2 - zd10
gen zd14r = 2 - zd14
gen zd17r = 2 - zd17
gen zd24r = 2 - zd24
gen zd28r = 2 - zd28
egen psdqemot = rowtotal(zd6 zd11 zd16 zd19 zd27) if zd6!=. & zd11!=. & zd16!=. & zd19!=. & zd27!=.
egen psdqcond = rowtotal(zd8 zd10r zd15 zd21 zd25) if zd8!=. & zd10r!=. & zd15!=. & zd21!=. & zd25!=.
egen psdqhyper = rowtotal(zd5 zd13 zd18 zd24r zd28r) if zd5!=. & zd13!=. & zd18!=. & zd24r!=. & zd28r!=.
egen psdqpeer = rowtotal(zd9 zd14r zd17r zd22 zd26) if zd9!=. & zd14r!=. & zd17r!=. & zd22!=. & zd26!=.
egen psdqprosoc = rowtotal(zd4 zd7 zd12 zd20 zd23) if zd4!=. & zd7!=. & zd12!=. & zd20!=. & zd23!=.
egen psdqtotal = rowtotal(psdqemot psdqcond psdqhyper psdqpeer) if psdqemot!=. & psdqcond!=. & psdqhyper!=. & psdqpeer!=.
renvars zd4 zd5 zd6 zd7 zd8 zd9 zd10 zd11 zd12 zd13 zd14 zd15 zd16 zd17 zd18 zd19 zd20 zd21 zd22 zd23 zd24 zd25 zd26 zd27 zd28, predrop(1)
* Teacher measures
rename ztconsid zdb1   // considerate of other peoples feelings
rename ztrestles zdb2   // restless, overactive
rename ztsomatic zdb3   // often complains of headaches, stomach aches or sickness
rename ztshares zdb4    // shares readily with other children
rename zttantrum zdb5   // often has temper tantrums or hot tempers
rename ztloner zdb6     // rather solitary, tends to play alone
rename ztobeys zdb7     // generally obedient
rename ztworries zdb8   // many worries
rename ztcaring zdb9    // helpful if someone is hurt etc
rename ztfidgety zdb10   // constantly fidgeting or squirming
rename ztfriend zdb11    // has at least one good friend
rename ztfights zdb12    // often fights with other children or bullies them
rename ztunhappy zdb13   // often unhappy, downhearted or tearful
rename ztpopular zdb14   // liked by other children
rename ztdistrac zdb15   // easily distracted
rename ztclingy zdb16    // nervous or clingy in new situations
rename ztkind zdb17      // kind to younger children
rename ztlies zdb18      // often lies or cheats
rename ztbullied zdb19   // picked on or bullied by other children
rename zthelpout zdb20   // often volunteers to help others
rename ztreflect zdb21   // thinks things out before acting
rename ztsteals zdb22    // steals
rename ztoldbest zdb23   // gets on better with adults than with other children
rename ztafraid zdb24    // many fears, easily scared
rename ztattends zdb25   // sees tasks through to the end - good attention span
gen zdb7r = 2 - zdb7
gen zdb11r = 2 - zdb11
gen zdb14r = 2 - zdb14
gen zdb21r = 2 - zdb21
gen zdb25r = 2 - zdb25
egen tsdqemot = rowtotal(zdb3 zdb8 zdb13 zdb16 zdb24) if zdb3!=. & zdb8!=. & zdb13!=. & zdb16!=. & zdb24!=.
egen tsdqcond = rowtotal(zdb5 zdb7r zdb12 zdb18 zdb22) if zdb5!=. & zdb7r!=. & zdb12!=. & zdb18!=. & zdb22!=.
egen tsdqhyper = rowtotal(zdb2 zdb10 zdb15 zdb21r zdb25r) if zdb2!=. & zdb10!=. & zdb15!=. & zdb21r!=. & zdb25r!=.
egen tsdqpeer = rowtotal(zdb6 zdb11r zdb14r zdb19 zdb23) if zdb6!=. & zdb11r!=. & zdb14r!=. & zdb19!=. & zdb23!=.
egen tsdqprosoc = rowtotal(zdb1 zdb4 zdb9 zdb17 zdb20) if zdb1!=. & zdb4!=. & zdb9!=. & zdb17!=. & zdb20!=.
egen tsdqtotal = rowtotal(tsdqemot tsdqcond tsdqhyper tsdqpeer) if tsdqemot!=. & tsdqcond!=. & tsdqhyper!=. & tsdqpeer!=.
renvars zdb1 zdb2 zdb3 zdb4 zdb5 zdb6 zdb7 zdb8 zdb9 zdb10 zdb11 zdb12 zdb13 zdb14 zdb15 zdb16 zdb17 zdb18 zdb19 zdb20 zdb21 zdb22 zdb23 zdb24 zdb25, predrop(1)
* Child measures
local sdqvars cb4 cb5 cb6 cb7 cb8 cb9 cb10 cb11 cb12 cb13 cb14 cb15 cb16 cb17 cb18 cb19 cb20 cb21 cb22 cb23 cb24 cb25 cb26 cb27 cb28
foreach k of local sdqvars {
replace z`k' = . if z`k'<=4 | z`k'>=8
replace z`k' = z`k' - 5
}
gen zcb10r = 2 - zcb10
gen zcb14r = 2 - zcb14
gen zcb17r = 2 - zcb17
gen zcb24r = 2 - zcb24
gen zcb28r = 2 - zcb28
egen csdqemot = rowtotal(zcb6 zcb11 zcb16 zcb19 zcb27) if zcb6!=. & zcb11!=. & zcb16!=. & zcb19!=. & zcb27!=.
egen csdqcond = rowtotal(zcb8 zcb10r zcb15 zcb21 zcb25) if zcb8!=. & zcb10r!=. & zcb15!=. & zcb21!=. & zcb25!=.
egen csdqhyper = rowtotal(zcb5 zcb13 zcb18 zcb24r zcb28r) if zcb5!=. & zcb13!=. & zcb18!=. & zcb24r!=. & zcb28r!=.
egen csdqpeer = rowtotal(zcb9 zcb14r zcb17r zcb22 zcb26) if zcb9!=. & zcb14r!=. & zcb17r!=. & zcb22!=. & zcb26!=.
egen csdqprosoc = rowtotal(zcb4 zcb7 zcb12 zcb20 zcb23) if zcb4!=. & zcb7!=. & zcb12!=. & zcb20!=. & zcb23!=.
egen csdqtotal = rowtotal(csdqemot csdqcond csdqhyper csdqpeer) if csdqemot!=. & csdqcond!=. & csdqhyper!=. & csdqpeer!=.
renvars zcb4 zcb5 zcb6 zcb7 zcb8 zcb9 zcb10 zcb11 zcb12 zcb13 zcb14 zcb15 zcb16 zcb17 zcb18 zcb19 zcb20 zcb21 zcb22 zcb23 zcb24 zcb25 zcb26 zcb27 zcb28 zcb10r zcb14r zcb17r zcb24r zcb28r, predrop(1)

*********************************************************************

local outcomes zta1 zta2 zta3 zta4 zta5 zta6 zta7 zta8 zta9 ztb2 ztb3 ztb4 ztb5 ztb6 ztb7 ztb8 ztb9 ztb10 ztb11 ztb12 ztb13 ztb14 ztb15 ztb16 ztb17 ztb18 ztb19 ztb20 ztc1 ztc2 ztc3 ztc4 ztc5 ztc6 ztc7 ztc8 ztc9 ztc10 ztc11 ztc12 ztc13 ztc14 ztc15 ztc16 ztc17 
foreach k of local outcomes {
quietly replace `k' = `k'+1
}
* TEACHER EMOTIONAL SYMPTOMS
egen temotmean = rowmean(zta1 zta2 zta3 zta4 zta5 zta6 zta7 zta8 zta9)
gen temottot = 9*temotmean
* TEACHER HYPERACTIVITY
egen thypermean = rowmean(ztb2 ztb3 ztb4 ztb5 ztb6 ztb7 ztb8 ztb9 ztb10 ztb11 ztb12 ztb13 ztb14 ztb15 ztb16 ztb17 ztb18 ztb19 ztb20)
gen thypertot = 19*thypermean
* TEACHER CONDUCT PROBLEMS
egen tcondmean = rowmean(ztc1 ztc2 ztc3 ztc4 ztc5 ztc6 ztc7 ztc8 ztc9 ztc10 ztc11 ztc12 ztc13 ztc14 ztc15 ztc16 ztc17)
gen tcondtot = 17*tcondmean

*********************************************************************

* LIFE EVENTS
/* Parental PTSD measures
rename ze1 phadevent
replace phadevent = . if phadevent>=8

local events accident attack abuse domvio fattack death
foreach k of local events {
gen p`k' = 0 if phadevent!=.
label var p`k' "Parent reported child PTSD life events"
}
forvalues i=1(1)9 {
replace paccident = 1 if ze2a0`i'==1
replace pattack = 1 if ze2a0`i'==4
replace pabuse = 1 if ze2a0`i'>=5 & ze2a0`i'<=7
replace pdomvio = 1 if ze2a0`i'==8
replace pfattack = 1 if ze2a0`i'==9
replace pdeath = 1 if ze2a0`i'==10
}
* Child PTSD measures
rename zce1 chadevent
replace chadevent = . if chadevent>=8

local events accident attack abuse domvio fattack death
foreach k of local events {
gen c`k' = 0 if chadevent!=.
label var c`k' "Child reported child PTSD life events"
}
forvalues i=1(1)9 {
replace caccident = 1 if zce12a0`i'==1
replace cattack = 1 if zce12a0`i'==4
replace cabuse = 1 if zce12a0`i'>=5 & zce12a0`i'<=7
replace cdomvio = 1 if zce12a0`i'==8
replace cfattack = 1 if zce12a0`i'==9
replace cdeath = 1 if zce12a0`i'==10
}
* Combine parent and child PTSD measures
local events accident attack abuse domvio fattack death
foreach k of local events {
gen `k' = p`k'
replace `k' = 1 if c`k'==1
label var `k' "Parent & child reported PTSD life events"
}
*/
* Parental stressful life event measures - some refer to parent, some refer to child
local events k1 k2 k3 k4 k5 k6 k7 k8 k9 k10 k11
foreach k of local events {
replace z`k' = . if z`k'>=8
replace z`k' = 2 - z`k'
label values z`k' answ
}
rename zk1 pseparat
rename zk2 pfincrisis
rename zk3 ppolice
rename zk8 pphysill
rename zk9 pmentill
rename zk6 cfamdied
rename zk7 cfridied
rename zk4 cillness
rename zk5 cinjury
rename zk10 cfriend
replace cfriend = 0 if zk11==0
replace cfriend = 1 if zk11==1

*********************************************************************

* SCREENING QUESTIONS
gen pemotprob = 0 if zf2!=. | zf13!=. | zf25!=. | ze1!=. | zf28!=. | zg1!=.
replace pemotprob = 1 if zf2==1 | zf13==1 | zf25==1 | ze1==1 | zf28==1 | zg1==1
replace pemotprob = 1 if zf39==1 & zf39a>=6 & zf39a!=.
gen phypprob = 0 if zh1!=.
replace phypprob = 1 if zh1==1
gen pcondprob = 0 if zi1!=.
replace pcondprob = 1 if zi1==3
gen cemotprob = 0 if zc2!=. | zcf13!=. | zcf25!=. | zce1!=. | zcf28!=. | zcf40!=. | zcg1!=. | zcf7a!=.
replace cemotprob = 1 if zc2==1 | zcf13==1 | zcf25==1 | zce1==1 | zcf28==1 | zcf40==1 | zcg1==1 | zcf7a==7
gen ccondprob = 0 if zc3a4a!=. | zc3a4b!=. | zc3a4c!=. | zc3a4d!=. | zc3a4e!=. | zc3a4f!=. | zc3a4g!=.
replace ccondprob = 1 if zc3a4a==3 | zc3a4b==3 | zc3a4c==3 | zc3a4d==3 | zc3a4e==3 | zc3a4f==3 | zc3a4g==3

*********************************************************************

drop z*
compress
save "Basic variables 2004", replace
exit

*********************************************************************

gen hhinc_miss = hhincmid==.
replace hhincmid = 0 if hhinc_miss==1
replace rhhincmid = 0 if hhinc_miss==1
gen married = mstatus==1
gen cohabit = mstatus==2
gen separat = mstatus>=5 & mstatus<=6
gen year2004 = year==2004
gen pfemale = psex==2
gen agesq = age^2
replace tagelevel = 4 if tagelevel<4  // 4 represents "4 or under", so I'm not sure what 1,2,3 represent
gen agegap = tagelevel - age
rename pdaysmiss daysabs
rename houseown hownstatus
replace hownstatus = . if hownstatus>5
gen hownall = hownstatus==1
gen hownmort = hownstatus>=2 & hownstatus<=3
gen hrent = hownstatus==4
gen hfree = hownstatus==5

**********************************************************************

label var year "Sample year"
label var mstatus "Marital status of responding parent"
label var hownstatus "Home owner status"
label var hownall "Own house outright"
label var hownmort "Own house with mortgage"
label var hrent "Pay rent for residence"
label var hfree "Residence is rent free"
label var psex "Sex of responding parent"
label var genhlth "Child general health - parent assessed"
label var incq1 "Household income first quartile (approx)"
label var incq2 "Household income second quartile (approx)"
label var incq3 "Household income third quartile (approx)"
label var incq4 "Household income fourth quartile (approx)"
label var hhinc_miss "Household income missing"
label var married "Responding parent married"
label var cohabit "Responding parent cohabitating"
label var separat "Responding parent separated"
label var year2004 "Child from 2004 survey"
label var agesq "Child's age squared"
label var agegap "teacher-assessed mental age level minus age" 
label var pfemale "Responding parent female"
label var pseparat "Life Event: Parents separated"
label var pfincrisis "Life Event: Major financial crisis"
label var pphysill "Life Event: Parent had serious physical illness"
label var ppolice "Life Event: Problem with police"
label var cfamdied "Life Event: Child had parent or sibling die"
label var cfridied "Life Event: Child had close friend die"
label var cillness "Life Event: Child had serious illness"
label var cinjury "Life Event: Child had serious accident/injury"
label var llord "Landlord if renting"
label var asthma "Child health problem - asthma"
label var eczema "Child health problem - eczema"
label var hayfever "Child health problem - hayfever"
label var psdqemot "Parent assessed SDQ-Emotional"
label var psdqcond "Parent assessed SDQ-Conduct"
label var psdqhyper "Parent assessed SDQ-Hyperactivity"
label var psdqpeer "Parent assessed SDQ-Peer"
label var psdqprosoc "Parent assessed SDQ-Prosocial"
label var psdqtotal "Parent assessed SDQ-Total Difficulties"
label var tsdqemot "Teacher assessed SDQ-Emotional"
label var tsdqcond "Teacher assessed SDQ-Conduct"
label var tsdqhyper "Teacher assessed SDQ-Hyperactivity"
label var tsdqpeer "Teacher assessed SDQ-Peer"
label var tsdqprosoc "Teacher assessed SDQ-Prosocial"
label var tsdqtotal "Teacher assessed SDQ-Total Difficulties"
label var csdqemot "Child assessed SDQ-Emotional"
label var csdqcond "Child assessed SDQ-Conduct"
label var csdqhyper "Child assessed SDQ-Hyperactivity"
label var csdqpeer "Child assessed SDQ-Peer"
label var csdqprosoc "Child assessed SDQ-Prosocial"
label var csdqtotal "Child assessed SDQ-Total Difficulties"
label var pemotprob "Parent assessed emotional problem exists"
label var phypprob "Parent assessed hyperactivity problem exists"
label var pcondprob "Parent assessed conduct problem exists"
label var cemotprob "Child assessed emotional problem exists"
label var ccondprob "Child assessed conduct problem exists"
label var pread "Parent assessed reading ability"
label var pmath "Parent assessed math ability" 
label var pspell "Parent assessed spelling ability"
label var tread "Teacher assessed reading ability"
label var tmath "Teacher assessed math ability" 
label var tspell "Teacher assessed spelling ability"
order year year2004 region age agesq sex male white black asian ethother pwhite pblack pasian pethother genhlth hhsize nadults nchilds housetyp hownstatus hownall hownmort hrent hfree llord psex pfemale mstatus married cohabit separat ghqlikert agelefted employed pemployed degree vocqual alevels olevels loginc ownincmid hhincmid rownincmid rhhincmid incq1 incq2 incq3 incq4 hhinc_miss pseparat pfincrisis pphysill ppolice cfamdied cfridied cillness cinjury asthma eczema hayfever tread tmath tspell pread pmath pspell tagelevel agegap daysabs 

**********************************************************************

drop parentno childno d4-d28 medicine* preaslevel preasage planglevel plangage schoolft exclude nexclude excludetyp gh1-gh12 cb4-cb28  ///
db1-db25 *_ic familybus newspaper shop labourer chores stomach-muscle neversmoke drinkmth inc0to10 inc10to20 inc20to30 inc30to40 inc40plus incmiss incqmiss  ///
rinc0to10-rincmiss illst illlt refused phobia cb10r cb14r cb17r cb24r cb28r temotmean temottot thypermean thypertot tcondmean tcondtot  ///
work pmentill cfriend  smoke everdrink  ///
everweed ageweed twagdays specneeds nchildslt18 consent year agelefted *owninc*  ///
tagelevel ethother hownstatus
drop *peer* *total* *prosoc* icdany icdanxiety pspell tspell
gen temp = genhlth*ghqlikert*employed*pemployed*pseparat*pfincrisis*pphysill*ppolice*cfamdied*cfridied*cillness*cinjury
drop if temp==.
drop temp
replace psdqcond = -999 if psdqcond==.
replace tsdqcond = -999 if tsdqcond==.
replace csdqcond = -999 if csdqcond==.
replace psdqemot = -999 if psdqemot==.
replace tsdqemot = -999 if tsdqemot==.
replace csdqemot = -999 if csdqemot==.
replace psdqhyper = -999 if psdqhyper==.
replace tsdqhyper = -999 if tsdqhyper==.
replace csdqhyper = -999 if csdqhyper==.
gen psdqcmiss = psdqcond==-999
gen tsdqcmiss = tsdqcond==-999
gen csdqcmiss = csdqcond==-999
label var psdqcmiss "Parent SDQ-Conduct score missing"
label var tsdqcmiss "Teacher SDQ-Conduct score missing"
label var csdqcmiss "Child SDQ-Conduct score missing"
gen psdqemiss = psdqemot==-999
gen tsdqemiss = tsdqemot==-999
gen csdqemiss = csdqemot==-999
label var psdqemiss "Parent SDQ-emotional score missing"
label var tsdqemiss "Teacher SDQ-emotional score missing"
label var csdqemiss "Child SDQ-emotional score missing"
gen psdqhmiss = psdqhyper==-999
gen tsdqhmiss = tsdqhyper==-999
gen csdqhmiss = csdqhyper==-999
label var psdqhmiss "Parent SDQ-Hyperactivity score missing"
label var tsdqhmiss "Teacher SDQ-Hyperactivity score missing"
label var csdqhmiss "Child SDQ-Hyperactivity score missing"
replace pcondprob = -999 if pcondprob==.
replace ccondprob = -999 if ccondprob==.
gen pcprobmiss = pcondprob==-999
gen ccprobmiss = ccondprob==-999
label var pcprobmiss "Parent conduct problem assessment missing"
label var ccprobmiss "Child conduct problem assessment missing"
replace pemotprob = -999 if pemotprob==.
replace cemotprob = -999 if cemotprob==.
gen peprobmiss = pemotprob==-999
gen ceprobmiss = cemotprob==-999
label var peprobmiss "Parent emotional problem assessment missing"
label var ceprobmiss "Child emotional problem assessment missing"
replace phypprob = -999 if phypprob==.
gen phprobmiss = phypprob==-999
label var phprobmiss "Parent hyperactivity problem assessment missing"
replace agegap = -999 if agegap==.
gen agegapmiss = agegap==-999
replace daysabs = -999 if daysabs==.
gen daysabsmiss = daysabs==-999
replace tread = -999 if tread==.
gen treadmiss = tread==-999
replace tmath = -999 if tmath==.
gen tmathmiss = tmath==-999
label var agegapmiss "Mental age gap missing"
label var daysabsmiss "Mental age gap missing"
label var treadmiss "Teacher reading assessment missing"
label var tmathmiss "Teacher math assessment missing"
replace pread = -999 if pread==.
replace pmath = -999 if pmath==.
gen pefollowon = 0
replace pefollowon = 1 if pemotprob==1
replace pefollowon = 1 if psdqemot>3 & psdqemot!=.
replace pefollowon = -999 if pemotprob==-999 & psdqemot==-999
label var pefollowon "Parent emotional follow on questions asked"
gen pcfollowon = 0
replace pcfollowon = 1 if pcondprob==1
replace pcfollowon = 1 if psdqcond>=3 & psdqcond!=.
replace pcfollowon = -999 if pcondprob==-999 & psdqcond==-999
label var pcfollowon "Parent conduct follow on questions asked"
gen phfollowon = 0
replace phfollowon = 1 if phypprob==1
replace phfollowon = 1 if psdqhyper>=6 & psdqhyper!=.
replace phfollowon = -999 if phypprob==-999 & psdqhyper==-999
label var phfollowon "Parent hyperactivity follow on questions asked"
gen cefollowon = 0
replace cefollowon = 1 if cemotprob==1
replace cefollowon = 1 if csdqemot>=6 & csdqemot!=.
replace cefollowon = -999 if cemotprob==-999 & csdqemot==-999
label var cefollowon "Child emotional follow on questions asked"
gen ccfollowon = 0
replace ccfollowon = 1 if ccondprob==1
replace ccfollowon = 1 if csdqcond>=4 & csdqcond!=.
replace ccfollowon = -999 if ccondprob==-999 & csdqcond==-999
label var ccfollowon "Child conduct follow on questions asked"
save "child_mhealth.dta", replace

**********************************************************************
