** This does 2 types of simulations
** 1. Creates a sample size N with parameters amd model defined. Simulates R and S
** 2. Uses data and model previouly estimated to simulate data. Simulates R and S. It may use previously estimated model, 
** model stored in memory, saved model 
** 3. Attempt to do simulation conditional on S. (S is observed)

*capture program drop ky_sim
program define ky_sim
syntax, [model(numlist max=1 min=1)  /// this will be for No controls.
		 est_sto(str) est_sav(str)  *      /// this for stored or saved results
		]
	
		 if `model'==1 ky_sim1, `options'	 
	else if `model'==2 ky_sim2, `options'
	else if `model'==3 ky_sim3, `options'
	else if `model'==4 ky_sim4, `options'
	else if `model'==5 ky_sim5, `options'
	else if `model'==6 ky_sim6, `options'
	else if "`est_sto'"!="" {
	        est restore `est_sto'
				 if "`e(method)'"=="1" ky_sim1cv, `options'
			else if "`e(method)'"=="2" ky_sim2cv, `options'
			else if "`e(method)'"=="3" ky_sim3cv, `options'
			else if "`e(method)'"=="4" ky_sim4cv, `options'
			else if "`e(method)'"=="5" ky_sim5cv, `options'
			else if "`e(method)'"=="6" ky_sim6cv, `options'
		 }
	else if "`est_sav'"!="" {
	        est use `est_sva' 
				 if "`e(method)'"=="1" ky_sim1cv, `options'
			else if "`e(method)'"=="2" ky_sim2cv, `options'
			else if "`e(method)'"=="3" ky_sim3cv, `options'
			else if "`e(method)'"=="4" ky_sim4cv, `options'
			else if "`e(method)'"=="5" ky_sim5cv, `options'
			else if "`e(method)'"=="6" ky_sim6cv, `options'	    
		 }	 
	else if "`e(cmd)'"=="ky_estimator" {
				 if "`e(method)'"=="1" ky_sim1cv, `options'
			else if "`e(method)'"=="2" ky_sim2cv, `options'
			else if "`e(method)'"=="3" ky_sim3cv, `options'
			else if "`e(method)'"=="4" ky_sim4cv, `options'
			else if "`e(method)'"=="5" ky_sim5cv, `options'
			else if "`e(method)'"=="6" ky_sim6cv, `options'
	     }
end

/*Survey Data with RTM error*/
/*admin data no problem*/
 
*capture program drop ky_sim1
program define ky_sim1
syntax,  nobs(int)		 /// sample size
		 mean_e(str ) mean_n(str) /// unconditional mean for variable
		 sig_e(str ) sig_n(str ) /// unconditional variances
		 rho_s(str )  /// Level of regression to the mean error
		 pi_s(str )  [*]  // Probability of each type of data being created.
	qui {	 
	** set observations
	clear
	set obs `nobs'
	** generating latent variables
	gen double e_var=`mean_e'+rnormal()*`sig_e'
	gen double n_var=`mean_n'+rnormal()*`sig_n'
	gen byte   pi_si=runiform()<=`pi_s'
	gen double r_var=e_var
	gen double s_var=e_var  if pi_si==1
	   replace s_var=e_var+(`rho_s')*(e_var-`mean_e')+n_var if pi_si==0
	   }
end

/*Survey Data RTM error and Contamination*/
/*admin data no problem*/

*capture program drop ky_sim2
program define ky_sim2
syntax,  nobs(int)		 /// sample size
		 mean_e(str ) mean_n(str) mean_w(str) /// unconditional mean for variable
		 sig_e(str ) sig_n(str ) sig_w(str) /// unconditional variances
		 rho_s(str )  /// Level of regression to the mean error
		 pi_s(str ) pi_w(str ) [*]  // Probability of each type of data being created. last part will be to allow other parameters 
	qui {	 
	** set observations
	clear
	set obs `nobs'
	** generating latent variables
	gen double e_var=`mean_e'+rnormal()*`sig_e'
	gen double n_var=`mean_n'+rnormal()*`sig_n'
	gen double w_var=`mean_w'+rnormal()*`sig_w'
	
	gen byte   pi_si=runiform()<=`pi_s'
	gen byte   pi_wi=runiform()<=`pi_w'
	
	gen double r_var=e_var
	gen double s_var=e_var  if pi_si==1
	   replace s_var=e_var+(`rho_s')*(e_var-`mean_e')+n_var       if pi_si==0 & pi_wi==0
	   replace s_var=e_var+(`rho_s')*(e_var-`mean_e')+n_var+w_var if pi_si==0 & pi_wi==1
	   }
end

/*"Survey with RTM error and Admin data with Mismatch:"*/
*capture program drop ky_sim3
program define ky_sim3
syntax,  nobs(int)		 /// sample size
		 mean_e(str ) mean_n(str) mean_t(str) /// unconditional mean for variable
		 sig_e(str ) sig_n(str ) sig_t(str) /// unconditional variances
		 rho_s(str )  /// Level of regression to the mean error
		 pi_s(str ) pi_r(str ) [*]  // Probability of each type of data being created.
	qui {	 
	** set observations
	clear
	set obs `nobs'
	** generating latent variables
	gen double e_var=`mean_e'+rnormal()*`sig_e'
	gen double n_var=`mean_n'+rnormal()*`sig_n'
	gen double t_var=`mean_t'+rnormal()*`sig_t'
	
	gen byte   pi_si=runiform()<=`pi_s'
	gen byte   pi_ri=runiform()<=`pi_r'
	
	gen double r_var=e_var  if pi_ri==1
	   replace r_var=t_var  if pi_ri==0
	gen double s_var=e_var  if pi_si==1
	   replace s_var=e_var+(`rho_s')*(e_var-`mean_e')+n_var       if pi_si==0 	   
	   }
end

/*Survey with RTM error and contamination and Admin data with Mismatch*/
*capture program drop ky_sim4
program define ky_sim4
syntax,  nobs(int)		 /// sample size
		 mean_e(str ) mean_n(str) mean_t(str) mean_w(str) /// unconditional mean for variable
		 sig_e(str ) sig_n(str ) sig_t(str) sig_w(str) /// unconditional variances
		 rho_s(str )  /// Level of regression to the mean error
		 pi_s(str ) pi_w(str )  pi_r(str ) [*]   // Probability of each type of data being created.
	qui {	 
	** set observations
	clear
	set obs `nobs'
	** generating latent variables
	gen double e_var=`mean_e'+rnormal()*`sig_e'
	gen double n_var=`mean_n'+rnormal()*`sig_n'
	gen double w_var=`mean_w'+rnormal()*`sig_w'
	gen double t_var=`mean_t'+rnormal()*`sig_t'
	
	gen byte   pi_si=runiform()<=`pi_s'
	gen byte   pi_wi=runiform()<=`pi_w'
	gen byte   pi_ri=runiform()<=`pi_r'
	
	gen double r_var=e_var  if pi_ri==1
	   replace r_var=t_var  if pi_ri==0 
	gen double s_var=e_var  if pi_si==1
	   replace s_var=e_var+(`rho_s')*(e_var-`mean_e')+n_var       if pi_si==0 & pi_wi==0
	   replace s_var=e_var+(`rho_s')*(e_var-`mean_e')+n_var+w_var if pi_si==0 & pi_wi==1
	   }
end


/*"Survey with RTM error and contamination and" 
  "Admin data with RTM error and Mismatch" 
*/
*capture program drop ky_sim5
program define ky_sim5
syntax,  nobs(int)		 /// sample size
		 mean_e(str ) mean_n(str) mean_v(str) mean_t(str) mean_w(str) /// unconditional mean for variable
		 sig_e(str )  sig_n(str ) sig_v(str)  sig_t(str)  sig_w(str) /// unconditional variances
		 rho_s(str )  rho_r(str )  /// Level of regression to the mean error
		 pi_s(str ) pi_w(str ) pi_v(str )  pi_r(str ) [*]   // Probability of each type of data being created.
	qui {	 
	** set observations
	clear
	set obs `nobs'
	** generating latent variables
	gen double e_var=`mean_e'+rnormal()*`sig_e'
	gen double n_var=`mean_n'+rnormal()*`sig_n'
	gen double w_var=`mean_w'+rnormal()*`sig_w'
	gen double v_var=`mean_v'+rnormal()*`sig_v'
	gen double t_var=`mean_t'+rnormal()*`sig_t'
	
	gen byte   pi_si=runiform()<=`pi_s'
	gen byte   pi_wi=runiform()<=`pi_w'
	gen byte   pi_vi=runiform()<=`pi_v'
	gen byte   pi_ri=runiform()<=`pi_r'
	
	gen double r_var=e_var                                 if pi_ri==1 & pi_v==1
	   replace r_var=e_var+`rho_r'*(e_var-`mean_e')+v_var  if pi_ri==1 & pi_v==0
	   replace r_var=t_var                                 if pi_ri==0 
	gen double s_var=e_var                                        if pi_si==1
	   replace s_var=e_var+(`rho_s')*(e_var-`mean_e')+n_var       if pi_si==0 & pi_wi==0
	   replace s_var=e_var+(`rho_s')*(e_var-`mean_e')+n_var+w_var if pi_si==0 & pi_wi==1
	   }
end


/*"Survey with RTM error " 
  "Admin data with RTM error and Mismatch" 
*/
*capture program drop ky_sim6
program define  ky_sim6
syntax,  nobs(int)		 /// sample size
		 mean_e(str ) mean_n(str) mean_v(str) mean_t(str) /// unconditional mean for variable
		 sig_e(str )  sig_n(str ) sig_v(str)  sig_t(str)  /// unconditional variances
		 rho_s(str )  rho_r(str )  /// Level of regression to the mean error
		 pi_s(str )  pi_v(str )  pi_r(str ) [*]  // Probability of each type of data being created.
	qui {	 
	** set observations
	clear
	set obs `nobs'
	** generating latent variables
	gen double e_var=`mean_e'+rnormal()*`sig_e'
	gen double n_var=`mean_n'+rnormal()*`sig_n'
	
	gen double v_var=`mean_v'+rnormal()*`sig_v'
	gen double t_var=`mean_t'+rnormal()*`sig_t'
	
	gen byte   pi_si=runiform()<=`pi_s'
	gen byte   pi_vi=runiform()<=`pi_v'
	gen byte   pi_ri=runiform()<=`pi_r'
	
	gen double r_var=e_var                                 if pi_ri==1 & pi_vi==1
	   replace r_var=e_var+`rho_r'*(e_var-`mean_e')+v_var  if pi_ri==1 & pi_vi==0
	   replace r_var=t_var                                 if pi_ri==0 
	gen double s_var=e_var                                 if pi_si==1
	   replace s_var=e_var+`rho_s'*(e_var-`mean_e')+n_var  if pi_si==0 
	   
	   }
end


*capture program drop ky_sim1cv
program define ky_sim1cv
syntax,  [est_sto(str) est_sav(str) prefix(str) ] // Probability of each type of data being created.
	qui {	 
		** set observations
		tempvar mean_e mean_n sig_e sig_n pi_s rho_s
		
		predictnl double `pi_s'  =(invlogit(xb(lpi_s))) 
		predictnl double `mean_e'=(xb(mu_e))		
		predictnl double `mean_n'=(xb(mu_n))
		predictnl double `sig_e' =(exp(xb(ln_sig_e)))		
		predictnl double `sig_n' =(exp(xb(ln_sig_n)))
		predictnl double `rho_s' =(tanh(xb(arho_s)))
		
		** generating latent variables
		gen double `prefix'e_var=`mean_e'+rnormal()*`sig_e'
		gen double `prefix'n_var=`mean_n'+rnormal()*`sig_n'
		gen byte   `prefix'pi_si=runiform()<=`pi_s'
		** R
		gen double `prefix'r_var=`prefix'e_var
		** S
		gen double `prefix's_var=`prefix'e_var 													if `prefix'pi_si==1
	       replace `prefix's_var=`prefix'e_var+(`rho_s')*(`prefix'e_var-`mean_e')+`prefix'n_var if `prefix'pi_si==0
	   }
end


*capture program drop ky_sim2cv
program define ky_sim2cv
syntax,  [est_sto(str) est_sav(str) prefix(str) ] // Probability of each type of data being created.
	qui {	 
		tempvar mean_e mean_n mean_w sig_e sig_n sig_w pi_s pi_w rho_s
		predictnl double `pi_s'  =(invlogit(xb(lpi_s))) 
		predictnl double `pi_w'  =(invlogit(xb(lpi_w))) 
		predictnl double `mean_e'=(xb(mu_e))		
		predictnl double `mean_n'=(xb(mu_n))
		predictnl double `mean_w'=(xb(mu_w))
		predictnl double `sig_e' =(exp(xb(ln_sig_e)))		
		predictnl double `sig_n' =(exp(xb(ln_sig_n)))
		predictnl double `sig_w' =(exp(xb(ln_sig_w)))
		predictnl double `rho_s' =(tanh(xb(arho_s)))
	
	** generating latent variables
		gen double `prefix'e_var=`mean_e'+rnormal()*`sig_e'
		gen double `prefix'n_var=`mean_n'+rnormal()*`sig_n'
		gen double `prefix'w_var=`mean_w'+rnormal()*`sig_w'
		
		gen byte   `prefix'pi_si=runiform()<=`pi_s'
		gen byte   `prefix'pi_wi=runiform()<=`pi_w'
		** R
		gen double `prefix'r_var=`prefix'e_var
		** S
		gen double `prefix's_var=`prefix'e_var  															  if `prefix'pi_si==1
		   replace `prefix's_var=`prefix'e_var+(`rho_s')*(`prefix'e_var-`mean_e')+`prefix'n_var       		  if `prefix'pi_si==0 & `prefix'pi_wi==0
		   replace `prefix's_var=`prefix'e_var+(`rho_s')*(`prefix'e_var-`mean_e')+`prefix'n_var+`prefix'w_var if `prefix'pi_si==0 & `prefix'pi_wi==1
	   }
end

/*"Survey with RTM error and Admin data with Mismatch:"*/
*capture program drop ky_sim3cv
program define ky_sim3cv
syntax,  [est_sto(str) est_sav(str) prefix(str) ] // Probability of each type of data being created.
	qui {	 
	** set observations
		tempvar pi_s pi_r mean_e mean_n mean_t sig_e sig_n sig_t rho_s
		predictnl double `pi_s'  =(invlogit(xb(lpi_s))) 
		predictnl double `pi_r'  =(invlogit(xb(lpi_r))) 
		predictnl double `mean_e'=(xb(mu_e))		
		predictnl double `mean_n'=(xb(mu_n))
		predictnl double `mean_t'=(xb(mu_t))
		predictnl double `sig_e' =(exp(xb(ln_sig_e)))		
		predictnl double `sig_n' =(exp(xb(ln_sig_n)))
		predictnl double `sig_t' =(exp(xb(ln_sig_t)))
		predictnl double `rho_s' =(tanh(xb(arho_s)))
		
	** generating latent variables
		gen double `prefix'e_var=`mean_e'+rnormal()*`sig_e'
		gen double `prefix'n_var=`mean_n'+rnormal()*`sig_n'
		gen double `prefix't_var=`mean_t'+rnormal()*`sig_t'

		gen byte   `prefix'pi_si=runiform()<=`pi_s'
		gen byte   `prefix'pi_ri=runiform()<=`pi_r'

		gen double `prefix'r_var=`prefix'e_var  if `prefix'pi_ri==1
		replace    `prefix'r_var=`prefix't_var  if `prefix'pi_ri==0
		gen double `prefix's_var=`prefix'e_var  if `prefix'pi_si==1
		replace    `prefix's_var=`prefix'e_var+(`rho_s')*(`prefix'e_var-`mean_e')+`prefix'n_var       if `prefix'pi_si==0 	   
	   }
end

/*Survey with RTM error and contamination and Admin data with Mismatch*/
*capture program drop ky_sim4cv
program define ky_sim4cv
syntax,  [est_sto(str) est_sav(str) prefix(str) ] // Probability of each type of data being created.
	qui {	 
	** set observations
		tempvar pi_s   pi_r   pi_w   pi_v   
		tempvar mean_e mean_n mean_t mean_w mean_v 
		tempvar sig_e  sig_n  sig_t  sig_w  sig_v 
		tempvar rho_s  rho_r
		qui {
			predictnl double `pi_s'  =(invlogit(xb(lpi_s))) 
			predictnl double `pi_r'  =(invlogit(xb(lpi_r))) 
			predictnl double `pi_w'  =(invlogit(xb(lpi_w))) 
			predictnl double `mean_e'=(xb(mu_e))		
			predictnl double `mean_n'=(xb(mu_n))
			predictnl double `mean_w'=(xb(mu_w))
			predictnl double `mean_t'=(xb(mu_t))
			predictnl double `sig_e' =(exp(xb(ln_sig_e)))		
			predictnl double `sig_n' =(exp(xb(ln_sig_n)))
			predictnl double `sig_w' =(exp(xb(ln_sig_w)))
			predictnl double `sig_t' =(exp(xb(ln_sig_t)))
			predictnl double `rho_s' =(tanh(xb(arho_s)))
		}
	
	** generating latent variables
	gen double `prefix'e_var=`mean_e'+rnormal()*`sig_e'
	gen double `prefix'n_var=`mean_n'+rnormal()*`sig_n'
	gen double `prefix'w_var=`mean_w'+rnormal()*`sig_w'
	gen double `prefix't_var=`mean_t'+rnormal()*`sig_t'
	
	gen byte   `prefix'pi_si=runiform()<=`pi_s'
	gen byte   `prefix'pi_wi=runiform()<=`pi_w'
	gen byte   `prefix'pi_ri=runiform()<=`pi_r'
	
	gen double `prefix'r_var=`prefix'e_var  if `prefix'pi_ri==1
	   replace `prefix'r_var=`prefix't_var  if `prefix'pi_ri==0 
	gen double `prefix's_var=`prefix'e_var  if `prefix'pi_si==1
	   replace `prefix's_var=`prefix'e_var+(`rho_s')*(`prefix'e_var-`mean_e')+`prefix'n_var               if `prefix'pi_si==0 & `prefix'pi_wi==0
	   replace `prefix's_var=`prefix'e_var+(`rho_s')*(`prefix'e_var-`mean_e')+`prefix'n_var+`prefix'w_var if `prefix'pi_si==0 & `prefix'pi_wi==1
	   }
end


/*"Survey with RTM error and contamination and" 
  "Admin data with RTM error and Mismatch" 
*/
*capture program drop ky_sim5cv
program define ky_sim5cv
syntax,  [est_sto(str) est_sav(str) prefix(str) ] // Probability of each type of data being created.
	qui {	 
		** set observations
		tempvar pi_s   pi_r   pi_w   pi_v   
		tempvar mean_e mean_n mean_t mean_w mean_v 
		tempvar sig_e  sig_n  sig_t  sig_w  sig_v 
		tempvar rho_s  rho_r
		qui {
			predictnl double `pi_s'  =(invlogit(xb(lpi_s))) 
			predictnl double `pi_r'  =(invlogit(xb(lpi_r))) 
			predictnl double `pi_w'  =(invlogit(xb(lpi_w))) 
			predictnl double `pi_v'  =(invlogit(xb(lpi_v))) 
			predictnl double `mean_e'=(xb(mu_e))		
			predictnl double `mean_n'=(xb(mu_n))
			predictnl double `mean_w'=(xb(mu_w))
			predictnl double `mean_t'=(xb(mu_t))
			predictnl double `mean_v'=(xb(mu_v))
			predictnl double `sig_e' =(exp(xb(ln_sig_e)))		
			predictnl double `sig_n' =(exp(xb(ln_sig_n)))
			predictnl double `sig_w' =(exp(xb(ln_sig_w)))
			predictnl double `sig_t' =(exp(xb(ln_sig_t)))
			predictnl double `sig_v' =(exp(xb(ln_sig_v)))
			predictnl double `rho_s' =(tanh(xb(arho_s)))
			predictnl double `rho_r' =(tanh(xb(arho_r)))
		}
		** generating latent variables
		gen double `prefix'e_var=`mean_e'+rnormal()*`sig_e'
		gen double `prefix'n_var=`mean_n'+rnormal()*`sig_n'
		gen double `prefix'w_var=`mean_w'+rnormal()*`sig_w'
		gen double `prefix'v_var=`mean_v'+rnormal()*`sig_v'
		gen double `prefix't_var=`mean_t'+rnormal()*`sig_t'
		
		gen byte  `prefix'pi_si=runiform()<=`pi_s'
		gen byte  `prefix'pi_wi=runiform()<=`pi_w'
		gen byte  `prefix'pi_vi=runiform()<=`pi_v'
		gen byte  `prefix'pi_ri=runiform()<=`pi_r'
		
		gen double `prefix'r_var=`prefix'e_var                                                 				if `prefix'pi_ri==1 & `prefix'pi_v==1
		   replace `prefix'r_var=`prefix'e_var+`rho_r'*(`prefix'e_var-`mean_e')+`prefix'v_var  				if `prefix'pi_ri==1 & `prefix'pi_v==0
		   replace `prefix'r_var=`prefix't_var                                                 				if `prefix'pi_ri==0 
		gen double `prefix's_var=`prefix'e_var                                                 				if `prefix'pi_si==1
		   replace `prefix's_var=`prefix'e_var+`rho_s'*(`prefix'e_var-`mean_e')+`prefix'n_var       		if `prefix'pi_si==0 & `prefix'pi_wi==0
		   replace `prefix's_var=`prefix'e_var+`rho_s'*(`prefix'e_var-`mean_e')+`prefix'n_var+`prefix'w_var if `prefix'pi_si==0 & `prefix'pi_wi==1
		   }
end


/*"Survey with RTM error " 
  "Admin data with RTM error and Mismatch" 
*/
*capture program drop ky_sim6cv
program define ky_sim6cv
syntax,  [est_sto(str) est_sav(str) prefix(str) ] // Probability of each type of data being created.
	qui {	 
		** set observations
		tempvar pi_s   pi_r   pi_w   pi_v   
		tempvar mean_e mean_n mean_t mean_w mean_v 
		tempvar sig_e  sig_n  sig_t  sig_w  sig_v 
		tempvar rho_s  rho_r
		qui {
			predictnl double `pi_s'  =(invlogit(xb(lpi_s))) 
			predictnl double `pi_r'  =(invlogit(xb(lpi_r))) 
			predictnl double `pi_v'  =(invlogit(xb(lpi_v))) 
			predictnl double `mean_e'=(xb(mu_e))		
			predictnl double `mean_n'=(xb(mu_n))
			predictnl double `mean_t'=(xb(mu_t))
			predictnl double `mean_v'=(xb(mu_v))
			predictnl double `sig_e' =(exp(xb(ln_sig_e)))		
			predictnl double `sig_n' =(exp(xb(ln_sig_n)))
			predictnl double `sig_t' =(exp(xb(ln_sig_t)))
			predictnl double `sig_v' =(exp(xb(ln_sig_v)))
			predictnl double `rho_s' =(tanh(xb(arho_s)))
			predictnl double `rho_r' =(tanh(xb(arho_r)))
		}
		** generating latent variables
		gen double `prefix'e_var=`mean_e'+rnormal()*`sig_e'
		gen double `prefix'n_var=`mean_n'+rnormal()*`sig_n'
		gen double `prefix'v_var=`mean_v'+rnormal()*`sig_v'
		gen double `prefix't_var=`mean_t'+rnormal()*`sig_t'
		
		gen byte   `prefix'pi_si=runiform()<=`pi_s'
		gen byte   `prefix'pi_vi=runiform()<=`pi_v'
		gen byte   `prefix'pi_ri=runiform()<=`pi_r'
		
		gen double `prefix'r_var=`prefix'e_var                                                if `prefix'pi_ri==1 & `prefix'pi_v==1
		   replace `prefix'r_var=`prefix'e_var+`rho_r'*(`prefix'e_var-`mean_e')+`prefix'v_var if `prefix'pi_ri==1 & `prefix'pi_v==0
		   replace `prefix'r_var=`prefix't_var                                                if `prefix'pi_ri==0 
		gen double `prefix's_var=`prefix'e_var                                                if `prefix'pi_si==1
		   replace `prefix's_var=`prefix'e_var+`rho_s'*(`prefix'e_var-`mean_e')+`prefix'n_var if `prefix'pi_si==0 
		
		   }
end
