program define jae_table6, rclass

	** This relies on Simulated data. I may add 
quietly {
    
	tempname tab6

	ky_sim, model(4) nobs(100000) ///
	   mean_e($mean_e ) sig_e($sig_e )  ///
	   mean_t($mean_t ) sig_t($sig_t )  ///
	   mean_w($mean_w ) sig_w($sig_w ) ///
	   mean_n($mean_n ) sig_n($sig_n ) ///
	   pi_r($pi_r ) pi_s($pi_s ) pi_w($pi_w ) ///
	   rho_s($rho_s )

	** predicted/corrected income, and two-step classification pc_1-pc_6
    jae_predict_estar
	
	** two-step data classification
	gen two_type = pc_1 + pc_2*2 + pc_3*3 + pc_4*4 + pc_5*5 + pc_6*6
	
	** True data types   [NB pi_Xi are created by ky_sim]
	gen byte true_type = 0
	replace  true_type = 1 if pi_ri == 1 & pi_si == 1
	replace  true_type = 2 if pi_ri == 1 & pi_si == 0 & pi_wi == 0
	replace  true_type = 3 if pi_ri == 1 & pi_si == 0 & pi_wi == 1
	replace  true_type = 4 if pi_ri == 0 & pi_si == 1
	replace  true_type = 5 if pi_ri == 0 & pi_si == 0 & pi_wi == 0
	replace  true_type = 6 if pi_ri == 0 & pi_si == 0 & pi_wi == 1
		
	** Reliability is the squared of correlation
	order  ys1 ys1b ys2 ys3 ys3b ys4 ys2b
	qui: corr e_var r_var s_var ys*
	matrix `tab6'=r(C)
	matrix `tab6'=`tab6'[1,2...]'
	local cln:rownames `tab6'
	mata: st_matrix("`tab6'",st_matrix("`tab6'"):^2)
	matrix rownames `tab6'=`cln'
	matrix colname  `tab6'=rel

	lab var r_var "Register"
	lab var s_var "Survey"
	lab var ys1 "Weighted (unconditional), unbiased"
	lab var ys1b "Weighted (unconditional)"
	lab var ys2 "Weighted (conditional), unbiased"
	lab var ys3 "Two-stage, unbiased"
	lab var ys3b "Two-stage"
	lab var ys4 "System-wide linear"
	lab var ys2b "System-wide"
	
	noi de r_var s_var ys1 ys1b ys2 ys3 ys3b ys4 ys2b
*	noi summ ys1 ys1b ys2 ys3 ys3b ys4 ys2b
	noi tabstat r_var s_var ys1 ys1b ys2 ys3 ys3b ys4 ys2b   ///
		, stats(mean sd var p10 p50 p90) c(stat)
	
	*** for the rest of the table we need Bias and MSE
	**  MSE
	tempvar  r_mse  s_mse  y1mse  y1bmse  y2mse  y3mse  y3bmse  y4mse  y2bmse
	tempvar  r_bias s_bias y1bias y1bbias y2bias y3bias y3bbias y4bias y2bbias
	qui {
		gen double `r_mse' =(r_var-e_var)^2
		gen double `s_mse' =(s_var-e_var)^2
		
		gen double `y1mse' =(ys1-e_var)^2
		gen double `y1bmse'=(ys1b-e_var)^2
		
		gen double `y2mse' =(ys2-e_var)^2
		
		gen double `y3mse' =(ys3-e_var)^2
		gen double `y3bmse'=(ys3b-e_var)^2
		
		gen double `y4mse' =(ys4-e_var)^2
		gen double `y2bmse'=(ys2b-e_var)^2
		
		** bias and variance
		gen double `r_bias' =(r_var-e_var)
		gen double `s_bias' =(s_var-e_var)
		gen double `y1bias' =(ys1-e_var)
		gen double `y1bbias'=(ys1b-e_var)
		gen double `y2bias' =(ys2-e_var)
		gen double `y3bias' =(ys3-e_var)
		gen double `y3bbias'=(ys3b-e_var)
		gen double `y4bias' =(ys4-e_var)
		gen double `y2bbias'=(ys2b-e_var)
		
		tabstat `r_mse'   `s_mse' `y1mse'  `y1bmse'  `y2mse'  `y3mse' `y3bmse' `y4mse' `y2bmse', stats(mean) save
		matrix `tab6'=`tab6',r(StatTotal)'
		tabstat `r_bias' `s_bias' `y1bias' `y1bbias' `y2bias' `y3bias' `y3bbias' `y4bias' `y2bbias', stats(mean) save
		matrix `tab6'=`tab6',r(StatTotal)'
		tabstat `r_bias' `s_bias' `y1bias' `y1bbias' `y2bias' `y3bias' `y3bbias' `y4bias' `y2bbias', stats(var) save
		matrix `tab6'=`tab6',r(StatTotal)'
	}
	
 	matrix colname `tab6'= "Reliability" "MSE" "Bias" "Variance" 
	noi di " "
	noi di "Table 6"

	noi matrix list `tab6'
	return matrix tab6=`tab6'

}
	
end
