program define jae_setup_uk_8

*** This program simply sets up all the moments as globals

	di " "
	di "*****************************************************************"
	di " "
	di "jae_set_up_uk_8"
	display "Based on sdpan32:  abs|r_i - s_i| <  0.025. CL fraction   16.93%"
	di " "
	di "*****************************************************************"
	di " "

/*
------------------------------------------------------------------------------
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        mu_e |    9.81251   .0101453   967.20   0.000     9.792626    9.832395
       sig_e |   .7515119   .0075417    99.65   0.000     .7367305    .7662934
        mu_t |   8.514697   .1139085    74.75   0.000      8.29144    8.737953
       sig_t |   1.252995   .0643311    19.48   0.000     1.126908    1.379082
        mu_w |  -.1573516    .029524    -5.33   0.000    -.2152176   -.0994855
       sig_w |   .7542108   .0286898    26.29   0.000     .6979797    .8104418
        mu_n |  -.0141285   .0030741    -4.60   0.000    -.0201535   -.0081034
       sig_n |   .1496655   .0033546    44.61   0.000     .1430906    .1562405
        pi_r |   .9397913   .0056513   166.30   0.000      .928715    .9508676
        pi_s |    .179336   .0051849    34.59   0.000     .1691738    .1894983
        pi_w |   .2328123   .0130028    17.90   0.000     .2073273    .2582974
       rho_s |  -.0303562   .0043992    -6.90   0.000    -.0389784   -.0217339
------------------------------------------------------------------------------
*/	

	global mean_e   9.81251
	global mean_t   8.514697
	global mean_w   (-.1573516)
	global mean_n   (-.0141285)

	global sig_e   0.7515119
	global sig_t   1.252995
	global sig_w   0.7542108
	global sig_n   0.1496655 

	global pi_r   0.9397913
	global pi_s   0.179336
	global pi_w   0.2328123

	global rho_s   (-0.0303562)
	
	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}
	

	*** Set up constructed parameters
	global mean_r1   ($mean_e)
	global mean_r2   ($mean_t)
	global mean_s1   ($mean_e)
	global mean_s2   ($mean_e+$mean_n)
	global mean_s3   ($mean_e+$mean_n+$mean_w)

	global sig_r1   ($sig_e)
	global sig_r2   ($sig_t)
	global sig_s1   ($sig_e)
	global sig_s2   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1   1
	global rho_r1s2   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1   0
	global rho_r2s2   0
	global rho_r2s3   0
	
end
