program define jae_setup_uk_6

*** This program simply sets up all the moments as globals

	di " "
	di "*****************************************************************"
	di " "
	di "jae_set_up_uk_6"	
	display "Based on sdpan31:  abs|r_i - s_i| <  0.015. CL fraction   11.14%"
	di " "
	di "*****************************************************************"
	di " "
	
/*
------------------------------------------------------------------------------
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        mu_e |   9.811758   .0101539   966.30   0.000     9.791856    9.831659
       sig_e |   .7529641   .0075819    99.31   0.000     .7381039    .7678242
        mu_t |   8.546852   .1092629    78.22   0.000       8.3327    8.761003
       sig_t |   1.266436   .0621296    20.38   0.000     1.144664    1.388208
        mu_w |  -.1435513      .0261    -5.50   0.000    -.1947064   -.0923963
       sig_w |   .7096422   .0267393    26.54   0.000     .6572341    .7620503
        mu_n |   -.011684   .0026756    -4.37   0.000    -.0169282   -.0064399
       sig_n |   .1341592   .0030133    44.52   0.000     .1282532    .1400651
        pi_r |    .938873   .0055857   168.09   0.000     .9279252    .9498207
        pi_s |   .1180562   .0043367    27.22   0.000     .1095565    .1265559
        pi_w |   .2417261   .0124448    19.42   0.000     .2173347    .2661175
       rho_s |  -.0255787   .0038388    -6.66   0.000    -.0331026   -.0180548
------------------------------------------------------------------------------
*/	

	global mean_e   9.811758
	global mean_t   8.546852
	global mean_w   (-.1435513)
	global mean_n   (-.011684)

	global sig_e   0.7529641
	global sig_t   1.266436
	global sig_w   0.7096422
	global sig_n   0.1341592 

	global pi_r   0.938873
	global pi_s   0.1180562
	global pi_w   0.2417261

	global rho_s   (-0.0255787)

	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}
	
	
	*** Set up constructed parameters
	global mean_r1   ($mean_e)
	global mean_r2   ($mean_t)
	global mean_s1   ($mean_e)
	global mean_s2   ($mean_e+$mean_n)
	global mean_s3   ($mean_e+$mean_n+$mean_w)

	global sig_r1   ($sig_e)
	global sig_r2   ($sig_t)
	global sig_s1   ($sig_e)
	global sig_s2   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1   1
	global rho_r1s2   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1   0
	global rho_r2s2   0
	global rho_r2s3   0
	
end
