program define jae_setup_uk_4

*** This program simply setsup all the moments as globals

	di " "
	di "*****************************************************************"
	di " "
	di "jae_set_up_uk_4"	
	display "based on sdpan28: abs|r_i - s_i| <  0.005. CL fraction   3.43%"
	di " "
	di "*****************************************************************"
	di " "	
	
/*	
------------------------------------------------------------------------------
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        mu_e |   9.810494   .0101753   964.14   0.000      9.79055    9.830437
       sig_e |   .7564593   .0077623    97.45   0.000     .7412455    .7716731
        mu_t |   8.621075   .1042328    82.71   0.000     8.416782    8.825367
       sig_t |   1.288084   .0582017    22.13   0.000     1.174011    1.402157
        mu_w |  -.1239255   .0214924    -5.77   0.000    -.1660498   -.0818011
       sig_w |   .6368536   .0279158    22.81   0.000     .5821396    .6915676
        mu_n |  -.0091232   .0022269    -4.10   0.000    -.0134879   -.0047586
       sig_n |   .1142125   .0029145    39.19   0.000     .1085003    .1199248
        pi_r |   .9361519   .0056985   164.28   0.000     .9249831    .9473208
        pi_s |   .0364841   .0025076    14.55   0.000     .0315693    .0413989
        pi_w |   .2605959    .012757    20.43   0.000     .2355926    .2855992
       rho_s |  -.0192438   .0032771    -5.87   0.000    -.0256667   -.0128209
------------------------------------------------------------------------------

*/	
	global mean_e    9.810494
	global mean_t    8.621075
	global mean_w   (-.1239255)
	global mean_n   (-.0091232)

	global sig_e     0.7564593
	global sig_t     1.288084
	global sig_w     0.6368536
	global sig_n     0.1142125 

	global pi_r      0.9361519
	global pi_s      0.0364841
	global pi_w      0.2605959

	global rho_s   (-0.0192438)
	
	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}
	

	*** Set up constructed parameters
	global mean_r1   ($mean_e)
	global mean_r2   ($mean_t)
	global mean_s1   ($mean_e)
	global mean_s2   ($mean_e+$mean_n)
	global mean_s3   ($mean_e+$mean_n+$mean_w)

	global sig_r1   ($sig_e)
	global sig_r2   ($sig_t)
	global sig_s1   ($sig_e)
	global sig_s2   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1   1
	global rho_r1s2   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1   0
	global rho_r2s2   0
	global rho_r2s3   0
	
end
