program define jae_setup_uk_2

*** This program simply sets up all the moments as globals

	di " "
	di "*****************************************************************"
	di " "
	di "jae_set_up_uk_2"	
	display "Based on sdpan25:  abs|r_i - s_i| <  0.001. CL fraction   1.00%"
	di " "
	di "*****************************************************************"
	di " "	
	
/*
------------------------------------------------------------------------------
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        mu_e |   9.809858   .0102014   961.62   0.000     9.789864    9.829853
       sig_e |   .7593594   .0081618    93.04   0.000     .7433625    .7753562
        mu_t |   8.677373   .1073407    80.84   0.000     8.466989    8.887757
       sig_t |   1.296407   .0556571    23.29   0.000     1.187321    1.405493
        mu_w |  -.1161532    .019694    -5.90   0.000    -.1547527   -.0775538
       sig_w |   .5967948   .0352125    16.95   0.000     .5277797      .66581
        mu_n |  -.0080349   .0021077    -3.81   0.000    -.0121659    -.003904
       sig_n |   .1068271   .0032954    32.42   0.000     .1003683    .1132859
        pi_r |   .9334395   .0062354   149.70   0.000     .9212184    .9456605
        pi_s |   .0107059    .001376     7.78   0.000     .0080091    .0134028
        pi_w |   .2728809   .0145009    18.82   0.000     .2444597    .3013021
       rho_s |  -.0168881   .0032266    -5.23   0.000    -.0232122   -.0105639
------------------------------------------------------------------------------

*/	

	global mean_e   9.809858
	global mean_t   8.677373
	global mean_w   (-.1161532)
	global mean_n   (-.0080349)

	global sig_e   0.7593594
	global sig_t   1.296407
	global sig_w   0.5967948
	global sig_n   0.1068271 

	global pi_r   0.9334395
	global pi_s   0.0107059
	global pi_w   0.2728809

	global rho_s   (-0.0168881)
	
	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}
	

	*** Set up constructed parameters
	global mean_r1   ($mean_e)
	global mean_r2   ($mean_t)
	global mean_s1   ($mean_e)
	global mean_s2   ($mean_e+$mean_n)
	global mean_s3   ($mean_e+$mean_n+$mean_w)

	global sig_r1   ($sig_e)
	global sig_r2   ($sig_t)
	global sig_s1   ($sig_e)
	global sig_s2   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1   1
	global rho_r1s2   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1   0
	global rho_r2s2   0
	global rho_r2s3   0
	
end
