program define jae_setup_uk_1

*** This program simply setsup all the moments as globals

	di " "
	di "*****************************************************************"
	di " " 
	di "jae_set_up_uk_1"	
	display "Based on sdpan26:  abs|r_i - s_i| <  0.000. CL fraction   0.25%"
	di " "
	di "*****************************************************************"
	di " "	
	
/*

------------------------------------------------------------------------------
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        mu_e |   9.809497   .0102348   958.45   0.000     9.789437    9.829556
       sig_e |   .7616715   .0091806    82.97   0.000     .7436778    .7796652
        mu_t |   8.718346   .1230161    70.87   0.000     8.477238    8.959453
       sig_t |    1.29895   .0538749    24.11   0.000     1.193357    1.404543
        mu_w |  -.1121961   .0192288    -5.83   0.000    -.1498838   -.0745084
       sig_w |   .5712845   .0511439    11.17   0.000     .4710444    .6715247
        mu_n |  -.0075313   .0021123    -3.57   0.000    -.0116713   -.0033913
       sig_n |    .103565   .0042942    24.12   0.000     .0951485    .1119814
        pi_r |   .9310793   .0076023   122.47   0.000     .9161791    .9459794
        pi_s |   .0026827    .000692     3.88   0.000     .0013264    .0040389
        pi_w |   .2808928   .0186589    15.05   0.000      .244322    .3174637
       rho_s |  -.0156087   .0034097    -4.58   0.000    -.0222917   -.0089258
------------------------------------------------------------------------------

*/	

	global mean_e   9.809497
	global mean_t   8.718346
	global mean_w   (-.1121961)
	global mean_n   (-.0075313)

	global sig_e   0.7616715
	global sig_t   1.29895
	global sig_w   0.5712845
	global sig_n   0.103565 

	global pi_r   0.9310793
	global pi_s   0.0026827
	global pi_w   0.2808928

	global rho_s   (-0.0156087)
	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}


	*** Set up constructed parameters
	global mean_r1   ($mean_e)
	global mean_r2   ($mean_t)
	global mean_s1   ($mean_e)
	global mean_s2   ($mean_e+$mean_n)
	global mean_s3   ($mean_e+$mean_n+$mean_w)

	global sig_r1   ($sig_e)
	global sig_r2   ($sig_t)
	global sig_s1   ($sig_e)
	global sig_s2   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1   1
	global rho_r1s2   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1   0
	global rho_r2s2   0
	global rho_r2s3   0
	
end
