*** Master file for JAE "MRW replication" paper ***

cscript
version 16
capture log close

capture cd "C:\Users\Fernando\Dropbox (Personal)\00 UK Data Papers\kyado\JAE"
capture cd D:\home\stephenj\MYProjects\DWP_SDP\kyado\JAE

log using jae_master.log, replace

cd

capture ssc install estout, replace // to ensure -esttab- works. 
				    // If unwanted, comment out the -esttab- lines

*** Master file for JAE "MRW replication" paper ***

set seed 820811

***************************************
*** Part 1: JAE replication of MRW
***************************************

*** setting up parameters

jae_setup_sw

***  Values of a, b, c for (xi_tilde)_L = a*r + b*s + c [MRW, p. 198]
jae_mrw_p198

*** table 5
jae_table5
matrix table5 = r(tab5)
esttab matrix( table5 , fmt(%6.2f)) using table5_mrw.rtf ///
	, mtitle("") replace

*** Simulating data and table 6
jae_table6
matrix table6 = r(tab6)
esttab matrix( table6 , fmt(%6.2f)) using table6_mrw.rtf  ///
	, mtitle("") replace
	
*** obtaining % correctly predicted data
qui: gen correctly_classified = (two_type == true_type)
qui: lab def correctly_classified 0 "Incorrect" 1 "Correct"
qui: lab val correctly_classified correctly_classified
tab correctly_classified
tab true_type two_type, cell nokey 
tab true_type two_type if two_type != true_type, cell nokey



*** set up figures
jae_fig_setup 5 16

*** Drawing figures
jae_fig2 5 16
graph save fig2_mrw.gph, replace
graph export fig2_mrw.pdf, replace

jae_fig3 5 16
graph save fig3_mrw.gph, replace
graph export fig3_mrw.pdf, replace

***************************************
*** Part 2: JAE replication of UK data 
***
*** for each of 8 completely labelled fraction definitions
***************************************

forval x = 1/8  {
    	
	*** setting up parameters
	jae_setup_uk_`x'
	
	***  Values of a, b, c for (xi_tilde)_L = a*r + b*s + c [MRW, p. 198]
	jae_mrw_p198
	
	*** table 5
	jae_table5
	matrix table5 = r(tab5)
	esttab matrix( table5 , fmt(%6.2f)) using table5_uk_`x'.rtf  ///
		, mtitle("") replace
		
	*** Simulating data and table 6
	jae_table6
	matrix table6 = r(tab6)
	esttab matrix( table6 , fmt(%6.2f)) using table6_uk_`x'.rtf  ///
		, mtitle("")  replace
		 
	*** share correctly classified
	qui: gen correctly_classified = (two_type == true_type)
	qui: lab def correctly_classified 0 "Incorrect" 1 "Correct"
	qui: lab val correctly_classified correctly_classified
	tab correctly_classified
	tab true_type two_type, cell nokey
	tab true_type two_type if two_type != true_type, cell nokey

	*** set up figures
	jae_fig_setup 3 16

	*** Drawing figures (different ado-files to place contour markers differently)
	jae_fig2_uk 3 16
	graph save fig2_uk_`x'.gph, replace
	graph export fig2_uk_`x'.pdf, replace

	if `x' < 7  {
		jae_fig3_uk 3 16
		graph save fig3_uk_`x'.gph, replace
		graph export fig3_uk_`x'.pdf, replace
	}
	else {
	    jae_fig3_uk2 3 16
		graph save fig3_uk_`x'.gph, replace
		graph export fig3_uk_`x'.pdf, replace
	}
}	

* quick look at graphs with most similar Completely Labelled Fractions
*    MRW versus UK case 7
	
graph combine fig2_mrw.gph fig2_uk_7.gph  ///
	, cols(1) graphregion(color(white))	///
	saving(fig2_mrw-uk_7.gph, replace)
	
graph combine fig3_mrw.gph fig3_uk_7.gph  ///
	, cols(1)  graphregion(color(white))  ///
	saving(fig3_mrw-uk_7.gph, replace)

	
	
*************
log close
