function [estmsl,msloutput] = mslNgrad(Y,Xf,Xr,mfo,R,sv,p2p)

N = mfo.N;
T = mfo.T;
J = mfo.J;

rng(10);
dr_sn = randn(size(Xr,2),R*N);

function ll = like(parms)
    
    est = p2p(parms);
    
    vFC = Xf*est.FC;
    
    beta_i = bsxfun(@plus,est.RCmean,est.cholRCvar*dr_sn);

    vRC = zeros([J*T*N R]);
    for n = 1:N
        vRC((n-1)*J*T+1:n*T*J,:) = Xr((n-1)*J*T+1:n*T*J,:)*beta_i(:,(n-1)*R+1:n*R);
    end
    
    v = bsxfun(@plus,vFC,vRC);
    v = reshape(v,[J T*N*R]);    

    expv = exp(v);
    pr = reshape(bsxfun(@rdivide,expv,sum(expv,1)),[J*T*N R]);
    like = reshape(prod(reshape(pr(Y==1,:),[T N R]),1),[N R]);    
        
    ll = sum(log(mean(like,2)),1);  
    
    ll = -ll;

end

o1 = optimoptions(@fminunc,'Display','iter','MaxIter',1e6,'MaxFunEvals',1e6,'Algorithm','Quasi-newton');
tic
[estmsl,fval,exitflag,msloutput] = fminunc(@like, p2p(sv), o1);
msloutput.time = toc;

msloutput.fval = fval;
msloutput.exitflag = exitflag;
estmsl = p2p(estmsl);
   
end



