
% This is the main program which generates simulated data for a mixed logit
% model with fixed and normaly distributed random coefficients
%
% Five methods are used for estimating the parameter from the simulated
% data: 
% (1) MM algorithm
% (2) EM algorithm with quasi-newton inner optimization
% (3) EM algorithm with newton-raphson inner optimization
% (4) MSL with analytical gradients
% (5) MSL with numerical gradients

% Create Data
% Data is generated using the 'datagen.m' function.
% The data generation can be generated with different parameterizations
[Y,Xf,Xr,mfo,parm_true] = datagen('nfx',2,'syyd',1,'N',1000,'T',10,'J',3,'nfxnz',10,'nrx',2,'vfx',1,'vrx',1);
% The columns of Y and X are organized by choice, choice situation,and individual

% Starting values for each estimator are obtained from a standard logit
% The function 'standardlogit.m' estimates the logit parameters
B = standardlogit(Y,[Xf Xr],mfo);

% All of the parameters are put into a structure for portability
% The parameters are the fixed cofficients (FC), the mean of the random
% coefficients (RCmean), and the covaraice of the random coefficients
% (RCvar)
sv = struct('FC',B(1:size(Xf,2)),'RCmean',B(size(Xf,2)+1:end),'RCvar',.1*eye(size(Xr,2))+eps);
sv.cholRCvar = chol(sv.RCvar,'lower');

% 'vecparm.m' is a function that produces a function handle called 'p2p'.
% p2p either vectorizes the structure of parameters if the input is a
% structure, or structurizes the vector of parameters if the input is a
% vector.  
p2p = vecparm(sv);

% number of draws to simulate the integrated likelihood
R = 2000;

% MM algorithm
% Define a function handle called 'MMstep' using the function 'def_MM.m'.
% Then iterate on the function handle 'MMstep' until convergence using the
% iterative program 'em_alg_eps.m'.
MMstep = def_MM(Y,Xf,Xr,mfo,R);
[estMM,outputMM] = em_alg_eps(MMstep,sv,p2p,'printIter',10);

% EM algorithm quasi-newton inner optimization
EMstep = def_EMqn(Y,Xf,Xr,mfo,R);
[estEMqn,outputEMqn] = em_alg_eps(EMstep,sv,p2p,'printIter',10);

% EM algorithm newton-raphson inner optimization
EMstep = def_EMnr(Y,Xf,Xr,mfo,R);
[estEMnr,outputEMnr] = em_alg_eps(EMstep,sv,p2p,'printIter',10);

% MSL analytical gradients
[estMSLa,outputMSLa] = mslAgrad(Y,Xf,Xr,mfo,R,sv,p2p);

% MSL numerical gradients
[estMSLn,outputMSLn] = mslNgrad(Y,Xf,Xr,mfo,R,sv,p2p);
