function [est,output] = em_alg_eps(EMstep,sv,p2p,varargin)

% Using the structure of starting values, 'sv'.  This program iterates on
% the EMstep until the paraemters converge. Convergence is detected using 
% the vector epsilon algorithm in Kuroda and Sakakihara (2006)
%
% The required inputs are
%  EMstep - the parameter step
%  sv - starting values in structure form
%  p2p - a function that vectorizes the structure of parameters

regularEM = (nargout(EMstep)==3);

EMopt = struct('maxIter',1e6,'TolX',1e-6,'printIter',1);
while ~isempty(varargin)
    switch varargin{1}
        case {'maxIter','TolX','printIter'}
            EMopt.(varargin{1}) = varargin{2};
            varargin(1:2) = [];
        otherwise
            error(['Unexpected option: ' varargin{1}])
    end
end

epnorm = @(x) x./(x'*x);
epval = @(x,y,z) y + epnorm(epnorm(z-y) + epnorm(x-y));

abch = @(x) x(:,1)-x(:,2);
rech = @(x) (abs(x(:,2))<=.01).*(x(:,1)-x(:,2)) + (abs(x(:,2))>.01).*((x(:,1)-x(:,2))./(x(:,2)+eps));

est = sv;
oll = -inf;
op = p2p(est)*ones(1,3);
ep = op(:,1:2);
numinner = 0;

tic
for m = 1:EMopt.maxIter
   
    if regularEM
    [est,ll,tnumit] = EMstep(est); numinner = numinner+tnumit;
    else
    [est,ll] = EMstep(est);
    end
    
    op = [p2p(est) op(:,1:end-1)];
    ep = [epval(op(:,1),op(:,2),op(:,3)) ep(:,1:end-1)];
    
    if (m==1) || ( round(m/EMopt.printIter)==(m/EMopt.printIter)) || (norm(abch(op),inf)<EMopt.TolX)
        fprintf('%d \t',m);
        fprintf('%8.10f \t',ll);
        fprintf('%8.10f \t',(ll-oll));
        fprintf('%8.10f \t',norm(abch(op),inf));
        fprintf('%8.10f \t',norm(abch(ep),inf));
        fprintf('%8.0f \n',toc);
    end
        
    if (norm(abch(op),inf)<EMopt.TolX), break; end
  
    if (norm(abch(ep),inf)<EMopt.TolX)       
        est = p2p(ep(:,1));
    end
 
    oll = ll;

end

if regularEM
output = struct('iterations',m,'time',toc,'loglikelihood',ll,'numinner',numinner);
else
output = struct('iterations',m,'time',toc,'loglikelihood',ll);
end

end



