function EMstep = def_MM(Y,Xf,Xr,mfo,R)

% This function defines the MM algorithm contraction mapping
% 
% It defines a function handle 'EMstep' that takes as input 'est' (a
% structure of parameter estimates) and returns an updated 'est'

N = mfo.N;
T = mfo.T;
J = mfo.J;

% set the random number generator seed and draw values from a standard
% normal
rng(10);
dr_sn = randn(size(Xr,2),R*N);

% create inverse lower boung matrix for updating the fixed coefficients
iLB_FC = lowerbound_inverse(Xf,J); 

EMstep = @calc;

function [est,ll] = calc(est)
    
    vFC = Xf*est.FC;
    
    beta_i = bsxfun(@plus,est.RCmean,est.cholRCvar*dr_sn);

    vRC = zeros([J*T*N R]);
    for n = 1:N
        vRC((n-1)*J*T+1:n*T*J,:) = Xr((n-1)*J*T+1:n*T*J,:)*beta_i(:,(n-1)*R+1:n*R);
    end
    
    v = bsxfun(@plus,vFC,vRC);
    v = reshape(v,[J T*N*R]);    

    expv = exp(v);
    pr = reshape(bsxfun(@rdivide,expv,sum(expv,1)),[J*T*N R]);
    like = reshape(prod(reshape(pr(Y==1,:),[T N R]),1),[N R]);    
        
    ll = sum(log(mean(like,2)),1);    
    
    qi = bsxfun(@rdivide,like,sum(like,2));
    
    if ~isempty(est.FC)
        Epr = sum(bsxfun(@times,reshape(pr,[J*T N R]),reshape(qi,[1 N R])),3);
        g = Xf'*(Y - Epr(:));     
        est.FC = est.FC - iLB_FC*g;
    end
        
    qi = qi';
    wt_beta =bsxfun(@times,qi(:)',beta_i);  
    est.RCmean = sum(wt_beta,2)./N;
    est.RCvar = (wt_beta*beta_i')./N - est.RCmean*est.RCmean';
    est.cholRCvar = chol(est.RCvar,'lower');
    
end
   
end

