# generates plots of Figure 2

require(rpart)
require(MASS)

source("rrp.dist.R")

# uncomment to test multi normal distribution
set.seed(123)
theta <- runif(200)*2*pi
r <- runif(200)*.8
x1 <- cos(theta)*r*1.3
y1 <- sin(theta)*r*.6

theta <- runif(200)*2*pi
r <- runif(200)*.8
x2 <- 0.5+cos(theta)*r*.5
y2 <- sin(theta)*r*1.4

dati1 <- data.frame(X1 = c(x1, x2), X2 = c(y1, y2)) 
nt <- length(x1)
nc <- length(x2)
n <- nc+nt
tsubjects <- 1:nt
csubjects <- (nt+1):n
treated1 <- logical(n)
treated1[tsubjects] <- TRUE

maxY <- max(dati1[tsubjects,2])
minY <- min(dati1[tsubjects,2])
which( (dati1[csubjects,2] <= maxY) & (dati1[csubjects,2] >= minY) ) -> idxc
minX <- min(dati1[csubjects[idxc],1])
maxX <- max(dati1[csubjects[idxc],1])

which((dati1[tsubjects,1] <= maxX) & (dati1[tsubjects,1] >= minX))-> idxt
cat(paste("number of treated units in the common support:",length(idxt),"\n"))

pdf("fig_data1.pdf")
par(mar=c(5,4,1,1))
plot(dati1,col=treated1+2,pch=ifelse(treated1,18,17),xlim=c(-1.5,2.0),ylim=c(-1.5,1.5))
rect(minX, minY, maxX, maxY, lty=3)
dev.off()

set.seed(123)
D1 <- rrp.dist(dati1,treated1, msplit=10,Rep=250, cut.in=15, check.bal=T, plot=F)

# we discretize a bit the matrix to make it printable
P1 <- 1-D1
P1[which(P1>0)] <- 1
p1 <- as.matrix(P1)
p1 <- p1[tsubjects,]

n.t.m <- sum(apply(p1[, csubjects],1, function(x) length(which(x>0))))
cat(paste("Number of treated matched with controls:",n.t.m,"\n"))

pdf("fig_prox1.pdf")
par(mar=c(2,2,1,1))
image(t(p1),col=c("white","black"),axes=F)
axis(1, c(0.25,.75), c("treated","controls"))
axis(2, 0.5, "treated")
abline(v=0.5,lwd=1,col="gray")
box()
dev.off()

set.seed(123)
theta <- runif(200)*2*pi
r <- runif(200)*.8
x1 <- cos(theta)*r*1.3
y1 <- sin(theta)*r*.6

theta <- runif(200)*2*pi
r <- runif(200)*.8
x2 <- 1.5+cos(theta)*r*.5
y2 <- sin(theta)*r*1.4

dati2 <- data.frame(X1 = c(x1, x2), X2 = c(y1, y2)) 
nt <- length(x1)
nc <- length(x2)
n <- nc+nt
tsubjects <- 1:nt
csubjects <- (nt+1):n
treated2 <- logical(n)
treated2[tsubjects] <- TRUE

pdf("fig_data2.pdf")
par(mar=c(5,4,1,1))
plot(dati2,col=treated2+2,pch=ifelse(treated2,18,17),xlim=c(-1.5,2.0),ylim=c(-1.5,1.5))
dev.off()
 
set.seed(123)
D2 <- rrp.dist(dati2,treated2, msplit=10,Rep=250, cut.in=15, check.bal=T, plot=F)

P2 <- 1-D2
P2[which(P2>0)] <- 1
p2 <- as.matrix(P2)
p2 <- p2[tsubjects,]

pdf("fig_prox2.pdf")
par(mar=c(2,2,1,1))
image(t(p2),col=c("white","black"),axes=F)
axis(1, c(0.25,.75), c("treated","controls"))
axis(2, 0.5, "treated")
abline(v=0.5,lwd=1,col="gray")
box()
dev.off()



lambda <- seq(0,1,length=20)

P1 <- 1-D1
p1 <- as.matrix(P1)
px1 <- p1[tsubjects,csubjects]

nl <- length(lambda)
xxx1 <- numeric(nl)
for(l in 1:nl)
	xxx1[l] <- sum(apply(px1,1,function(x) (length(which(x>=lambda[l]))>0))) 

pdf("fig_lambda1.pdf")
par(mar=c(5,4,1,1))
plot(lambda,xxx1/nt,type="l",xlab=expression(lambda), ylab=expression(S(lambda)),ylim=c(0,1))
dev.off()

P2 <- 1-D2
p2 <- as.matrix(P2)
px2 <- p2[tsubjects,csubjects]
nl <- length(lambda)
xxx2 <- numeric(nl)
for(l in 1:nl)
	xxx2[l] <- sum(apply(px2,1,function(x) (length(which(x>=lambda[l]))>0))) 


pdf("fig_lambda2.pdf")
par(mar=c(5,4,1,1))
plot(lambda,xxx2/nt,type="l",xlab=expression(lambda), ylab=expression(S(lambda)),ylim=c(0,1))
dev.off()

save(file="fig2.rda")



