# generates plots of Figure 1

require(rpart)
require(MASS)
require(rrp)
source("rrp.dist.R")

# uncomment to test multi normal distribution
set.seed(123)
x <- matrix(rnorm(2*2),2,2)
Sigma <- x %*% t(x)
dati <- mvrnorm(n=100, rep(1,2), Sigma)
dati <- rbind(dati, mvrnorm(n=100, rep(3.1,2), Sigma))
dati <- as.data.frame(dati)
tsubjects <- 1:100
csubjects <- 101:200

nt <- length(tsubjects)
nc <- length(csubjects)
n <- nt+nc
treated <- logical(n)
treated[tsubjects] <- TRUE

# we move treated first and controls last for efficiency reasons
dati <- dati[c(tsubjects,csubjects),]
treated <- treated[c(tsubjects,csubjects)]

tsubjects.orig <- tsubjects
csubjects.orig <- csubjects
tsubjects <- 1:nt
csubjects <- (nt+1):n

 
set.seed(123)


pdf("fig.rrp.pdf")
par(mar=c(0,0,0,0))
set.seed(123)
D1 <- rrp.dist(dati,treated, msplit=8,Rep=2, cut.in=15, check.bal=F, plot=T)
set.seed(123)
D2 <- rrp.dist(dati,treated, msplit=8,Rep=2, cut.in=15, check.bal=T, plot=T)
dev.off()

#px <- as.matrix(D1)[tsubjects,csubjects]
#lambda <- seq(0,1,length=10)
#nl <- length(lambda)
#xxx <- numeric(nl)
#for(l in 1:nl)
#	xxx[l] <- sum(apply(px,1,function(x) (length(which(x<=lambda[l]))>0))) 
#plot(lambda,xxx/nt,type="l")

  cat("\n")

