# optimal match estimator
# See Rosenbaum 2002, Sec. 10.4

opt.match <- function(DM, treated, ocome, pred.ocome, data){
	require(optmatch)
	treat <- which(treated==1)
	ctrl <- which(treated==0)

	tmp.MAT <- as.matrix(DM)[treat, ctrl]
	dimnames(tmp.MAT) <- list(treat, ctrl)
	if(missing(pred.ocome))
		pred.ocome <- numeric(length(treated))
	if(missing(ocome))
		ocome <- numeric(length(treated))

	fm <- fullmatch(tmp.MAT)
   
	pr <- logical(length(fm))
	pr[match(dimnames(tmp.MAT)[[1]], names(fm))] <- TRUE

	strata.lab <- levels(fm)
	n.strata <- length( strata.lab )
	Delta <- 0
	tmp.ATT <- rep(NA, n.strata)
	tmp.ATT.adj <- rep(NA, n.strata)
	alpha <- sum(matched(fm) & pr)
	beta <- sum(matched(fm) & !pr)

	if(!missing(data))
	    dt <- matrix(as.numeric(NA), n.strata, dim(data)[2])
    delta <- NA
	n <- length(c(treat,ctrl))
	for(strata in 1:n.strata){ 
		idx.t.opt <- which(matched(fm) & pr & fm==strata.lab[strata])
		idx.c.opt <- which(matched(fm) & !pr & fm==strata.lab[strata])
		m.t.opt <- length(idx.t.opt)
		m.c.opt <- length(idx.c.opt)
		if( min(m.t.opt, m.c.opt) >= 1 ){
			idx.t.opt <- which(matched(fm) & pr & fm==strata.lab[strata])
			idx.c.opt <- which(matched(fm) & !pr & fm==strata.lab[strata])
			tmp.delta <- 0
			for(id.opt in idx.t.opt){
				idx.opt <- as.numeric(sapply(idx.c.opt, function(x) n*(id.opt-1) - id.opt*(id.opt-1)/2  - id.opt +x))
				tmp.delta <- tmp.delta + mean(DM[idx.opt])
			}
			Delta <- Delta + (m.t.opt+m.c.opt)/(alpha+beta)*tmp.delta/m.t.opt
			tmp.ATT[strata] <- m.t.opt*(mean(ocome[idx.t.opt])-mean(ocome[idx.c.opt]))/alpha
			if(!missing(data))
				dt[strata,] <- as.numeric(unlist(apply(data[idx.t.opt,], 2, function(x) mean(x, na.rm=T))) - unlist(apply(data[idx.c.opt,], 2, function(x) mean(x, na.rm=T))))
			tmp.ATT.adj[strata] <- m.t.opt*(mean(ocome[idx.t.opt]-pred.ocome[idx.t.opt])-mean(ocome[idx.c.opt]-pred.ocome[idx.c.opt]))/alpha
		}
   }
   ATT <- sum(tmp.ATT,na.rm=T)
   ATT.ADJ <- sum(tmp.ATT.adj,na.rm=T)
   if(!missing(data))
		delta <- apply(dt, 2, function(x) mean(x,na.rm=T))
   return( list(Delta, ATT, ATT.ADJ, alpha, beta, delta) ) 
 }

