# Nearest Neighbor estimator with replacement
# ATT NN1/4/16


nn.att <- function(DM, treated, ocome, pred.ocome, data){
	treat <- which(treated==1)
	ctrl <- which(treated==0)
	nn.idx <- vector(length(treat), mode="list") 
	kkk <- 0
	nt <- length(treat)
	
	DM <- as.matrix(DM)

	if(missing(pred.ocome))
		pred.ocome <- numeric(length(treated))

	if(missing(ocome))
		ocome <- numeric(length(treated))

	for(i in treat){
		kkk <- kkk+1
		nn.idx[[kkk]] <- order(DM[i,ctrl])
	}

	cf <- as.numeric(lapply(nn.idx, function(x) mean(ocome[ctrl[x[1]]],na.rm=T)))
	att.nn1 <- mean(ocome[treat] - cf)
	cf.adj <- as.numeric(lapply(nn.idx, function(x) mean(pred.ocome[ctrl[x[1]]],na.rm=T)))
	att.nn1.adj <- mean((ocome[treat] - pred.ocome[treat])- (cf-cf.adj))

	cf <- as.numeric(lapply(nn.idx, function(x) mean(ocome[ctrl[x[1:4]]],na.rm=T)))
	att.nn4 <- mean(ocome[treat] - cf)
	cf.adj <- as.numeric(lapply(nn.idx, function(x) mean(pred.ocome[ctrl[x[1:4]]],na.rm=T)))
	att.nn4.adj <- mean((ocome[treat] - pred.ocome[treat])- (cf-cf.adj))

	cf <- as.numeric(lapply(nn.idx, function(x) mean(ocome[ctrl[x[1:16]]],na.rm=T)))
	att.nn16 <- mean(ocome[treat] - cf)
	cf.adj <- as.numeric(lapply(nn.idx, function(x) mean(pred.ocome[ctrl[x[1:16]]],na.rm=T)))
	att.nn16.adj <- mean((ocome[treat] - pred.ocome[treat])- (cf-cf.adj))

	delta1 <- NA
	delta4 <- NA
	delta16 <- NA
    if(!missing(data)){
		n <- dim(data)[2]
	    dt1 <- matrix(as.numeric(NA), nt, n)
	    dt4 <- matrix(as.numeric(NA), nt, n)
	    dt16 <- matrix(as.numeric(NA), nt, n)
        for(i in 1:nt){
			dt1[i,] <- as.numeric(data[treat[i],] - unlist(apply(data[nn.idx[[i]][1],], 2, function(x) mean(x, na.rm=T))))		
			dt4[i,] <- as.numeric(data[treat[i],] - unlist(apply(data[nn.idx[[i]][1:4],], 2, function(x) mean(x, na.rm=T))))		
			dt16[i,] <- as.numeric(data[treat[i],] - unlist(apply(data[nn.idx[[i]][1:16],], 2, function(x) mean(x, na.rm=T))))		
		}
		delta1 <- apply(dt1, 2, function(x) mean(x,na.rm=T))
		delta4 <- apply(dt4, 2, function(x) mean(x,na.rm=T))
		delta16 <- apply(dt16, 2, function(x) mean(x,na.rm=T))
	}

	return(list(att.nn1, att.nn4, att.nn16, att.nn1.adj, att.nn4.adj, att.nn16.adj, delta1, delta4, delta16))
}
