# This function is adapted from dist.quant in package ade4
# Original ade4 code by Daniel Chessel chessel@biomserv.univ-lyon1.fr
# This version is more efficient then one base on base R mahalanobis function

mahala.dist <- function(X, tol=1e-07){
    df <- data.frame(X)
    if (!inherits(df, "data.frame")) 
        stop("df is not a data.frame")

    n <- nrow(df)
    d <- matrix(0, n, n)
    d.names <- row.names(df)
    fun1 <- function(x) {
        sqrt(sum((df[x[1], ] - df[x[2], ])^2))
    }
    df <- as.matrix(df)
    index <- cbind(col(d)[col(d) < row(d)], row(d)[col(d) < row(d)])
	dfcov <- cov(df)
	maha <- eigen(dfcov, sym = TRUE)
	maha.r <- sum(maha$values > (maha$values[1] * tol))
	maha.e <- 1/sqrt(maha$values[1:maha.r])
	maha.v <- maha$vectors[, 1:maha.r]
	maha.v <- t(t(maha.v) * maha.e)
	df <- df %*% maha.v
	d <- unlist(apply(index, 1, fun1))

    attr(d, "Size") <- n
    attr(d, "Labels") <- d.names
    attr(d, "Diag") <- FALSE
    attr(d, "Upper") <- FALSE
    attr(d, "method") <- "mahalanobis"
	attr(d, "call") <- match.call()
    class(d) <- "dist"
    return(d)
}
