require(threshtvp)

# Note: this script is set up to be run on a SGE parallel environment
# If it is not, the system variable "SGE_TASK_ID" will probably not
# be set and the script will run locally for a few examples only
# (including the ones featured in the paper)

runorig <- as.integer(Sys.getenv("SGE_TASK_ID"))
if (is.na(runorig)) run <- 61 else run <- runorig
set.seed(1)

source("simulate_data.R")
save <- 5000L
burn <- 2500L
reduction <- 10L # this times fewer draws for Gerlach, Carter & Kohn (2000)
dosims <- 5
T <- n <- 500

threshfactors <- c(0,2,3)
#thrsh.lows <- c(.2, .1, .05, .01) # currently implemented as a multiple of upper state sd
thrsh.lows <- c(.1) # currently implemented as a multiple of upper state sd

Bselect <- 1
Blist <- list(one = c(3, 0.03), two = c(1.5, 1), three = c(0.001, 0.001))

#Priors
B_1 <- Blist[[Bselect]][1] #Prior on precision in state EQ (Gamma(B_1,B_2))
B_2 <- Blist[[Bselect]][2] 

a1 <- 0.1 #Prior on initial state (NG prior )
b1 <- 0.01 #Hyperparms for the gamma prior on the other hyperparm of the NG prior
b2 <- 0.01

c_1 <- .01 #Prior on the precision in the obs EQ (Gamma(c_1,c_2))
c_2 <- .01 

thrsh.high <- 1.5

kappa0 <- -0.01 # positive number: absolute value; negative number: multiple of OLS std.error

for (thrsh.low in thrsh.lows) {
cat("Going for thresh.low", thrsh.low, "\n")

for (threshfactor in threshfactors) {
cat("Going for threshfactor", threshfactor, "\n")

#Parameters for the simulation
sigbetaposs <- sigetaposs <- c(0.001, 0.01, 0.025, 0.05, 0.085, 0.1, 0.15, 0.3, 0.5, 1, 2)
nposs <- length(sigbetaposs) # = 11
sig_beta <- sigbetaposs[(run - 1) %% nposs + 1]
sig_eta <- sigetaposs[ceiling((run - .1) / nposs)]
threshold <- threshfactor*sig_beta

allrmsegck <- allrmsethresh <- allrmsenothresh <- rep(NA_real_, dosims) 
allmedadgck <- allmedadthresh <- allmedadnothresh <- rep(NA_real_, dosims) 
allmeanadgck <- allmeanadthresh <- allmeanadnothresh <- rep(NA_real_, dosims) 
allscoregck <- allscorethresh <- allscorenothresh <- rep(NA_real_, dosims) 

foldername <- paste0("simres/", thrsh.low, "-", thrsh.high, "/threshfactor", threshfactor, "priors", B_1, B_2, c_1, c_2, kappa0, "/sigb", sig_beta, "/sige", sig_eta, "/")
dir.create(foldername, showWarnings = FALSE, recursive = TRUE)

quantiles <- c(.01, .99)

for (doit in seq_len(dosims)) {
 cat("Run", doit, "of", dosims, "\n")
 set.seed(doit)
 if (threshold < 0) {
  Y1 <- sim_tvp(sig_beta = sig_beta, sig_eta = sig_eta, T=n)
 } else {
  Y1 <- sim_piecewise(sig_beta = sig_beta,sig_eta = sig_eta,T=n,d_true=threshold)
 }
 model_1 <- estimate_tvp(Y1$Y,matrix(Y1$X),save=save,burn=burn,priorbtheta = list(B_1=B_1,B_2=B_2,kappa0=kappa0),priorb0 = list(a_tau=a1,c_tau=b1,d_tau=b2),priorsig = c(c_1, c_2),grid.length=150,thrsh.pct = thrsh.low, thrsh.pct.high = thrsh.high,sv_on=FALSE,thin = 1,TVS=TRUE)
 model_2 <- estimate_tvp(Y1$Y,matrix(Y1$X),save=save,burn=burn,priorbtheta = list(B_1=B_1,B_2=B_2,kappa0=kappa0),priorb0 = list(a_tau=a1,c_tau=b1,d_tau=b2),priorsig = c(c_1, c_2),sv_on=FALSE,thin = 1,TVS=FALSE)
 model_3 <- MCMC_mix(as.matrix(Y1$Y) ,matrix(Y1$X), nburn = burn/reduction, nsave=save/reduction, nr=1, thin=1)

 A_threshold <- apply(model_1$posterior$A,c(2,3),mean)
 A_gck <- apply(model_3$A,c(2,3),mean)
 A_sd <- apply(model_1$posterior$A,c(2,3),sd)
 A_gcksd <- apply(model_3$A,c(2,3),sd)
 A_nonthreshold <- apply(model_2$posterior$A,c(2,3),mean)
 A_nonsd <- apply(model_2$posterior$A,c(2,3),sd)
 
 ALPHA_median <- apply(model_2$posterior$A,c(2,3),median)
 ALPHA_low <- apply(model_2$posterior$A,c(2,3),quantile,quantiles[1])
 ALPHA_high <- apply(model_2$posterior$A,c(2,3),quantile,quantiles[2])

 ALPHA_mean <- apply(model_2$posterior$A,c(2,3),mean)
 ALPHA_sd <- apply(model_2$posterior$A,c(2,3),sd)

 A_low <- apply(model_1$posterior$A,c(2,3),quantile,quantiles[1])
 A_high <- apply(model_1$posterior$A,c(2,3),quantile,quantiles[2])
 A_median <- apply(model_1$posterior$A,c(2,3),median)
 A_post <- apply(model_1$posterior$A,c(2,3),median)
 A_sd  <- apply(model_1$posterior$A,c(2,3),sd)

 Mix_median <- apply(model_3$A,c(2,3),median)
 Mix_low <- apply(model_3$A,c(2,3),quantile,quantiles[1])
 Mix_high <- apply(model_3$A,c(2,3),quantile,quantiles[2])
 Mix_mean <- apply(model_3$A,c(2,3),mean)

 D_post <- apply(model_1$posterior$D_dyn,c(2,3),mean)
 D_post_mix <- apply(model_3$D_dyn,c(2,3),mean)

 allscorethresh[doit] <- sum(dnorm(Y1$beta, A_threshold, A_sd, log = TRUE))
 allscorenothresh[doit] <- sum(dnorm(Y1$beta, A_nonthreshold, A_nonsd, log = TRUE))
 allscoregck[doit] <- sum(dnorm(Y1$beta, A_gck, A_gcksd, log = TRUE))
 
 allrmsethresh[doit] <- rmsethresh <- sqrt(mean((A_threshold-Y1$beta)^2)) 
 allrmsenothresh[doit] <- rmsenothresh <- sqrt(mean((A_nonthreshold-Y1$beta)^2))
 allrmsegck[doit] <- rmsegck <- sqrt(mean((A_gck-Y1$beta)^2))
 
 allmedadthresh[doit] <- medadthresh <- median(abs(A_threshold-Y1$beta)) 
 allmedadnothresh[doit] <- medadnothresh <- median(abs(A_nonthreshold-Y1$beta))
 allmedadgck[doit] <- medadgck <- median(abs(A_gck-Y1$beta))
 
 allmeanadthresh[doit] <- meanadthresh <- mean(abs(A_threshold-Y1$beta)) 
 allmeanadnothresh[doit] <- meanadnothresh <- mean(abs(A_nonthreshold-Y1$beta))
 allmeanadgck[doit] <- meanadgck <- mean(abs(A_gck-Y1$beta))
 
 relrmse <- rmsethresh/rmsenothresh
 relmedad <- medadthresh/medadnothresh
 relmeanad <- meanadthresh/meanadnothresh
 
 relrmsegck <- rmsegck/rmsenothresh
 relmedadgck <- medadgck/medadnothresh
 relmeanadgck <- meanadgck/meanadnothresh
 
pdf(paste0(foldername, doit, ".pdf"), width = 9, height = 6)
 par(mar = c(1.7,1.7,1.7,.5), mgp = c(1.6, .6, 0))
# par(mfrow = c(2,1))
 if (FALSE) {
 plot(Y1$beta, col="forestgreen", type = "l", ylim = range(Y1$beta, A_nonthreshold, A_threshold, A_gck),
      xlab = '', ylab = '', lwd = 1.5)
 lines(A_nonthreshold, col = "darkgray", lwd = 1.5)
 lines(A_threshold, col = "red", lwd = 1.5)
 lines(A_gck, col = "blue", lwd = 1.5)
# mtext(paste0("TTVP: relRMSE ", round(relrmse, 3),
#	     "  relMeanAD ", round(relmeanad, 3), 
#	     "  relMedAD ", round(relmedad, 3),
#             "        GCK: relRMSE ", round(relrmsegck, 3),
#	     "  relMeanAD ", round(relmeanadgck, 3), 
#	     "  relMedAD ", round(relmedadgck, 3)), line = .5)
 title("DGP and posterior means over time")
 }
 nr <- 1
 T <- n
 matplot(#main=bquote('Demeaned posterior distribution of' ~beta[.(nr)]),
	 cbind(A_low[,nr],A_high[,nr],ALPHA_low[,nr],ALPHA_high[,nr],Mix_low[,nr],Mix_high[,nr],Y1$beta),
	 col=c("red","red","blue","blue","black","orange","orange"),
	 lty=c(0,0,0,0), type="l", ylab="")
  polygon(c(1:T,rev(1:T)),c(ALPHA_low[,nr],rev(ALPHA_high[,nr])),col=rgb(0,0,0,.25),border=NA)
  polygon(c(1:T,rev(1:T)),c(A_low[,nr],rev(A_high[,nr])),col=rgb(1,0,0,.3),border=NA)
  polygon(c(1:T,rev(1:T)),c(Mix_low[,nr],rev(Mix_high[,nr])),col=rgb(0,0,1,.2),border=NA)
  title(paste0("DGP and ", quantiles[1], "/", quantiles[2], " posterior quantiles"))
  lines(Y1$beta, col = "forestgreen", lwd = 2)

 matplot(#main=bquote('Demeaned posterior distribution of' ~beta[.(nr)]),
	 cbind(tmp1 <- A_low[,nr]-A_median[,nr],
	       tmp2 <- A_high[,nr]-A_median[,nr],
	       tmp3 <- ALPHA_low[,nr]-ALPHA_median[,nr],
	       tmp4 <- ALPHA_high[,nr]-ALPHA_median[,nr],
	       tmp5 <- Mix_low[,nr]-Mix_median[,nr],
	       tmp6 <- Mix_high[,nr]-Mix_median[,nr]),
	 lty=c(0,0,0,0), type="l", ylab="")
  polygon(c(1:T, rev(1:T)), c(tmp3, rev(tmp4)), col=rgb(0,0,0,.25), border=NA)
  polygon(c(1:T, rev(1:T)), c(tmp1 ,rev(tmp2)), col=rgb(1,0,0,.3), border=NA)
  polygon(c(1:T, rev(1:T)), c(tmp5, rev(tmp6)), col=rgb(0,0,1,.2), border=NA)
  title(paste0(quantiles[1], "/", quantiles[2], " posterior quantiles minus median"))
  #abline(h = 0, col = "forestgreen")

dev.off()
 
 if (doit %% 10 == 1) {
  pdf(paste0(foldername, doit, "_diag.pdf"), width = 16, height = 10)
  par(mfrow=c(4,2), mar = c(1.5,3,.5,.5), mgp = c(1.6, .6, 0))
  ts.plot(as.numeric(model_1$posterior$omega)[seq(1, save, by = 10)])
  ts.plot(as.numeric(model_2$posterior$omega)[seq(1, save, by = 10)])
  ts.plot(as.numeric(model_1$posterior$sigma2)[seq(1, save, by = 10)])
  ts.plot(as.numeric(model_2$posterior$sigma2)[seq(1, save, by = 10)])
  ts.plot(as.numeric(model_1$posterior$thresholds)[seq(1, save, by = 10)])
  ts.plot(as.numeric(model_2$posterior$thresholds)[seq(1, save, by = 10)])
  ts.plot(as.numeric(model_1$posterior$A[,1,])[seq(1, save, by = 10)])
  ts.plot(as.numeric(model_2$posterior$A[,1,])[seq(1, save, by = 10)])
  dev.off()
 }
 save(allscorethresh, allscorenothresh, allscoregck, allrmsethresh, allrmsenothresh, allrmsegck, allmedadthresh, allmedadnothresh, allmedadgck, allmeanadthresh, allmeanadnothresh, allmeanadgck, file = paste0(foldername, "errormeasures.RData"))
}
}
}
