%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Derive Bounds on The effect of four pop in Ps Sample selection%%%%%%%%%%%%%%%%%%%
function psbounddc(y,z,t,B,k,des,alfa,R,seed)
%B= # bootsrap replications
%k=(# of values of pi01)-1  (see line 18)
%% uncomment this for the outputs
%function bounds=psboundn(y,z,t,B,k)
%function [D10lb D10ub D11lb D11ub D00lb  D00ub Dt1lb  Dt1ub Dlb Dub D10lbm,D10ubm,D11lbm,D11ubm,D00lbm,D00ubm,Dt1lbm,Dt1ubm,Dlbm,Dubm D10lbs,D10ubs,D11lbs,D11ubs,D00lbs,D00ubs,Dt1lbs,Dt1ubs,Dlbs,Dubs D10lbms    D10ubms    D11lbms    D11ubms  D00lbms D00ubms Dt1lbms Dt1ubms  Dlbms  Dubms]=psboundn(y,z,t,B,k)

%% Define sample probabilities and observed outcomes
%seed=110282;
rng(seed);
fprintf('%16.0f    \n',seed)

n=size(y,1);

P11=sum(z==1&t==1)/sum(z==1);
P10=sum(z==0&t==1)/sum(z==0);
P01=1-P11;
P00=1-P10;




y11=sort(y(z==1&t==1));
y01=sort(y(z==0&t==1));
y10=sort(y(z==1&t==0));
y00=sort(y(z==0&t==0));




Ylb=min(y);
Yub=max(y);
pi01m=max(0,P10-P11);
pi01M=min(P10,P01);
pi01=(pi01m:(pi01M-pi01m)/k:pi01M)'; 



D10lb=zeros(size(pi01));
D10ub=D10lb;
D11lb=D10lb;
D11ub=D10ub;
D00lb=D10lb;
D00ub=D10ub;
Dt1lb=D10lb;
Dt1ub=D10ub;
Dlb=D10lb;
Dub=D10ub;

C10lb=zeros(size(pi01));
C10ub=C10lb;
C11lb=C10lb;
C11ub=C10ub;
C00lb=C10lb;
C00ub=C10ub;
Ct1lb=C10lb;
Ct1ub=C10ub;
Clb=C10lb;
Cub=C10ub;

D10lbs=zeros(size(pi01));
D10ubs=D10lbs;
D11lbs=D10lbs;
D11ubs=D10ubs;
D00lbs=D10lbs;
D00ubs=D10ubs;
Dt1lbs=D10lbs;
Dt1ubs=D10ubs;
Dlbs=D10lbs;
Dubs=D10ubs;

C10lbs=zeros(size(pi01));
C10ubs=C10lbs;
C11lbs=C10lbs;
C11ubs=C10ubs;
C00lbs=C10lbs;
C00ubs=C10ubs;
Ct1lbs=C10lbs;
Ct1ubs=C10ubs;
Clbs=C10lbs;
Cubs=C10ubs;
for i=1:k+1
[D10min, D10max, D11min, D11max, D00min, D00max, Dt1min, Dt1max,  Dmin, Dmax, D10mins, D10maxs, D11mins, D11maxs, D00mins, D00maxs, Dt1mins, Dt1maxs, Dmins, Dmaxs]=bootbounddc(y,z,t,des,pi01(i));
[C10min, C10max, C11min, C11max, C00min, C00max, Ct1min, Ct1max, Cmin, Cmax, C10mins, C10maxs, C11mins, C11maxs, C00mins, C00maxs, Ct1mins, Ct1maxs, Cmins, Cmaxs]=bootpsnbindc(y,z,t,B,des,pi01(i));
[D10lb(i), D10ub(i), C10lb(i), C10ub(i)]     = Conf_Int_CLR_old(D10min  , C10min , D10max  ,C10max  , n,R, alfa);
[D11lb(i), D11ub(i), C11lb(i), C11ub(i)]     = Conf_Int_CLR_old(D11min  , C11min , D11max  ,C11max  , n,R, alfa);
[D00lb(i), D00ub(i), C00lb(i), C00ub(i)]     = Conf_Int_CLR_old(D00min  , C00min , D00max  ,C00max  , n,R, alfa);
[Dt1lb(i), Dt1ub(i), Ct1lb(i), Ct1ub(i)]     = Conf_Int_CLR_old(Dt1min  , Ct1min , Dt1max  ,Ct1max  , n,R, alfa);
[Dlb(i), Dub(i), Clb(i), Cub(i)]             = Conf_Int_CLR_old(Dmin    , Cmin   , Dmax    ,Cmax    , n,R, alfa);
[D10lbs(i), D10ubs(i), C10lbs(i), C10ubs(i)] = Conf_Int_CLR_old(D10mins , C10mins, D10maxs ,C10maxs , n,R, alfa);
[D11lbs(i), D11ubs(i), C11lbs(i), C11ubs(i)] = Conf_Int_CLR_old(D11mins , C11mins, D11maxs ,C11maxs, n,R, alfa);
[D00lbs(i), D00ubs(i), C00lbs(i), C00ubs(i)] = Conf_Int_CLR_old(D00mins , C00mins, D00maxs ,C00maxs, n,R, alfa);
[Dt1lbs(i), Dt1ubs(i), Ct1lbs(i), Ct1ubs(i)] = Conf_Int_CLR_old(Dt1mins , Ct1mins, Dt1maxs ,Ct1maxs, n,R, alfa);
[Dlbs(i), Dubs(i), Clbs(i), Cubs(i)]         = Conf_Int_CLR_old(Dmins   , Cmins  , Dmaxs   ,Cmaxs, n,R, alfa);
end


D10lb=min(D10lb);
D10ub=max(D10ub);
% D11lb=min(D11lb);
% D11ub=max(D11ub);
% D00lb=min(D00lb);
% D00ub=max(D00ub);
Dt1lb=min(Dt1lb);
Dt1ub=max(Dt1ub);
Dlb=min(Dlb);
Dub=max(Dub);


C10lb=min(C10lb);
C10ub=max(C10ub);
% C11lb=min(C11lb);
% C11ub=max(C11ub);
% C00lb=min(C00lb);
% C00ub=max(C00ub);
Ct1lb=min(Ct1lb);
Ct1ub=max(Ct1ub);
Clb=min(Clb);
Cub=max(Cub);







D10lbs=min(D10lbs);
D10ubs=max(D10ubs);
D11lbs=min(D11lbs);
D11ubs=max(D11ubs);
D00lbs=min(D00lbs);
D00ubs=max(D00ubs);
Dt1lbs=min(Dt1lbs);
Dt1ubs=max(Dt1ubs);
Dlbs=min(Dlbs);
Dubs=max(Dubs);


C10lbs=min(C10lbs);
C10ubs=max(C10ubs);
C11lbs=min(C11lbs);
C11ubs=max(C11ubs);
C00lbs=min(C00lbs);
C00ubs=max(C00ubs);
Ct1lbs=min(Ct1lbs);
Ct1ubs=max(Ct1ubs);
Clbs=min(Clbs);
Cubs=max(Cubs);

%% Monotonicity
%upper and lower bound of delta10
D10ubm=1/(P11-P10)*((P11*mean(y11)-P10*mean(y01))-(P00*mean(y00)-P01*mean(y10)));
D10lbm=D10ubm;

%upper and lower bound of delta11
D11ubm=mean(y01)-Ylb;
D11lbm=mean(y01)-Yub;

%upper and lower bound of delta00
D00ubm=max(y)-mean(y10);
D00lbm=min(y)-mean(y10);

%upper and lower bound of deltaT=1

Dt1ubm=1/mean(t)*(P10*D11ubm+(P11-P10)*mean(z)*D10ubm);
Dt1lbm=1/mean(t)*(P10*D11lbm+(P11-P10)*mean(z)*D10lbm);

% Dt0ubm=1/mean(1-t)*(P01*D00ubm+(P11-P10)*mean(1-z)*D10ubm);
% Dt0lbm=1/mean(1-t)*(P01*D00lbm+(P11-P10)*mean(1-z)*D10lbm);
%upper and lower bound of delta

Dubm=P10*D11ubm+(P11-P10)*D10ubm+P01*D00ubm;
Dlbm=P10*D11lbm+(P11-P10)*D10lbm+P01*D00lbm;

%% Monotonicity and Stochastic dominance

D10ubms=D10ubm;
D10lbms=D10ubm;

%upper and lower bound of delta11
D11ubms=mean(y01)-Ylb;
D11lbms=mean(y01)-(P00*mean(y00)-P01*mean(y10))/(P11-P10);

%upper and lower bound of delta00
D00ubms=(P11*mean(y11)-P10*mean(y01))/(P11-P10)-mean(y10);
D00lbms=min(y)-mean(y10);

%upper and lower bound of deltaT=1

Dt1ubms=1/mean(t)*(P10*D11ubms+(P11-P10)*mean(z)*D10ubms);
Dt1lbms=1/mean(t)*(P10*D11lbms+(P11-P10)*mean(z)*D10lbms);

% Dt0ubms=1/mean(1-t)*(P01*D00ubms+(P11-P10)*mean(1-z)*D10ubms);
% Dt0lbms=1/mean(1-t)*(P01*D00lbms+(P11-P10)*mean(1-z)*D10lbms);
%upper and lower bound of delta

Dubms=P10*D11ubms+(P11-P10)*D10ubms+P01*D00ubms;
Dlbms=P10*D11lbms+(P11-P10)*D10lbms+P01*D00lbms;






 Se=bootnew(y,z,t,B);
% signwc=[0 0  -norminv(alfa)*Se(1) norminv(alfa)*Se(2)  -norminv(alfa)*Se(3) norminv(alfa)*Se(4) 0 0    0 0];
% %signs=[0 0  0 norminv(alfa)*Se(17)  -norminv(alfa)*Se(18) 0 0 0  0 0  0 0];
 sign=[-1 1  -1 1  -1 1 -1 1   -1 1];


bounds=[D10lb,D10ub,D11lb(end),D11ub(end),D00lb(end),D00ub(end),Dt1lb,Dt1ub,Dlb,Dub;
    [C10lb,C10ub,C11lb(end),C11ub(end),C00lb(end),C00ub(end), Ct1lb, Ct1ub,Clb,Cub];
    D10lbs,D10ubs,D11lbs,D11ubs,D00lbs,D00ubs,Dt1lbs,Dt1ubs,Dlbs,Dubs;
    [C10lbs,C10ubs,C11lbs,C11ubs,C00lbs,C00ubs,Ct1lbs,Ct1ubs,Clbs,Cubs];
    D10lbm,D10ubm,D11lbm,D11ubm,D00lbm,D00ubm,Dt1lbm,Dt1ubm,Dlbm,Dubm;
    [D10lbm,D10ubm,D11lbm,D11ubm,D00lbm,D00ubm,Dt1lbm,Dt1ubm,Dlbm,Dubm]-[norminv(alfa/2) norminv(alfa/2)  norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa)].*sign.*Se(1:10)';
    D10lbms,D10ubms,D11lbms,D11ubms,D00lbms,D00ubms,Dt1lbms,Dt1ubms,Dlbms,Dubms;
    [D10lbms,D10ubms,D11lbms,D11ubms,D00lbms,D00ubms,Dt1lbms,Dt1ubms,Dlbms,Dubms]-[norminv(alfa/2) norminv(alfa/2)  norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa) norminv(alfa)].*sign.*Se(11:20)'];




labels=[
    'Assumptions 1 and 2 only '
    '                         '
    'Mean domominance         '
    '                         '
    'Monotonicity             '
    '                         '
    'Both                     '
    '                         '
    ];



for j=1:2:size(bounds, 1)-1%j=5

    fprintf(labels(j,:))
    fprintf('& [%1.3f, %2.3f] & [%1.3f, %2.3f] & [%1.3f, %2.3f] & [%1.3f, %2.3f]   & [%1.3f, %2.3f] \\\\   \n', bounds(j,:))
    fprintf(labels(j+1,:))
    fprintf('& (%1.3f, %2.3f) & (%1.3f, %2.3f) & (%1.3f, %2.3f) & (%1.3f, %2.3f)   & (%1.3f, %2.3f)  \\\\   \n', bounds(j+1,:))

end




