%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Derive Bounds on The effect of four pop in Ps Sample selection%%%%%%%%%%%%%%%%%%% 
function bounds =bootboundnbin(y,z,t) 
%k= control for the number of values of pi01 considered for delta10s (see line 20)


%% Define sample probabilities and observed outcomes

P11=sum(z==1&t==1)/sum(z==1);
P10=sum(z==0&t==1)/sum(z==0);
P01=1-P11;
P00=1-P10;

ym=min(y);
yM=max(y);


y11=sort(y(z==1&t==1));
y01=sort(y(z==0&t==1));
y10=sort(y(z==1&t==0));
y00=sort(y(z==0&t==0)); 





%% Monotonicity
%upper and lower bound of delta10
D10ubm=1/(P11-P10)*((P11*mean(y11)-P10*mean(y01))-(P00*mean(y00)-P01*mean(y10)));
D10lbm=D10ubm;

%upper and lower bound of delta11
D11ubm=mean(y01)-ym;
D11lbm=mean(y01)-yM;

%upper and lower bound of delta00
D00ubm=yM-mean(y10);
D00lbm=ym-mean(y10);

%upper and lower bound of deltaT=1

Dt1ubm=1/mean(t)*(P10*D11ubm+(P11-P10)*mean(z)*D10ubm);
Dt1lbm=1/mean(t)*(P10*D11lbm+(P11-P10)*mean(z)*D10lbm);

% Dt0ubm=1/mean(1-t)*(P01*D00ubm+(P11-P10)*mean(1-z)*D10ubm);
% Dt0lbm=1/mean(1-t)*(P01*D00lbm+(P11-P10)*mean(1-z)*D10lbm);
%upper and lower bound of delta

Dubm=P10*D11ubm+(P11-P10)*D10ubm+P01*D00ubm;
Dlbm=P10*D11lbm+(P11-P10)*D10lbm+P01*D00lbm;










%% Monotonicity and Stochastic dominance

D10ubms=D10ubm;
D10lbms=D10ubm;

%upper and lower bound of delta11
D11ubms=mean(y01)-ym;
D11lbms=mean(y01)-(P00*mean(y00)-P01*mean(y10))/(P11-P10);

%upper and lower bound of delta00
D00ubms=(P11*mean(y11)-P10*mean(y01))/(P11-P10)-mean(y10);
D00lbms=ym-mean(y10);

%upper and lower bound of deltaT=1

Dt1ubms=1/mean(t)*(P10*D11ubms+(P11-P10)*mean(z)*D10ubms);
Dt1lbms=1/mean(t)*(P10*D11lbms+(P11-P10)*mean(z)*D10lbms);

% Dt0ubms=1/mean(1-t)*(P01*D00ubms+(P11-P10)*mean(1-z)*D10ubms);
% Dt0lbms=1/mean(1-t)*(P01*D00lbms+(P11-P10)*mean(1-z)*D10lbms);
%upper and lower bound of delta

Dubms=P10*D11ubms+(P11-P10)*D10ubms+P01*D00ubms;
Dlbms=P10*D11lbms+(P11-P10)*D10lbms+P01*D00lbms;






%%

%maxmin=[delta10min delta10max Dt1min Dt1max Dt0min Dt0max Dmin Dmax delta10mins delta10maxs D11mins D00maxs Dt1mins Dt1maxs Dt0mins Dt0maxs Dmins Dmaxs];


bounds=[
    D10lbm
    D10ubm
    D11lbm
    D11ubm
    D00lbm
    D00ubm
    Dt1lbm
    Dt1ubm
    Dlbm
    Dubm
    D10lbms
    D10ubms
    D11lbms
    D11ubms
    D00lbms
    D00ubms
    Dt1lbms
    Dt1ubms
    Dlbms
    Dubms];
