function [lowerBound] = findlowerboundfordefiers(leftPoint,rightPoint,tolerance,probDistribution,supportOfOutcomeY,assumption4)

%finds lower bound for the share of defiers, note that leftPoint<rightPoint
%INPUT:  leftPoint - lower starting point, (usually max(0,P10-P11))
%        rightPoint - upper starting point, (usually min(P10,P01))
%        tolerance - tolerance, (standard 10e-6)
%        probDistribution - probability distribution of (outcome,treatment,instrument)
%        supportOfOutcomeY
%        assumption4 - optional argument, is equal to 1 if assumption 4
%        holds (mean dominance).
%OUTPUT: lowerBound - lowest admissible share of defiers

if nargin<6
    assumption4 = 0;
end
    
if isintheidentifiedset(probDistribution,leftPoint,supportOfOutcomeY,assumption4)
    lowerBound = leftPoint;
else
    while rightPoint-leftPoint > tolerance
        newPoint = leftPoint + (rightPoint-leftPoint)/2;
        if isintheidentifiedset(probDistribution,newPoint,supportOfOutcomeY,assumption4)
            rightPoint = newPoint;
        else
            leftPoint = newPoint;
        end
    end
    lowerBound = leftPoint + (rightPoint-leftPoint)/2;
end