function displayresults(Result)
%This function displays the results stored in a structure called Result


disp(sprintf(['\n\nBounds on ATE for various subpopulations (not bias corrected)\n']))
disp(sprintf(['No of observations ', num2str(size(Result.dataset,1)),'\n']))

disp(sprintf(['Outer bounds for the share of defiers [', num2str(Result.outerBoundsForDefiers(1)),...
    ' , ',num2str(Result.outerBoundsForDefiers(2)),']']))

disp(sprintf(['Sharp bounds for the share of defiers [', num2str(Result.sharpBoundsForDefiers(1)),...
    ' , ',num2str(Result.sharpBoundsForDefiers(2)),']']))

BoundsLP = Result.BoundsLP;
BoundsAnalytic = Result.BoundsAnalytic;

disp(sprintf(['\n Compliers \t \t \n']))
disp(sprintf(['Bounds LinProg  \t [',num2str(BoundsLP.Compliers.lowerBound),' , ',num2str(BoundsLP.Compliers.upperBound),']']))
disp(sprintf(['Bounds Analytic \t [',num2str(BoundsAnalytic.Compliers.lowerBound),' , ',num2str(BoundsAnalytic.Compliers.upperBound),']']))

disp(sprintf(['\n Alwaystakers \t \t \n']))
disp(sprintf(['Bounds LinProg  \t [',num2str(BoundsLP.Alwaystakers.lowerBound),' , ',num2str(BoundsLP.Alwaystakers.upperBound),']']))
disp(sprintf(['Bounds Analytic \t [',num2str(BoundsAnalytic.Alwaystakers.lowerBound),' , ',num2str(BoundsAnalytic.Alwaystakers.upperBound),']']))

disp(sprintf(['\n Nevertakers \t \t \n']))
disp(sprintf(['Bounds LinProg  \t [',num2str(BoundsLP.Nevertakers.lowerBound),' , ',num2str(BoundsLP.Nevertakers.upperBound),']']))
disp(sprintf(['Bounds Analytic \t [',num2str(BoundsAnalytic.Nevertakers.lowerBound),' , ',num2str(BoundsAnalytic.Nevertakers.upperBound),']']))

disp(sprintf(['\n TreatedPopulation \t \t \n']))
disp(sprintf(['Bounds LinProg  \t [',num2str(BoundsLP.TreatedPopulation.lowerBound),' , ',num2str(BoundsLP.TreatedPopulation.upperBound),']']))
disp(sprintf(['Bounds Analytic \t [',num2str(BoundsAnalytic.TreatedPopulation.lowerBound),' , ',num2str(BoundsAnalytic.TreatedPopulation.upperBound),']']))

disp(sprintf(['\n EntirePopulation \t \t \n']))
disp(sprintf(['Bounds LinProg  \t [',num2str(BoundsLP.EntirePopulation.lowerBound),' , ',num2str(BoundsLP.EntirePopulation.upperBound),']']))
disp(sprintf(['Bounds Analytic \t [',num2str(BoundsAnalytic.EntirePopulation.lowerBound),' , ',num2str(BoundsAnalytic.EntirePopulation.upperBound),']']))

disp(sprintf(['\n Maximal difference between LinProg and Analytical bounds \t']))
disp(sprintf(['is  \t ',num2str(Result.maximalDifference)]))