function [Bounds] = calculateboundsonateusinglp(probDistribution,sizeGrid,supportOfOutcomeY,lowerBoundForDefiers,upperBoundForDefiers,assumption4)

%This function calculates bounds on ATE given a proportion of defiers fixed
%using linear programming tool.
%share of defiers
%INPUT:  probDistribution - probability distribution of (outcome,treatment,instrument)
%        pi01 - proportion of defiers
%        supportOfOutcomeY - row vector
%        assumption4 - optional argument, is equal to 1 if assumption 4
%        holds (mean dominance).
%OUTPUT: Bounds - structure with bounds on ATE for various subpopulations

%Support of the variables. This is important to realize but not necessary
%for the code.
%supportOfTreatmentD  = [1 0];             %Treatment.
%supportOfInstrumentZ = [1 0];             %Instrument.
%supportOfTypeT       = [11 10 01 00];     %Type {always taker,complier,defier,never taker}.

if nargin<6
    assumption4 = 0;
end

%Size of the support of variables.
sizeOfSupportOfY = size(supportOfOutcomeY,2);  %Outcome.
sizeOfSupportOfD = 2;                          %Treatment.
sizeOfSupportOfZ = 2;                          %Instrument.
sizeOfSupportOfT = 4;                          %Type.

%Create a grid of values for the share of defiers pi01
pi01=(lowerBoundForDefiers:(upperBoundForDefiers-lowerBoundForDefiers)/sizeGrid:upperBoundForDefiers)'; 

%Probability of observed variables (Y,D,Z) is probDistribution.
PDZ = sum(probDistribution); %Probability of (D,Z).
PZ  = sum(PDZ);         %Probability of Z.
P11 = PDZ(1,1,1)/PZ(1); %Probability of D=1 given Z=1.
P10 = PDZ(1,1,2)/PZ(2); %Probability of D=1 given Z=0.
P01 = PDZ(1,2,1)/PZ(1); %Probability of D=0 given Z=1.
P00 = PDZ(1,2,2)/PZ(2); %Probability of D=0 given Z=0.

%we will search in the space of joint prob distributions of (Y(1),Y(0))
%given T and Z. these prob distributions are denoted as Phi
sizeOfSupportOfYYTZ = sizeOfSupportOfY*sizeOfSupportOfY*sizeOfSupportOfT*sizeOfSupportOfZ;

%We prealocate variables.
lowerBoundOnAteForEntirePopulation = zeros(1,sizeGrid+1);
upperBoundOnAteForEntirePopulation = zeros(1,sizeGrid+1);
lowerBoundOnAteForAlwaystakers = zeros(1,sizeGrid+1);
upperBoundOnAteForAlwaystakers = zeros(1,sizeGrid+1);
lowerBoundOnAteForCompliers = zeros(1,sizeGrid+1);
upperBoundOnAteForCompliers = zeros(1,sizeGrid+1);
lowerBoundOnAteForNevertakers = zeros(1,sizeGrid+1);
upperBoundOnAteForNevertakers = zeros(1,sizeGrid+1);
lowerBoundOnAteForTreatedPopulation = zeros(1,sizeGrid+1);
upperBoundOnAteForTreatedPopulation = zeros(1,sizeGrid+1);

solutionToMinAteForEntirePopulation = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMaxAteForEntirePopulation = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMinAteForAlwaystakers = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMaxAteForAlwaystakers = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMinAteForCompliers = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMaxAteForCompliers = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMinAteForNevertakers = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMaxAteForNevertakers = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMinAteForTreatedPopulation = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);
solutionToMaxAteForTreatedPopulation = zeros(sizeOfSupportOfYYTZ,sizeGrid+1);

for iPi01=1:size(pi01,1)
    
    %________________________________________________________________________
    %Phi satisfies assumption A2i (sizeOfSupportOfT*sizeOfSupportOfD equalities)
    %matrixAssumptionA2i
    matrixAssumptionA2i = zeros(sizeOfSupportOfT*sizeOfSupportOfD,sizeOfSupportOfYYTZ);
    vectorAssumptionA2i = zeros(sizeOfSupportOfT*sizeOfSupportOfD,1);

    for t = 1:sizeOfSupportOfT
        %equation (8)
        matrixHelp                    = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        for y1 = 1:sizeOfSupportOfY
            for y0 = 1:sizeOfSupportOfY
                matrixHelp(y1,y0,t,1) = supportOfOutcomeY(y1);
                matrixHelp(y1,y0,t,2) = -supportOfOutcomeY(y1);
            end
        end
        matrixAssumptionA2i(t,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

        %equation (9)
        matrixHelp                    = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        for y1 = 1:sizeOfSupportOfY
            for y0 = 1:sizeOfSupportOfY
                matrixHelp(y1,y0,t,1) = supportOfOutcomeY(y0);
                matrixHelp(y1,y0,t,2) = -supportOfOutcomeY(y0);
            end
        end
        matrixAssumptionA2i(t+sizeOfSupportOfT,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);
    end

    %________________________________________________________________________
    %Phi is compatible with the Data and with the assumption A2ii
    %matrixDataAssumptionA2ii
    matrixDataAssumptionA2ii = zeros(sizeOfSupportOfY*sizeOfSupportOfD*sizeOfSupportOfZ,sizeOfSupportOfYYTZ);
    vectorDataAssumptionA2ii = zeros(sizeOfSupportOfY*sizeOfSupportOfD*sizeOfSupportOfZ,1);

    for y = 1:sizeOfSupportOfY
        %equation (10)
        matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        matrixHelp(y,:,1,1) = (P10 - pi01(iPi01))*ones(sizeOfSupportOfY,1);              
        matrixHelp(y,:,2,1) = (P11 - P10 + pi01(iPi01))*ones(sizeOfSupportOfY,1);   
        matrixDataAssumptionA2ii((y-1)*4+1,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);
        vectorDataAssumptionA2ii((y-1)*4+1,:) = probDistribution(y,1,1)/PZ(1);

        %equation (11)
        matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        matrixHelp(y,:,1,2) = (P10 - pi01(iPi01))*ones(sizeOfSupportOfY,1);              
        matrixHelp(y,:,3,2) = (pi01(iPi01))*ones(sizeOfSupportOfY,1);   
        matrixDataAssumptionA2ii((y-1)*4+2,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);
        vectorDataAssumptionA2ii((y-1)*4+2,:) = probDistribution(y,1,2)/PZ(2);

        %equation (12)
        matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        matrixHelp(:,y,3,1) = (pi01(iPi01))*ones(sizeOfSupportOfY,1);              
        matrixHelp(:,y,4,1) = (P01 - pi01(iPi01))*ones(sizeOfSupportOfY,1);   
        matrixDataAssumptionA2ii((y-1)*4+3,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);
        vectorDataAssumptionA2ii((y-1)*4+3,:) = probDistribution(y,2,1)/PZ(1);

        %equation (13)
        matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        matrixHelp(:,y,2,2) = (P11 - P10 + pi01(iPi01))*ones(sizeOfSupportOfY,1);              
        matrixHelp(:,y,4,2) = (P01 - pi01(iPi01))*ones(sizeOfSupportOfY,1);   
        matrixDataAssumptionA2ii((y-1)*4+4,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);
        vectorDataAssumptionA2ii((y-1)*4+4,:) = probDistribution(y,2,2)/PZ(2);
    end
    
    if assumption4
        %________________________________________________________________________
        %Phi is compatible with the assumption A4
        %matrixAssumptionA4
        matrixAssumptionA4 = zeros(sizeOfSupportOfD*2,sizeOfSupportOfYYTZ);
        vectorAssumptionA4 = zeros(sizeOfSupportOfD*2,1);

        matrixHelp  = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        for y1 = 1:sizeOfSupportOfY
            for y0 = 1:sizeOfSupportOfY    
                %for d=0 t=11
                matrixHelp(y1,y0,2,1) = supportOfOutcomeY(y0);
                matrixHelp(y1,y0,1,1) = -supportOfOutcomeY(y0);
                %matrixHelp(y1,y0,2,2) = supportOfOutcomeY(y0)*PZ(2)/(P11 - P10 + pi01);
                %matrixHelp(y1,y0,1,2) = -supportOfOutcomeY(y0)*PZ(2)/(P10 - pi01);
            end
        end
        matrixAssumptionA4(1,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

        matrixHelp  = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        for y1 = 1:sizeOfSupportOfY
            for y0 = 1:sizeOfSupportOfY
                %for d=0 t=00
                matrixHelp(y1,y0,2,1) = supportOfOutcomeY(y0);
                matrixHelp(y1,y0,4,1) = -supportOfOutcomeY(y0);
                %matrixHelp(y1,y0,2,2) = supportOfOutcomeY(y0)*PZ(2)/(P11 - P10 + pi01);
                end
        end
        matrixAssumptionA4(2,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

        matrixHelp  = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        for y1 = 1:sizeOfSupportOfY
            for y0 = 1:sizeOfSupportOfY
                %for d=1 t=11
                matrixHelp(y1,y0,2,1) = supportOfOutcomeY(y1);
                matrixHelp(y1,y0,1,1) = -supportOfOutcomeY(y1);
                %matrixHelp(y1,y0,2,2) = supportOfOutcomeY(y1)*PZ(2)/(P11 - P10 + pi01);
                %matrixHelp(y1,y0,1,2) = -supportOfOutcomeY(y1)*PZ(2)/(P10 - pi01);
            end
        end
        matrixAssumptionA4(3,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

        matrixHelp  = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
        for y1 = 1:sizeOfSupportOfY
            for y0 = 1:sizeOfSupportOfY
                %for d=1 t=00
                matrixHelp(y1,y0,2,1) = supportOfOutcomeY(y1);
                matrixHelp(y1,y0,4,1) = -supportOfOutcomeY(y1);
                %matrixHelp(y1,y0,2,2) = supportOfOutcomeY(y1)*PZ(2)/(P11 - P10 + pi01);
                %matrixHelp(y1,y0,4,2) = -supportOfOutcomeY(y1)*PZ(2)/(P01 - pi01);
            end
        end    
        matrixAssumptionA4(4,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);   
    end %end of assumption4

    %________________________________________________________________________
    %Phi sums up to 1
    %matrixProperDistribution
    matrixProperDistribution   = zeros(sizeOfSupportOfT*sizeOfSupportOfZ,sizeOfSupportOfYYTZ);
    vectorProperDistribution   = ones(sizeOfSupportOfT*sizeOfSupportOfZ,1);

    for z = 1:sizeOfSupportOfZ
        for t = 1:sizeOfSupportOfT
            matrixHelp                       = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
            matrixHelp(:,:,t,z)              = ones(sizeOfSupportOfY,sizeOfSupportOfY);
            matrixProperDistribution((z-1)*sizeOfSupportOfT+t,:) = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);
        end
    end

    %________________________________________________________________________
    %Phi is nonnegative
    %matrixNonNegativity
    matrixNonNegativity = -1*eye(sizeOfSupportOfYYTZ);
    vectorNonNegativity = zeros(sizeOfSupportOfYYTZ,1);

    %________________________________________________________________________
    %define matrices that define all linear equalities and inequalities
    %matrixOfEqualities * Phi = vectorOfEqualities
    matrixOfEqualities = [matrixAssumptionA2i; matrixDataAssumptionA2ii; matrixProperDistribution];
    vectorOfEqualities = [vectorAssumptionA2i; vectorDataAssumptionA2ii; vectorProperDistribution];

    %matrixOfInequalities * Phi <= vectorOfInequalities
    matrixOfInequalities = [matrixNonNegativity];
    vectorOfInequalities = [vectorNonNegativity];
    
    if assumption4
        matrixOfInequalities = [matrixOfInequalities; -matrixAssumptionA4];
        vectorOfInequalities = [vectorNonNegativity; vectorAssumptionA4];
    end

    %________________________________________________________________________
    %Define f vectors that we will optimize
    %ATE for entire population
    matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
    for y1 = 1:sizeOfSupportOfY
        for y0 = 1:sizeOfSupportOfY
            matrixHelp(y1,y0,1,1) = (P10 - pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1);
            matrixHelp(y1,y0,1,2) = (P10 - pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2);
            matrixHelp(y1,y0,2,1) = (P11 - P10 + pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1);
            matrixHelp(y1,y0,2,2) = (P11 - P10 + pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2);
            matrixHelp(y1,y0,3,1) = (pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1);
            matrixHelp(y1,y0,3,2) = (pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2);
            matrixHelp(y1,y0,4,1) = (P01 - pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1);
            matrixHelp(y1,y0,4,2) = (P01 - pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2);
        end
    end
    fForEntirePopulation = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

    %ATE for alwaystakers
    matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
    for y1 = 1:sizeOfSupportOfY
        for y0 = 1:sizeOfSupportOfY
            matrixHelp(y1,y0,1,1) = (supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1);
            matrixHelp(y1,y0,1,2) = (supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2);
        end
    end
    fForAlwaystakers = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

    %ATE for compliers
    matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
    for y1 = 1:sizeOfSupportOfY
        for y0 = 1:sizeOfSupportOfY
            matrixHelp(y1,y0,2,1) = (supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1);
            matrixHelp(y1,y0,2,2) = (supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2);
        end
    end
    fForCompliers = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

    %ATE for nevertakers
    matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
    for y1 = 1:sizeOfSupportOfY
        for y0 = 1:sizeOfSupportOfY
            matrixHelp(y1,y0,4,1) = (supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1);
            matrixHelp(y1,y0,4,2) = (supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2);
        end
    end
    fForNevertakers = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

    %ATE for treated population
    matrixHelp          = zeros(sizeOfSupportOfY,sizeOfSupportOfY,sizeOfSupportOfT,sizeOfSupportOfZ);
    denom = (P10 - pi) + (P11 - P10 + pi)*PZ(1) + (pi)*PZ(2);
    for y1 = 1:sizeOfSupportOfY
        for y0 = 1:sizeOfSupportOfY
            matrixHelp(y1,y0,1,1) = (P10 - pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1)/denom;
            matrixHelp(y1,y0,1,2) = (P10 - pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2)/denom;
            matrixHelp(y1,y0,2,1) = (P11 - P10 + pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(1)/denom;
            matrixHelp(y1,y0,3,2) = (pi01(iPi01))*(supportOfOutcomeY(y1)-supportOfOutcomeY(y0))*PZ(2)/denom;
        end
    end
    fForTreatedPopulation = reshape(matrixHelp,1,sizeOfSupportOfYYTZ);

    %________________________________________________________________________
    %run the linear programs
    options = optimset('linprog');
    options.LargeScale = 'off';
    options.Algorithm = 'simplex';
    options.Simplex = 'on';
    options.Display = 'off';

    %Create a structure called Problem.
    Problem = struct;
    Problem.Aineq = matrixOfInequalities;
    Problem.bineq = vectorOfInequalities;
    Problem.Aeq = matrixOfEqualities;
    Problem.beq = vectorOfEqualities;
    Problem.lb = [];
    Problem.ub = [];
    Problem.x0 = [];
    Problem.solver = 'linprog';
    Problem.options = options;

    Problem.f = fForEntirePopulation;
    [solutionToMinAteForEntirePopulation(:,iPi01),lowerBoundOnAteForEntirePopulation(iPi01)] = linprog(Problem);
    Problem.f = -fForEntirePopulation;
    [solutionToMaxAteForEntirePopulation(:,iPi01),upperBoundOnAteForEntirePopulation(iPi01)] = linprog(Problem);

    Problem.f = fForAlwaystakers;
    [solutionToMinAteForAlwaystakers(:,iPi01),lowerBoundOnAteForAlwaystakers(iPi01)] = linprog(Problem);
    Problem.f = -fForAlwaystakers;
    [solutionToMaxAteForAlwaystakers(:,iPi01),upperBoundOnAteForAlwaystakers(iPi01)] = linprog(Problem);

    Problem.f = fForCompliers;
    [solutionToMinAteForCompliers(:,iPi01),lowerBoundOnAteForCompliers(iPi01)] = linprog(Problem);
    Problem.f = -fForCompliers;
    [solutionToMaxAteForCompliers(:,iPi01),upperBoundOnAteForCompliers(iPi01)] = linprog(Problem);

    Problem.f = fForNevertakers;
    [solutionToMinAteForNevertakers(:,iPi01),lowerBoundOnAteForNevertakers(iPi01)] = linprog(Problem);
    Problem.f = -fForNevertakers;
    [solutionToMaxAteForNevertakers(:,iPi01),upperBoundOnAteForNevertakers(iPi01)] = linprog(Problem);

    Problem.f = fForTreatedPopulation;
    [solutionToMinAteForTreatedPopulation(:,iPi01),lowerBoundOnAteForTreatedPopulation(iPi01)] = linprog(Problem);
    Problem.f = -fForTreatedPopulation;
    [solutionToMaxAteForTreatedPopulation(:,iPi01),upperBoundOnAteForTreatedPopulation(iPi01)] = linprog(Problem);
end

%Save the bounds and optimal solutions to structure Bounds.
%We have to take the minimum and maximum across different values for pi01.
Bounds = struct;
Bounds.EntirePopulation.lowerBound = min(lowerBoundOnAteForEntirePopulation);
Bounds.EntirePopulation.upperBound = -min(upperBoundOnAteForEntirePopulation);
[~,minimizer] = min(lowerBoundOnAteForEntirePopulation);
[~,maximizer] = min(upperBoundOnAteForEntirePopulation);
Bounds.EntirePopulation.solutionToMin = solutionToMinAteForEntirePopulation(:,minimizer);
Bounds.EntirePopulation.solutionToMax = solutionToMaxAteForEntirePopulation(:,maximizer);

Bounds.Alwaystakers.lowerBound = min(lowerBoundOnAteForAlwaystakers);
Bounds.Alwaystakers.upperBound = -min(upperBoundOnAteForAlwaystakers);
[~,minimizer] = min(lowerBoundOnAteForEntirePopulation);
[~,maximizer] = min(upperBoundOnAteForEntirePopulation);
Bounds.Alwaystakers.solutionToMin = solutionToMinAteForAlwaystakers(:,minimizer);
Bounds.Alwaystakers.solutionToMax = solutionToMaxAteForAlwaystakers(:,maximizer);

Bounds.Compliers.lowerBound = min(lowerBoundOnAteForCompliers);
Bounds.Compliers.upperBound = -min(upperBoundOnAteForCompliers);
[~,minimizer] = min(lowerBoundOnAteForEntirePopulation);
[~,maximizer] = min(upperBoundOnAteForEntirePopulation);
Bounds.Compliers.solutionToMin = solutionToMinAteForCompliers(:,minimizer);
Bounds.Compliers.solutionToMax = solutionToMaxAteForCompliers(:,maximizer);

Bounds.Nevertakers.lowerBound = min(lowerBoundOnAteForNevertakers);
Bounds.Nevertakers.upperBound = -min(upperBoundOnAteForNevertakers);
[~,minimizer] = min(lowerBoundOnAteForEntirePopulation);
[~,maximizer] = min(upperBoundOnAteForEntirePopulation);
Bounds.Nevertakers.solutionToMin = solutionToMinAteForNevertakers(:,minimizer);
Bounds.Nevertakers.solutionToMax = solutionToMaxAteForNevertakers(:,maximizer);

Bounds.TreatedPopulation.lowerBound = min(lowerBoundOnAteForTreatedPopulation);
Bounds.TreatedPopulation.upperBound = -min(upperBoundOnAteForTreatedPopulation);
[~,minimizer] = min(lowerBoundOnAteForEntirePopulation);
[~,maximizer] = min(upperBoundOnAteForEntirePopulation);
Bounds.TreatedPopulation.solutionToMin = solutionToMinAteForTreatedPopulation(:,minimizer);
Bounds.TreatedPopulation.solutionToMax = solutionToMaxAteForTreatedPopulation(:,maximizer);