load Newdata
%Now we loaded the following variables
%y1 - highest grade achieved
%y2 - never repeated a grade
%t - treatment - private school attended
%z - instrument (school voucher) offered

y = y1;
supportOfOutcomeY = unique(y)';
dataset = [y,t,z];

nObservations = length(y);

%Size of the support of variables.
sizeOfSupportOfY = size(supportOfOutcomeY,2);  %Outcome.
sizeOfSupportOfD = 2;                          %Treatment.
sizeOfSupportOfZ = 2;                          %Instrument.
sizeOfSupportOfT = 4;                          %Type.

PYDZ = zeros(sizeOfSupportOfY,sizeOfSupportOfD,sizeOfSupportOfZ); %observed distribution
for i = 1:sizeOfSupportOfY
    PYDZ(i,1,1) = sum((y==supportOfOutcomeY(i)).*t.*z)/nObservations;
    PYDZ(i,1,2) = sum((y==supportOfOutcomeY(i)).*t.*(1-z))/nObservations;
    PYDZ(i,2,1) = sum((y==supportOfOutcomeY(i)).*(1-t).*z)/nObservations;
    PYDZ(i,2,2) = sum((y==supportOfOutcomeY(i)).*(1-t).*(1-z))/nObservations;
end

PDZ = sum(PYDZ);        %probability of (D,Z)
PZ  = sum(PDZ);         %probability of Z
P11 = PDZ(1,1,1)/PZ(1); %probability of D=1 given Z=1
P10 = PDZ(1,1,2)/PZ(2); %
P01 = PDZ(1,2,1)/PZ(1); %
P00 = PDZ(1,2,2)/PZ(2); %

probDistribution = PYDZ;