function identifiedsetisaninterval(lowerBound,upperBound,sizeGrid,probDistribution,supportOfOutcomeY,assumption4)

%demonstrates that a identified set for the share of defiers is an interval
%INPUT:  lowerBound - left point of an interval 
%        upperBound - right point of an interval
%        sieGrid - size of the grid
%        probDistribution - probability distribution of (outcome,treatment,instrument)
%        supportOfOutcomeY
%        assumption4 - optional argument, is equal to 1 if assumption 4
%        holds (mean dominance).
%OUTPUT: [none]

%assumption4
if nargin<5
    assumption4 = 0;
end

tic

isLowerBoundInIdentifiedSet = isintheidentifiedset(probDistribution,lowerBound,supportOfOutcomeY,assumption4);
isUpperBoundInIdentifiedSet = isintheidentifiedset(probDistribution,upperBound,supportOfOutcomeY,assumption4);

vectorPi01 = lowerBound:((upperBound-lowerBound)/(sizeGrid-1)):upperBound;
vectorIsInTheIdentifiedSet = zeros(1,sizeGrid);

if isLowerBoundInIdentifiedSet && isUpperBoundInIdentifiedSet
    disp(sprintf('\n'));
    display(['Both ',num2str(lowerBound),' and ',num2str(upperBound),' are admissible values for the share of defiers.'])
    for iPi01 = 1:sizeGrid
        vectorIsInTheIdentifiedSet(iPi01) = isintheidentifiedset(probDistribution,vectorPi01(iPi01),supportOfOutcomeY,assumption4);
    end
else
    display('One of the initial values or both are not admissible for the share of defiers.')
    return
end

if sum(vectorIsInTheIdentifiedSet==1)==sizeGrid
    display(['All the ',num2str(sizeGrid),' equidistant values between ',num2str(lowerBound),' and ',num2str(upperBound),' are admissible.'])
else
    isAnInterval = 1;
    for j = find(~vectorIsInTheIdentifiedSet)
        isAnInterval = isAnInterval*isintheidentifiedset(probDistribution,vectorPi01(j)-0.0000001,supportOfOutcomeY);
        isAnInterval = isAnInterval*isintheidentifiedset(probDistribution,vectorPi01(j)+0.0000001,supportOfOutcomeY);
    end
    if isAnInterval
        display(['All the ',num2str(sizeGrid),' equidistant values between ',num2str(lowerBound),' and ',num2str(upperBound),' are admissible.'])
        display(['There were ',num2str(sum(~vectorIsInTheIdentifiedSet)),' cases where numerical instability was detected.']);
    else
        display(['There exists a value for pi01 between ',num2str(lowerBound),' and ',num2str(upperBound),' that is not admissible.'])

    end
end

toc